/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationProvider;
import org.apache.nifi.web.security.configuration.JwtAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.KerberosAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.KnoxAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.OidcAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.SamlAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.X509AuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.spring.LoginIdentityProviderFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={JwtAuthenticationSecurityConfiguration.class, KerberosAuthenticationSecurityConfiguration.class, KnoxAuthenticationSecurityConfiguration.class, OidcAuthenticationSecurityConfiguration.class, SamlAuthenticationSecurityConfiguration.class, X509AuthenticationSecurityConfiguration.class})
public class AuthenticationSecurityConfiguration {
    private final NiFiProperties niFiProperties;
    private final ExtensionManager extensionManager;
    private final Authorizer authorizer;

    @Autowired
    public AuthenticationSecurityConfiguration(NiFiProperties niFiProperties, ExtensionManager extensionManager, Authorizer authorizer) {
        this.niFiProperties = niFiProperties;
        this.extensionManager = extensionManager;
        this.authorizer = authorizer;
    }

    @Bean
    public LoginIdentityProviderFactoryBean loginIdentityProviderFactoryBean() {
        LoginIdentityProviderFactoryBean loginIdentityProviderFactoryBean = new LoginIdentityProviderFactoryBean();
        loginIdentityProviderFactoryBean.setProperties(this.niFiProperties);
        loginIdentityProviderFactoryBean.setExtensionManager(this.extensionManager);
        return loginIdentityProviderFactoryBean;
    }

    @Bean
    public Object loginIdentityProvider() throws Exception {
        return this.loginIdentityProviderFactoryBean().getObject();
    }

    @Bean
    public LogoutRequestManager logoutRequestManager() {
        return new LogoutRequestManager();
    }

    @Bean
    public NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider() {
        return new NiFiAnonymousAuthenticationProvider(this.niFiProperties, this.authorizer);
    }
}

