/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import org.apache.nifi.admin.service.IdpCredentialService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.saml.SAMLService;
import org.apache.nifi.web.security.saml.impl.StandardSAMLConfigurationFactory;
import org.apache.nifi.web.security.saml.impl.StandardSAMLCredentialStore;
import org.apache.nifi.web.security.saml.impl.StandardSAMLService;
import org.apache.nifi.web.security.saml.impl.StandardSAMLStateManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SamlAuthenticationSecurityConfiguration {
    private final NiFiProperties niFiProperties;
    private final BearerTokenProvider bearerTokenProvider;
    private final IdpCredentialService idpCredentialService;

    @Autowired
    public SamlAuthenticationSecurityConfiguration(NiFiProperties niFiProperties, BearerTokenProvider bearerTokenProvider, IdpCredentialService idpCredentialService) {
        this.niFiProperties = niFiProperties;
        this.bearerTokenProvider = bearerTokenProvider;
        this.idpCredentialService = idpCredentialService;
    }

    @Bean(initMethod="initialize", destroyMethod="shutdown")
    public SAMLService samlService() {
        return new StandardSAMLService(this.samlConfigurationFactory(), this.niFiProperties);
    }

    @Bean
    public StandardSAMLStateManager samlStateManager() {
        return new StandardSAMLStateManager(this.bearerTokenProvider);
    }

    @Bean
    public StandardSAMLCredentialStore samlCredentialStore() {
        return new StandardSAMLCredentialStore(this.idpCredentialService);
    }

    @Bean
    public StandardSAMLConfigurationFactory samlConfigurationFactory() {
        return new StandardSAMLConfigurationFactory();
    }
}

