/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.knox.KnoxConfiguration;

public class StandardKnoxConfiguration
implements KnoxConfiguration {
    private final NiFiProperties properties;

    public StandardKnoxConfiguration(NiFiProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean isKnoxEnabled() {
        return this.properties.isKnoxSsoEnabled();
    }

    @Override
    public String getKnoxUrl() {
        return this.properties.getKnoxUrl();
    }

    @Override
    public Set<String> getAudiences() {
        return this.properties.getKnoxAudiences();
    }

    @Override
    public String getKnoxCookieName() {
        return this.properties.getKnoxCookieName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RSAPublicKey getKnoxPublicKey() {
        Path knoxPublicKeyPath = this.properties.getKnoxPublicKeyPath();
        if (Files.isRegularFile(knoxPublicKeyPath, new LinkOption[0]) && Files.exists(knoxPublicKeyPath, new LinkOption[0])) {
            try (InputStream publicKeyStream = Files.newInputStream(knoxPublicKeyPath, new OpenOption[0]);){
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(publicKeyStream);
                RSAPublicKey rSAPublicKey = (RSAPublicKey)certificate.getPublicKey();
                return rSAPublicKey;
            }
            catch (IOException | CertificateException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new RuntimeException(String.format("The specified Knox public key path does not exist '%s'", knoxPublicKeyPath.toString()));
    }
}

