/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl;

import java.util.Objects;
import java.util.Timer;
import org.apache.nifi.web.security.saml.NiFiSAMLContextProvider;
import org.apache.nifi.web.security.saml.SAMLConfiguration;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileOptions;

public class StandardSAMLConfiguration
implements SAMLConfiguration {
    private final String spEntityId;
    private final SAMLProcessor processor;
    private final NiFiSAMLContextProvider contextProvider;
    private final SAMLLogger logger;
    private final WebSSOProfileOptions webSSOProfileOptions;
    private final WebSSOProfile webSSOProfile;
    private final WebSSOProfile webSSOProfileECP;
    private final WebSSOProfile webSSOProfileHoK;
    private final WebSSOProfileConsumer webSSOProfileConsumer;
    private final WebSSOProfileConsumer webSSOProfileHoKConsumer;
    private final SingleLogoutProfile singleLogoutProfile;
    private final ExtendedMetadata extendedMetadata;
    private final MetadataManager metadataManager;
    private final KeyManager keyManager;
    private final Timer backgroundTaskTimer;
    private final long authExpiration;
    private final String identityAttributeName;
    private final String groupAttributeName;
    private final boolean requestSigningEnabled;
    private final boolean wantAssertionsSigned;

    private StandardSAMLConfiguration(Builder builder) {
        this.spEntityId = Objects.requireNonNull(builder.spEntityId);
        this.processor = Objects.requireNonNull(builder.processor);
        this.contextProvider = Objects.requireNonNull(builder.contextProvider);
        this.logger = Objects.requireNonNull(builder.logger);
        this.webSSOProfileOptions = Objects.requireNonNull(builder.webSSOProfileOptions);
        this.webSSOProfile = Objects.requireNonNull(builder.webSSOProfile);
        this.webSSOProfileECP = Objects.requireNonNull(builder.webSSOProfileECP);
        this.webSSOProfileHoK = Objects.requireNonNull(builder.webSSOProfileHoK);
        this.webSSOProfileConsumer = Objects.requireNonNull(builder.webSSOProfileConsumer);
        this.webSSOProfileHoKConsumer = Objects.requireNonNull(builder.webSSOProfileHoKConsumer);
        this.singleLogoutProfile = Objects.requireNonNull(builder.singleLogoutProfile);
        this.extendedMetadata = Objects.requireNonNull(builder.extendedMetadata);
        this.metadataManager = Objects.requireNonNull(builder.metadataManager);
        this.keyManager = Objects.requireNonNull(builder.keyManager);
        this.backgroundTaskTimer = Objects.requireNonNull(builder.backgroundTaskTimer);
        this.authExpiration = builder.authExpiration;
        this.identityAttributeName = builder.identityAttributeName;
        this.groupAttributeName = builder.groupAttributeName;
        this.requestSigningEnabled = builder.requestSigningEnabled;
        this.wantAssertionsSigned = builder.wantAssertionsSigned;
    }

    @Override
    public String getSpEntityId() {
        return this.spEntityId;
    }

    @Override
    public SAMLProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public NiFiSAMLContextProvider getContextProvider() {
        return this.contextProvider;
    }

    @Override
    public SAMLLogger getLogger() {
        return this.logger;
    }

    @Override
    public WebSSOProfileOptions getWebSSOProfileOptions() {
        return this.webSSOProfileOptions;
    }

    @Override
    public WebSSOProfile getWebSSOProfile() {
        return this.webSSOProfile;
    }

    @Override
    public WebSSOProfile getWebSSOProfileECP() {
        return this.webSSOProfileECP;
    }

    @Override
    public WebSSOProfile getWebSSOProfileHoK() {
        return this.webSSOProfileHoK;
    }

    @Override
    public WebSSOProfileConsumer getWebSSOProfileConsumer() {
        return this.webSSOProfileConsumer;
    }

    @Override
    public WebSSOProfileConsumer getWebSSOProfileHoKConsumer() {
        return this.webSSOProfileHoKConsumer;
    }

    @Override
    public SingleLogoutProfile getSingleLogoutProfile() {
        return this.singleLogoutProfile;
    }

    @Override
    public ExtendedMetadata getExtendedMetadata() {
        return this.extendedMetadata;
    }

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @Override
    public Timer getBackgroundTaskTimer() {
        return this.backgroundTaskTimer;
    }

    @Override
    public long getAuthExpiration() {
        return this.authExpiration;
    }

    @Override
    public String getIdentityAttributeName() {
        return this.identityAttributeName;
    }

    @Override
    public String getGroupAttributeName() {
        return this.groupAttributeName;
    }

    @Override
    public boolean isRequestSigningEnabled() {
        return this.requestSigningEnabled;
    }

    @Override
    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    public static class Builder {
        private String spEntityId;
        private SAMLProcessor processor;
        private NiFiSAMLContextProvider contextProvider;
        private SAMLLogger logger;
        private WebSSOProfileOptions webSSOProfileOptions;
        private WebSSOProfile webSSOProfile;
        private WebSSOProfile webSSOProfileECP;
        private WebSSOProfile webSSOProfileHoK;
        private WebSSOProfileConsumer webSSOProfileConsumer;
        private WebSSOProfileConsumer webSSOProfileHoKConsumer;
        private SingleLogoutProfile singleLogoutProfile;
        private ExtendedMetadata extendedMetadata;
        private MetadataManager metadataManager;
        private KeyManager keyManager;
        private Timer backgroundTaskTimer;
        private long authExpiration;
        private String groupAttributeName;
        private String identityAttributeName;
        private boolean requestSigningEnabled;
        private boolean wantAssertionsSigned;

        public Builder spEntityId(String spEntityId) {
            this.spEntityId = spEntityId;
            return this;
        }

        public Builder processor(SAMLProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Builder contextProvider(NiFiSAMLContextProvider contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        public Builder logger(SAMLLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder webSSOProfileOptions(WebSSOProfileOptions webSSOProfileOptions) {
            this.webSSOProfileOptions = webSSOProfileOptions;
            return this;
        }

        public Builder webSSOProfile(WebSSOProfile webSSOProfile) {
            this.webSSOProfile = webSSOProfile;
            return this;
        }

        public Builder webSSOProfileECP(WebSSOProfile webSSOProfileECP) {
            this.webSSOProfileECP = webSSOProfileECP;
            return this;
        }

        public Builder webSSOProfileHoK(WebSSOProfile webSSOProfileHoK) {
            this.webSSOProfileHoK = webSSOProfileHoK;
            return this;
        }

        public Builder webSSOProfileConsumer(WebSSOProfileConsumer webSSOProfileConsumer) {
            this.webSSOProfileConsumer = webSSOProfileConsumer;
            return this;
        }

        public Builder webSSOProfileHoKConsumer(WebSSOProfileConsumer webSSOProfileHoKConsumer) {
            this.webSSOProfileHoKConsumer = webSSOProfileHoKConsumer;
            return this;
        }

        public Builder singleLogoutProfile(SingleLogoutProfile singleLogoutProfile) {
            this.singleLogoutProfile = singleLogoutProfile;
            return this;
        }

        public Builder extendedMetadata(ExtendedMetadata extendedMetadata) {
            this.extendedMetadata = extendedMetadata;
            return this;
        }

        public Builder metadataManager(MetadataManager metadataManager) {
            this.metadataManager = metadataManager;
            return this;
        }

        public Builder keyManager(KeyManager keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public Builder backgroundTaskTimer(Timer backgroundTaskTimer) {
            this.backgroundTaskTimer = backgroundTaskTimer;
            return this;
        }

        public Builder authExpiration(long authExpiration) {
            this.authExpiration = authExpiration;
            return this;
        }

        public Builder identityAttributeName(String identityAttributeName) {
            this.identityAttributeName = identityAttributeName;
            return this;
        }

        public Builder groupAttributeName(String groupAttributeName) {
            this.groupAttributeName = groupAttributeName;
            return this;
        }

        public Builder requestSigningEnabled(boolean requestSigningEnabled) {
            this.requestSigningEnabled = requestSigningEnabled;
            return this;
        }

        public Builder wantAssertionsSigned(boolean wantAssertionsSigned) {
            this.wantAssertionsSigned = wantAssertionsSigned;
            return this;
        }

        public SAMLConfiguration build() {
            return new StandardSAMLConfiguration(this);
        }
    }
}

