/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl;

import java.io.File;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.saml.NiFiSAMLContextProvider;
import org.apache.nifi.web.security.saml.SAMLConfiguration;
import org.apache.nifi.web.security.saml.SAMLConfigurationFactory;
import org.apache.nifi.web.security.saml.impl.NiFiSAMLContextProviderImpl;
import org.apache.nifi.web.security.saml.impl.StandardSAMLConfiguration;
import org.apache.nifi.web.security.saml.impl.tls.CompositeKeyManager;
import org.apache.nifi.web.security.saml.impl.tls.CustomTLSProtocolSocketFactory;
import org.apache.nifi.web.security.saml.impl.tls.TruststoreStrategy;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.BasicSecurityConfiguration;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.storage.EmptyStorageFactory;
import org.springframework.security.saml.storage.SAMLMessageStorageFactory;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.SingleLogoutProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfileOptions;

public class StandardSAMLConfigurationFactory
implements SAMLConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardSAMLConfigurationFactory.class);

    @Override
    public SAMLConfiguration create(NiFiProperties properties) throws Exception {
        int readTimeout;
        int connectTimeout;
        TruststoreStrategy truststoreStrategy;
        String groupAttributeName;
        long authExpiration;
        if (properties.isOidcEnabled() || properties.isKnoxSsoEnabled() || properties.isLoginIdentityProviderEnabled()) {
            throw new RuntimeException("SAML cannot be enabled if the Login Identity Provider or OpenId Connect or KnoxSSO is configured.");
        }
        LOGGER.info("Initializing SAML configuration...");
        String rawEntityId = properties.getSamlServiceProviderEntityId();
        if (StringUtils.isBlank((String)rawEntityId)) {
            throw new RuntimeException("Entity ID is required when configuring SAML");
        }
        String spEntityId = rawEntityId;
        LOGGER.info("Service Provider Entity ID = '{}'", (Object)spEntityId);
        String rawIdpMetadataUrl = properties.getSamlIdentityProviderMetadataUrl();
        if (StringUtils.isBlank((String)rawIdpMetadataUrl)) {
            throw new RuntimeException("IDP Metadata URL is required when configuring SAML");
        }
        if (!(rawIdpMetadataUrl.startsWith("file://") || rawIdpMetadataUrl.startsWith("http://") || rawIdpMetadataUrl.startsWith("https://"))) {
            throw new RuntimeException("IDP Medata URL must start with file://, http://, or https://");
        }
        URI idpMetadataLocation = URI.create(rawIdpMetadataUrl);
        LOGGER.info("Identity Provider Metadata Location = '{}'", (Object)idpMetadataLocation);
        String authExpirationFromProperties = properties.getSamlAuthenticationExpiration();
        LOGGER.info("Authentication Expiration = '{}'", (Object)authExpirationFromProperties);
        try {
            authExpiration = Math.round(FormatUtils.getPreciseTimeDuration((String)authExpirationFromProperties, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid SAML authentication expiration: " + authExpirationFromProperties);
        }
        String identityAttributeName = properties.getSamlIdentityAttributeName();
        if (!StringUtils.isBlank((String)identityAttributeName)) {
            LOGGER.info("Identity Attribute Name = '{}'", (Object)identityAttributeName);
        }
        if (!StringUtils.isBlank((String)(groupAttributeName = properties.getSamlGroupAttributeName()))) {
            LOGGER.info("Group Attribute Name = '{}'", (Object)groupAttributeName);
        }
        try {
            truststoreStrategy = TruststoreStrategy.valueOf(properties.getSamlHttpClientTruststoreStrategy());
            LOGGER.info("HttpClient Truststore Strategy = `{}`", (Object)truststoreStrategy.name());
        }
        catch (Exception e) {
            throw new RuntimeException("Truststore Strategy must be one of " + TruststoreStrategy.NIFI.name() + " or " + TruststoreStrategy.JDK.name());
        }
        String rawConnectTimeout = properties.getSamlHttpClientConnectTimeout();
        try {
            connectTimeout = (int)FormatUtils.getPreciseTimeDuration((String)rawConnectTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse value of property '{}' as a valid time period. Value was '{}'. Ignoring this value and using the default value of '{}'", new Object[]{"nifi.security.user.saml.http.client.connect.timeout", rawConnectTimeout, "30 secs"});
            connectTimeout = (int)FormatUtils.getPreciseTimeDuration((String)"30 secs", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        String rawReadTimeout = properties.getSamlHttpClientReadTimeout();
        try {
            readTimeout = (int)FormatUtils.getPreciseTimeDuration((String)rawReadTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse value of property '{}' as a valid time period. Value was '{}'. Ignoring this value and using the default value of '{}'", new Object[]{"nifi.security.user.saml.http.client.read.timeout", rawReadTimeout, "30 secs"});
            readTimeout = (int)FormatUtils.getPreciseTimeDuration((String)"30 secs", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        SAMLBootstrap samlBootstrap = new SAMLBootstrap();
        samlBootstrap.postProcessBeanFactory(null);
        ParserPool parserPool = StandardSAMLConfigurationFactory.createParserPool();
        VelocityEngine velocityEngine = VelocityFactory.getEngine();
        TlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)properties);
        KeyManager keyManager = StandardSAMLConfigurationFactory.createKeyManager(tlsConfiguration);
        HttpClient httpClient = StandardSAMLConfigurationFactory.createHttpClient(connectTimeout, readTimeout);
        if (truststoreStrategy == TruststoreStrategy.NIFI) {
            StandardSAMLConfigurationFactory.configureCustomTLSSocketFactory(tlsConfiguration);
        }
        boolean signMetadata = properties.isSamlMetadataSigningEnabled();
        String signatureAlgorithm = properties.getSamlSignatureAlgorithm();
        String signatureDigestAlgorithm = properties.getSamlSignatureDigestAlgorithm();
        StandardSAMLConfigurationFactory.configureGlobalSecurityDefaults(keyManager, signatureAlgorithm, signatureDigestAlgorithm);
        ExtendedMetadata extendedMetadata = StandardSAMLConfigurationFactory.createExtendedMetadata(signatureAlgorithm, signMetadata);
        Timer backgroundTaskTimer = new Timer(true);
        MetadataProvider idpMetadataProvider = StandardSAMLConfigurationFactory.createIdpMetadataProvider(idpMetadataLocation, httpClient, backgroundTaskTimer, parserPool);
        MetadataManager metadataManager = StandardSAMLConfigurationFactory.createMetadataManager(idpMetadataProvider, extendedMetadata, keyManager);
        SAMLProcessor processor = StandardSAMLConfigurationFactory.createSAMLProcessor(parserPool, velocityEngine, httpClient);
        NiFiSAMLContextProvider contextProvider = StandardSAMLConfigurationFactory.createContextProvider(metadataManager, keyManager);
        return new StandardSAMLConfiguration.Builder().spEntityId(spEntityId).processor(processor).contextProvider(contextProvider).logger(StandardSAMLConfigurationFactory.createSAMLLogger(properties)).webSSOProfileOptions(StandardSAMLConfigurationFactory.createWebSSOProfileOptions()).webSSOProfile(StandardSAMLConfigurationFactory.createWebSSOProfile(metadataManager, processor)).webSSOProfileECP(StandardSAMLConfigurationFactory.createWebSSOProfileECP(metadataManager, processor)).webSSOProfileHoK(StandardSAMLConfigurationFactory.createWebSSOProfileHok(metadataManager, processor)).webSSOProfileConsumer(StandardSAMLConfigurationFactory.createWebSSOProfileConsumer(metadataManager, processor)).webSSOProfileHoKConsumer(StandardSAMLConfigurationFactory.createWebSSOProfileHokConsumer(metadataManager, processor)).singleLogoutProfile(StandardSAMLConfigurationFactory.createSingeLogoutProfile(metadataManager, processor)).metadataManager(metadataManager).extendedMetadata(extendedMetadata).backgroundTaskTimer(backgroundTaskTimer).keyManager(keyManager).authExpiration(authExpiration).identityAttributeName(identityAttributeName).groupAttributeName(groupAttributeName).requestSigningEnabled(properties.isSamlRequestSigningEnabled()).wantAssertionsSigned(properties.isSamlWantAssertionsSigned()).build();
    }

    private static ParserPool createParserPool() throws XMLParserException {
        StaticBasicParserPool parserPool = new StaticBasicParserPool();
        parserPool.initialize();
        return parserPool;
    }

    private static HttpClient createHttpClient(int connectTimeout, int readTimeout) {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setParameter("http.connection.timeout", (Object)connectTimeout);
        clientParams.setParameter("http.socket.timeout", (Object)readTimeout);
        HttpClient httpClient = new HttpClient(clientParams);
        return httpClient;
    }

    private static void configureCustomTLSSocketFactory(TlsConfiguration tlsConfiguration) throws TlsException {
        SSLSocketFactory sslSocketFactory = SslContextFactory.createSSLSocketFactory((TlsConfiguration)tlsConfiguration);
        CustomTLSProtocolSocketFactory socketFactory = new CustomTLSProtocolSocketFactory(sslSocketFactory);
        Protocol p = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
        Protocol.registerProtocol((String)p.getScheme(), (Protocol)p);
    }

    private static SAMLProcessor createSAMLProcessor(ParserPool parserPool, VelocityEngine velocityEngine, HttpClient httpClient) {
        HTTPSOAP11Binding httpsoap11Binding = new HTTPSOAP11Binding(parserPool);
        HTTPPAOS11Binding httppaos11Binding = new HTTPPAOS11Binding(parserPool);
        HTTPPostBinding httpPostBinding = new HTTPPostBinding(parserPool, velocityEngine);
        HTTPRedirectDeflateBinding httpRedirectDeflateBinding = new HTTPRedirectDeflateBinding(parserPool);
        ArtifactResolutionProfileImpl artifactResolutionProfile = new ArtifactResolutionProfileImpl(httpClient);
        artifactResolutionProfile.setProcessor((SAMLProcessor)new SAMLProcessorImpl((SAMLBinding)httpsoap11Binding));
        HTTPArtifactBinding httpArtifactBinding = new HTTPArtifactBinding(parserPool, velocityEngine, (ArtifactResolutionProfile)artifactResolutionProfile);
        ArrayList<Object> bindings = new ArrayList<Object>();
        bindings.add(httpRedirectDeflateBinding);
        bindings.add(httpPostBinding);
        bindings.add(httpArtifactBinding);
        bindings.add(httpsoap11Binding);
        bindings.add(httppaos11Binding);
        return new SAMLProcessorImpl(bindings);
    }

    private static NiFiSAMLContextProvider createContextProvider(MetadataManager metadataManager, KeyManager keyManager) throws ServletException {
        NiFiSAMLContextProviderImpl contextProvider = new NiFiSAMLContextProviderImpl();
        contextProvider.setMetadata(metadataManager);
        contextProvider.setKeyManager(keyManager);
        contextProvider.setStorageFactory((SAMLMessageStorageFactory)new EmptyStorageFactory());
        contextProvider.afterPropertiesSet();
        return contextProvider;
    }

    private static WebSSOProfileOptions createWebSSOProfileOptions() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        return webSSOProfileOptions;
    }

    private static WebSSOProfile createWebSSOProfile(MetadataManager metadataManager, SAMLProcessor processor) throws Exception {
        WebSSOProfileImpl webSSOProfile = new WebSSOProfileImpl(processor, metadataManager);
        webSSOProfile.afterPropertiesSet();
        return webSSOProfile;
    }

    private static WebSSOProfile createWebSSOProfileECP(MetadataManager metadataManager, SAMLProcessor processor) throws Exception {
        WebSSOProfileECPImpl webSSOProfileECP = new WebSSOProfileECPImpl();
        webSSOProfileECP.setProcessor(processor);
        webSSOProfileECP.setMetadata(metadataManager);
        webSSOProfileECP.afterPropertiesSet();
        return webSSOProfileECP;
    }

    private static WebSSOProfile createWebSSOProfileHok(MetadataManager metadataManager, SAMLProcessor processor) throws Exception {
        WebSSOProfileHoKImpl webSSOProfileHok = new WebSSOProfileHoKImpl();
        webSSOProfileHok.setProcessor(processor);
        webSSOProfileHok.setMetadata(metadataManager);
        webSSOProfileHok.afterPropertiesSet();
        return webSSOProfileHok;
    }

    private static WebSSOProfileConsumer createWebSSOProfileConsumer(MetadataManager metadataManager, SAMLProcessor processor) throws Exception {
        WebSSOProfileConsumerImpl webSSOProfileConsumer = new WebSSOProfileConsumerImpl();
        webSSOProfileConsumer.setProcessor(processor);
        webSSOProfileConsumer.setMetadata(metadataManager);
        webSSOProfileConsumer.afterPropertiesSet();
        return webSSOProfileConsumer;
    }

    private static WebSSOProfileConsumer createWebSSOProfileHokConsumer(MetadataManager metadataManager, SAMLProcessor processor) throws Exception {
        WebSSOProfileConsumerHoKImpl webSSOProfileHoKConsumer = new WebSSOProfileConsumerHoKImpl();
        webSSOProfileHoKConsumer.setProcessor(processor);
        webSSOProfileHoKConsumer.setMetadata(metadataManager);
        webSSOProfileHoKConsumer.afterPropertiesSet();
        return webSSOProfileHoKConsumer;
    }

    private static SingleLogoutProfile createSingeLogoutProfile(MetadataManager metadataManager, SAMLProcessor processor) throws Exception {
        SingleLogoutProfileImpl singleLogoutProfile = new SingleLogoutProfileImpl();
        singleLogoutProfile.setProcessor(processor);
        singleLogoutProfile.setMetadata(metadataManager);
        singleLogoutProfile.afterPropertiesSet();
        return singleLogoutProfile;
    }

    private static SAMLLogger createSAMLLogger(NiFiProperties properties) {
        SAMLDefaultLogger samlLogger = new SAMLDefaultLogger();
        if (properties.isSamlMessageLoggingEnabled()) {
            samlLogger.setLogAllMessages(true);
            samlLogger.setLogErrors(true);
            samlLogger.setLogMessagesOnException(true);
        } else {
            samlLogger.setLogAllMessages(false);
            samlLogger.setLogErrors(false);
            samlLogger.setLogMessagesOnException(false);
        }
        return samlLogger;
    }

    private static KeyManager createKeyManager(TlsConfiguration tlsConfiguration) throws TlsException, KeyStoreException {
        String keystorePath = tlsConfiguration.getKeystorePath();
        char[] keystorePasswordChars = tlsConfiguration.getKeystorePassword().toCharArray();
        String keystoreType = tlsConfiguration.getKeystoreType().getType();
        String truststorePath = tlsConfiguration.getTruststorePath();
        char[] truststorePasswordChars = tlsConfiguration.getTruststorePassword().toCharArray();
        String truststoreType = tlsConfiguration.getTruststoreType().getType();
        KeyStore keyStore = KeyStoreUtils.loadKeyStore((String)keystorePath, (char[])keystorePasswordChars, (String)keystoreType);
        KeyStore trustStore = KeyStoreUtils.loadTrustStore((String)truststorePath, (char[])truststorePasswordChars, (String)truststoreType);
        String keyAlias = StandardSAMLConfigurationFactory.getPrivateKeyAlias(keyStore, keystorePath);
        LOGGER.info("Default key alias = {}", (Object)keyAlias);
        String keyPassword = StringUtils.isBlank((String)tlsConfiguration.getKeyPassword()) ? tlsConfiguration.getKeystorePassword() : tlsConfiguration.getKeyPassword();
        HashMap<String, String> keyPasswords = new HashMap<String, String>();
        if (!StringUtils.isBlank((String)keyPassword)) {
            keyPasswords.put(keyAlias, keyPassword);
        }
        JKSKeyManager keystoreKeyManager = new JKSKeyManager(keyStore, keyPasswords, keyAlias);
        JKSKeyManager truststoreKeyManager = new JKSKeyManager(trustStore, Collections.emptyMap(), null);
        return new CompositeKeyManager((KeyManager)keystoreKeyManager, (KeyManager)truststoreKeyManager);
    }

    private static String getPrivateKeyAlias(KeyStore keyStore, String keystorePath) throws KeyStoreException {
        Set<String> keyAliases = StandardSAMLConfigurationFactory.getKeyAliases(keyStore);
        int privateKeyAliases = 0;
        for (String keyAlias : keyAliases) {
            if (!keyStore.isKeyEntry(keyAlias)) continue;
            ++privateKeyAliases;
        }
        if (privateKeyAliases == 0) {
            throw new RuntimeException("Unable to determine signing key, the keystore '" + keystorePath + "' does not contain any private keys");
        }
        if (privateKeyAliases > 1) {
            throw new RuntimeException("Unable to determine signing key, the keystore '" + keystorePath + "' contains more than one private key");
        }
        String firstPrivateKeyAlias = null;
        for (String keyAlias : keyAliases) {
            if (!keyStore.isKeyEntry(keyAlias)) continue;
            firstPrivateKeyAlias = keyAlias;
            break;
        }
        return firstPrivateKeyAlias;
    }

    private static Set<String> getKeyAliases(KeyStore keyStore) throws KeyStoreException {
        HashSet<String> availableKeys = new HashSet<String>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            availableKeys.add(aliases.nextElement());
        }
        return availableKeys;
    }

    private static ExtendedMetadata createExtendedMetadata(String signingAlgorithm, boolean signMetadata) {
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setIdpDiscoveryEnabled(true);
        extendedMetadata.setSigningAlgorithm(signingAlgorithm);
        extendedMetadata.setSignMetadata(signMetadata);
        extendedMetadata.setEcpEnabled(true);
        return extendedMetadata;
    }

    private static MetadataProvider createIdpMetadataProvider(URI idpMetadataLocation, HttpClient httpClient, Timer timer, ParserPool parserPool) throws Exception {
        if (idpMetadataLocation.getScheme().startsWith("http")) {
            return StandardSAMLConfigurationFactory.createHttpIdpMetadataProvider(idpMetadataLocation, httpClient, timer, parserPool);
        }
        return StandardSAMLConfigurationFactory.createFileIdpMetadataProvider(idpMetadataLocation, parserPool);
    }

    private static MetadataProvider createFileIdpMetadataProvider(URI idpMetadataLocation, ParserPool parserPool) throws MetadataProviderException {
        String idpMetadataFilePath = idpMetadataLocation.getPath();
        File idpMetadataFile = new File(idpMetadataFilePath);
        LOGGER.info("Loading IDP metadata from file located at: " + idpMetadataFile.getAbsolutePath());
        FilesystemMetadataProvider filesystemMetadataProvider = new FilesystemMetadataProvider(idpMetadataFile);
        filesystemMetadataProvider.setParserPool(parserPool);
        filesystemMetadataProvider.initialize();
        return filesystemMetadataProvider;
    }

    private static MetadataProvider createHttpIdpMetadataProvider(URI idpMetadataLocation, HttpClient httpClient, Timer timer, ParserPool parserPool) throws Exception {
        String idpMetadataUrl = idpMetadataLocation.toString();
        HTTPMetadataProvider httpMetadataProvider = new HTTPMetadataProvider(timer, httpClient, idpMetadataUrl);
        httpMetadataProvider.setParserPool(parserPool);
        httpMetadataProvider.initialize();
        return httpMetadataProvider;
    }

    private static MetadataManager createMetadataManager(MetadataProvider idpMetadataProvider, ExtendedMetadata extendedMetadata, KeyManager keyManager) throws MetadataProviderException {
        ExtendedMetadataDelegate idpExtendedMetadataDelegate = new ExtendedMetadataDelegate(idpMetadataProvider, extendedMetadata);
        idpExtendedMetadataDelegate.setMetadataTrustCheck(true);
        idpExtendedMetadataDelegate.setMetadataRequireSignature(false);
        CachingMetadataManager metadataManager = new CachingMetadataManager(Arrays.asList(idpExtendedMetadataDelegate));
        metadataManager.setKeyManager(keyManager);
        metadataManager.afterPropertiesSet();
        return metadataManager;
    }

    private static void configureGlobalSecurityDefaults(KeyManager keyManager, String signingAlgorithm, String digestAlgorithm) {
        BasicSecurityConfiguration securityConfiguration = (BasicSecurityConfiguration)Configuration.getGlobalSecurityConfiguration();
        if (!StringUtils.isBlank((String)signingAlgorithm)) {
            Credential defaultCredential = keyManager.getDefaultCredential();
            Key signingKey = SecurityHelper.extractSigningKey((Credential)defaultCredential);
            String keyAlgorithm = signingKey.getAlgorithm();
            if (!signingAlgorithm.contains(keyAlgorithm.toLowerCase())) {
                throw new IllegalStateException("Key algorithm '" + keyAlgorithm + "' cannot be used to create signatures of type '" + signingAlgorithm + "'");
            }
            securityConfiguration.registerSignatureAlgorithmURI(keyAlgorithm, signingAlgorithm);
        }
        if (!StringUtils.isBlank((String)digestAlgorithm)) {
            securityConfiguration.setSignatureReferenceDigestMethod(digestAlgorithm);
        }
    }
}

