/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl.tls;

import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.springframework.security.saml.key.KeyManager;

public class CompositeKeyManager
implements KeyManager {
    private final KeyManager serverKeyManager;
    private final KeyManager trustKeyManager;

    public CompositeKeyManager(KeyManager serverKeyManager, KeyManager trustKeyManager) {
        this.serverKeyManager = Objects.requireNonNull(serverKeyManager);
        this.trustKeyManager = Objects.requireNonNull(trustKeyManager);
    }

    public Credential getCredential(String keyName) {
        if (keyName == null) {
            return this.serverKeyManager.getDefaultCredential();
        }
        Credential credential = this.serverKeyManager.getCredential(keyName);
        if (credential == null) {
            credential = this.trustKeyManager.getCredential(keyName);
        }
        return credential;
    }

    public Credential getDefaultCredential() {
        return this.serverKeyManager.getDefaultCredential();
    }

    public String getDefaultCredentialName() {
        return this.serverKeyManager.getDefaultCredentialName();
    }

    public Set<String> getAvailableCredentials() {
        HashSet<String> allCredentials = new HashSet<String>();
        allCredentials.addAll(this.serverKeyManager.getAvailableCredentials());
        allCredentials.addAll(this.trustKeyManager.getAvailableCredentials());
        return allCredentials;
    }

    public X509Certificate getCertificate(String alias) {
        X509Certificate certificate = this.serverKeyManager.getCertificate(alias);
        if (certificate == null) {
            certificate = this.trustKeyManager.getCertificate(alias);
        }
        return certificate;
    }

    public Iterable<Credential> resolve(CriteriaSet criteria) throws SecurityException {
        Iterable credentials = this.serverKeyManager.resolve((Object)criteria);
        if (credentials == null || !credentials.iterator().hasNext()) {
            credentials = this.trustKeyManager.resolve((Object)criteria);
        }
        return credentials;
    }

    public Credential resolveSingle(CriteriaSet criteria) throws SecurityException {
        Credential credential = (Credential)this.serverKeyManager.resolveSingle((Object)criteria);
        if (credential == null) {
            this.trustKeyManager.resolveSingle((Object)criteria);
        }
        return credential;
    }
}

