/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.x509.SubjectDnX509PrincipalExtractor;
import org.apache.nifi.web.security.x509.X509AuthenticationProvider;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.apache.nifi.web.security.x509.X509CertificateValidator;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.apache.nifi.web.security.x509.ocsp.OcspCertificateValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

@Configuration
public class X509AuthenticationSecurityConfiguration {
    private final NiFiProperties niFiProperties;
    private final Authorizer authorizer;

    @Autowired
    public X509AuthenticationSecurityConfiguration(NiFiProperties niFiProperties, Authorizer authorizer) {
        this.niFiProperties = niFiProperties;
        this.authorizer = authorizer;
    }

    @Bean
    public X509AuthenticationProvider x509AuthenticationProvider() {
        return new X509AuthenticationProvider(this.certificateIdentityProvider(), this.authorizer, this.niFiProperties);
    }

    @Bean
    public X509CertificateExtractor certificateExtractor() {
        return new X509CertificateExtractor();
    }

    @Bean
    public X509PrincipalExtractor principalExtractor() {
        return new SubjectDnX509PrincipalExtractor();
    }

    @Bean
    public OcspCertificateValidator ocspValidator() {
        return new OcspCertificateValidator(this.niFiProperties);
    }

    @Bean
    public X509CertificateValidator certificateValidator() {
        X509CertificateValidator certificateValidator = new X509CertificateValidator();
        certificateValidator.setOcspValidator(this.ocspValidator());
        return certificateValidator;
    }

    @Bean
    public X509IdentityProvider certificateIdentityProvider() {
        X509IdentityProvider identityProvider = new X509IdentityProvider();
        identityProvider.setCertificateValidator(this.certificateValidator());
        identityProvider.setPrincipalExtractor(this.principalExtractor());
        return identityProvider;
    }
}

