/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.nifi.admin.service.IdpCredentialService;
import org.apache.nifi.idp.IdpCredential;
import org.apache.nifi.idp.IdpType;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.security.saml.SAMLCredentialStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.SAMLCredential;

public class StandardSAMLCredentialStore
implements SAMLCredentialStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardSAMLCredentialStore.class);
    private final IdpCredentialService idpCredentialService;

    public StandardSAMLCredentialStore(IdpCredentialService idpCredentialService) {
        this.idpCredentialService = idpCredentialService;
    }

    @Override
    public void save(String identity, SAMLCredential credential) {
        if (StringUtils.isBlank((String)identity)) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        if (credential == null) {
            throw new IllegalArgumentException("Credential cannot be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream objOut = new ObjectOutputStream(baos);){
            objOut.writeObject(credential);
            objOut.flush();
            baos.flush();
            IdpCredential idpCredential = new IdpCredential();
            idpCredential.setIdentity(identity);
            idpCredential.setType(IdpType.SAML);
            idpCredential.setCredential(baos.toByteArray());
            IdpCredential createdIdpCredential = this.idpCredentialService.replaceCredential(idpCredential);
            LOGGER.debug("Successfully saved SAMLCredential for {} with id {}", (Object)identity, (Object)createdIdpCredential.getId());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize SAMLCredential for user with identity " + identity, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SAMLCredential get(String identity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void delete(String identity) {
        IdpCredential idpCredential = this.idpCredentialService.getCredential(identity);
        if (idpCredential == null) {
            LOGGER.debug("No SAMLCredential exists for {}", (Object)identity);
            return;
        }
        IdpType idpType = idpCredential.getType();
        if (idpType != IdpType.SAML) {
            LOGGER.debug("Stored credential for {} was not a SAML credential, type was {}", (Object)identity, (Object)idpType);
            return;
        }
        this.idpCredentialService.deleteCredential(idpCredential.getId());
    }
}

