/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml.impl.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.nifi.web.util.WebUtils;

public class ProxyAwareHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final String scheme;
    private final String serverName;
    private final int serverPort;
    private final String proxyContextPath;
    private final String contextPath;

    public ProxyAwareHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.scheme = WebUtils.determineProxiedScheme((HttpServletRequest)request);
        this.serverName = WebUtils.determineProxiedHost((HttpServletRequest)request);
        this.serverPort = Integer.valueOf(WebUtils.determineProxiedPort((HttpServletRequest)request));
        String tempProxyContextPath = WebUtils.normalizeContextPath((String)WebUtils.determineContextPath((HttpServletRequest)request));
        this.proxyContextPath = tempProxyContextPath.equals("/") ? "" : tempProxyContextPath;
        this.contextPath = request.getContextPath();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getRequestURI() {
        StringBuilder sb = new StringBuilder(this.contextPath);
        sb.append(this.getServletPath());
        return sb.toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.scheme).append("://").append(this.serverName);
        sb.append(":").append(this.serverPort);
        sb.append(this.proxyContextPath);
        sb.append(this.contextPath);
        sb.append(this.getServletPath());
        if (this.getPathInfo() != null) {
            sb.append(this.getPathInfo());
        }
        return sb;
    }

    public boolean isSecure() {
        return "https".equalsIgnoreCase(this.scheme);
    }
}

