/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;

public class StandardAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    protected static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    protected static final String BEARER_HEADER = "Bearer";
    protected static final String UNAUTHORIZED = "Unauthorized";
    private static final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final BearerTokenAuthenticationEntryPoint bearerTokenAuthenticationEntryPoint;

    public StandardAuthenticationEntryPoint(BearerTokenAuthenticationEntryPoint bearerTokenAuthenticationEntryPoint) {
        this.bearerTokenAuthenticationEntryPoint = Objects.requireNonNull(bearerTokenAuthenticationEntryPoint);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof OAuth2AuthenticationException) {
            this.bearerTokenAuthenticationEntryPoint.commence(request, response, exception);
        } else {
            response.setStatus(401);
        }
        this.removeAuthorizationBearerCookie(request, response);
        this.sendErrorMessage(response);
    }

    private void sendErrorMessage(HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        String message = this.getErrorMessage(response);
        try (PrintWriter writer = response.getWriter();){
            writer.print(message);
        }
    }

    private String getErrorMessage(HttpServletResponse response) {
        String authenticateHeader = response.getHeader(AUTHENTICATE_HEADER);
        String errorMessage = authenticateHeader == null ? UNAUTHORIZED : authenticateHeader;
        return errorMessage.replaceFirst(BEARER_HEADER, UNAUTHORIZED);
    }

    private void removeAuthorizationBearerCookie(HttpServletRequest request, HttpServletResponse response) {
        Optional<String> authorizationBearer = applicationCookieService.getCookieValue(request, ApplicationCookieName.AUTHORIZATION_BEARER);
        if (authorizationBearer.isPresent()) {
            URI uri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
            applicationCookieService.removeCookie(uri, response, ApplicationCookieName.AUTHORIZATION_BEARER);
        }
    }
}

