/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.saml2.SamlConfigurationException;
import org.apache.nifi.web.security.saml2.registration.RegistrationBuilderProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;

class StandardRegistrationBuilderProvider
implements RegistrationBuilderProvider {
    static final String NIFI_TRUST_STORE_STRATEGY = "NIFI";
    private static final String HTTP_SCHEME_PREFIX = "http";
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final NiFiProperties properties;

    public StandardRegistrationBuilderProvider(NiFiProperties properties) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelyingPartyRegistration.Builder getRegistrationBuilder() {
        String metadataUrl = Objects.requireNonNull(this.properties.getSamlIdentityProviderMetadataUrl(), "Metadata URL required");
        try (InputStream inputStream = this.getInputStream(metadataUrl);){
            RelyingPartyRegistration.Builder builder = RelyingPartyRegistrations.fromMetadata((InputStream)inputStream);
            return builder;
        }
        catch (IOException e) {
            throw new SamlConfigurationException(String.format("SAML Metadata loading failed [%s]", metadataUrl), e);
        }
    }

    private InputStream getInputStream(String metadataUrl) throws IOException {
        InputStream inputStream = metadataUrl.startsWith(HTTP_SCHEME_PREFIX) ? this.getRemoteInputStream(metadataUrl) : resourceLoader.getResource(metadataUrl).getInputStream();
        return inputStream;
    }

    private InputStream getRemoteInputStream(String metadataUrl) {
        OkHttpClient client = this.getHttpClient();
        Request request = new Request.Builder().get().url(metadataUrl).build();
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                ResponseBody body = Objects.requireNonNull(response.body(), "SAML Metadata response not found");
                return body.byteStream();
            }
            response.close();
            throw new SamlConfigurationException(String.format("SAML Metadata retrieval failed [%s] HTTP %d", metadataUrl, response.code()));
        }
        catch (IOException e) {
            throw new SamlConfigurationException(String.format("SAML Metadata retrieval failed [%s]", metadataUrl), e);
        }
    }

    private OkHttpClient getHttpClient() {
        Duration connectTimeout = Duration.ofMillis((long)FormatUtils.getPreciseTimeDuration((String)this.properties.getSamlHttpClientConnectTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
        Duration readTimeout = Duration.ofMillis((long)FormatUtils.getPreciseTimeDuration((String)this.properties.getSamlHttpClientReadTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(connectTimeout).readTimeout(readTimeout);
        if (NIFI_TRUST_STORE_STRATEGY.equals(this.properties.getSamlHttpClientTruststoreStrategy())) {
            this.setSslSocketFactory(builder);
        }
        return builder.build();
    }

    private void setSslSocketFactory(OkHttpClient.Builder builder) {
        TlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)this.properties);
        try {
            X509TrustManager trustManager = Objects.requireNonNull(SslContextFactory.getX509TrustManager((TlsConfiguration)tlsConfiguration), "TrustManager required");
            TrustManager[] trustManagers = new TrustManager[]{trustManager};
            SSLContext sslContext = Objects.requireNonNull(SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration, (TrustManager[])trustManagers), "SSLContext required");
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, trustManager);
        }
        catch (TlsException e) {
            throw new SamlConfigurationException("SAML Metadata HTTP TLS configuration failed", e);
        }
    }
}

