/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.x509.X509AuthenticationRequestToken;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class X509AuthenticationFilter
extends NiFiAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(X509AuthenticationFilter.class);
    private X509CertificateExtractor certificateExtractor;
    private X509PrincipalExtractor principalExtractor;

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        X509Certificate[] certificates = this.certificateExtractor.extractClientCertificate(request);
        if (certificates == null) {
            return null;
        }
        return new X509AuthenticationRequestToken(request.getHeader("X-ProxiedEntitiesChain"), this.principalExtractor, certificates, request.getRemoteAddr());
    }

    public void setCertificateExtractor(X509CertificateExtractor certificateExtractor) {
        this.certificateExtractor = certificateExtractor;
    }

    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }
}

