/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import io.jsonwebtoken.JwtException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.jwt.JwtAuthenticationRequestToken;
import org.apache.nifi.web.security.jwt.JwtService;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtAuthenticationProvider
extends NiFiAuthenticationProvider {
    private final JwtService jwtService;

    public JwtAuthenticationProvider(JwtService jwtService, NiFiProperties nifiProperties, Authorizer authorizer) {
        super(nifiProperties, authorizer);
        this.jwtService = jwtService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JwtAuthenticationRequestToken request = (JwtAuthenticationRequestToken)authentication;
        try {
            String jwtPrincipal = this.jwtService.getAuthenticationFromToken(request.getToken());
            String mappedIdentity = this.mapIdentity(jwtPrincipal);
            StandardNiFiUser user = new StandardNiFiUser.Builder().identity(mappedIdentity).groups(this.getUserGroups(mappedIdentity)).clientAddress(request.getClientAddress()).build();
            return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)user));
        }
        catch (JwtException e) {
            throw new InvalidAuthenticationException(e.getMessage(), e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationRequestToken.class.isAssignableFrom(authentication);
    }
}

