/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.knox.KnoxConfiguration;

public class StandardKnoxConfiguration
implements KnoxConfiguration {
    private final NiFiProperties properties;

    public StandardKnoxConfiguration(NiFiProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean isKnoxEnabled() {
        return this.properties.isKnoxSsoEnabled();
    }

    @Override
    public String getKnoxUrl() {
        return this.properties.getKnoxUrl();
    }

    @Override
    public Set<String> getAudiences() {
        return this.properties.getKnoxAudiences();
    }

    @Override
    public String getKnoxCookieName() {
        return this.properties.getKnoxCookieName();
    }

    @Override
    public RSAPublicKey getKnoxPublicKey() {
        Path knoxPublicKeyPath = this.properties.getKnoxPublicKeyPath();
        if (Files.isRegularFile(knoxPublicKeyPath, new LinkOption[0]) && Files.exists(knoxPublicKeyPath, new LinkOption[0])) {
            RSAPublicKey rSAPublicKey;
            block9: {
                InputStream publicKeyStream = Files.newInputStream(knoxPublicKeyPath, new OpenOption[0]);
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(publicKeyStream);
                    rSAPublicKey = (RSAPublicKey)certificate.getPublicKey();
                    if (publicKeyStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (publicKeyStream != null) {
                            try {
                                publicKeyStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | CertificateException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                publicKeyStream.close();
            }
            return rSAPublicKey;
        }
        throw new RuntimeException(String.format("The specified Knox public key path does not exist '%s'", knoxPublicKeyPath.toString()));
    }
}

