/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.authentication;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenValidator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.web.client.RestOperations;

public class StandardOidcIdTokenDecoderFactory
implements JwtDecoderFactory<ClientRegistration> {
    private static final String MISSING_SIGNATURE_VERIFIER_ERROR_CODE = "missing_signature_verifier";
    private static final String UNSPECIFIED_ERROR_URI = null;
    private static final JwsAlgorithm DEFAULT_JWS_ALGORITHM = SignatureAlgorithm.RS256;
    private static final Map<JwsAlgorithm, String> SECRET_KEY_ALGORITHMS;
    private static final ClaimTypeConverter DEFAULT_CLAIM_TYPE_CONVERTER;
    private final Map<String, JwtDecoder> jwtDecoders = new ConcurrentHashMap<String, JwtDecoder>();
    private final JwsAlgorithm configuredJwsAlgorithm;
    private final RestOperations restOperations;

    public StandardOidcIdTokenDecoderFactory(String preferredJwsAlgorithm, RestOperations restOperations) {
        this.configuredJwsAlgorithm = this.getJwsAlgorithm(preferredJwsAlgorithm);
        this.restOperations = Objects.requireNonNull(restOperations, "REST Operations required");
    }

    public JwtDecoder createDecoder(ClientRegistration clientRegistration) {
        Objects.requireNonNull(clientRegistration, "Client Registration required");
        String registrationId = clientRegistration.getRegistrationId();
        return this.jwtDecoders.computeIfAbsent(registrationId, key -> {
            NimbusJwtDecoder decoder = this.buildDecoder(clientRegistration);
            decoder.setClaimSetConverter((Converter)DEFAULT_CLAIM_TYPE_CONVERTER);
            OAuth2TokenValidator<Jwt> tokenValidator = this.getTokenValidator(clientRegistration);
            decoder.setJwtValidator(tokenValidator);
            return decoder;
        });
    }

    protected OAuth2TokenValidator<Jwt> getTokenValidator(ClientRegistration clientRegistration) {
        return new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{new JwtTimestampValidator(), new OidcIdTokenValidator(clientRegistration)});
    }

    private NimbusJwtDecoder buildDecoder(ClientRegistration clientRegistration) {
        NimbusJwtDecoder decoder;
        Class jwsAlgorithmClass = this.configuredJwsAlgorithm.getClass();
        if (SignatureAlgorithm.class.isAssignableFrom(jwsAlgorithmClass)) {
            String jwkSetUri = clientRegistration.getProviderDetails().getJwkSetUri();
            if (jwkSetUri == null || jwkSetUri.isEmpty()) {
                String message = String.format("JSON Web Key Set URI required for Signature Verifier JWS Algorithm [%s]", this.configuredJwsAlgorithm);
                OAuth2Error error = this.getVerifierError(message);
                throw new OAuth2AuthenticationException(error, message);
            }
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)this.configuredJwsAlgorithm;
            decoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).restOperations(this.restOperations).build();
        } else if (MacAlgorithm.class.isAssignableFrom(jwsAlgorithmClass)) {
            String clientSecret = clientRegistration.getClientSecret();
            if (clientSecret == null || clientSecret.isEmpty()) {
                String message = String.format("Client Secret required for MAC Verifier JWS Algorithm [%s]", this.configuredJwsAlgorithm);
                OAuth2Error error = this.getVerifierError(message);
                throw new OAuth2AuthenticationException(error, message);
            }
            byte[] clientSecretKey = clientSecret.getBytes(StandardCharsets.UTF_8);
            String secretKeyAlgorithm = SECRET_KEY_ALGORITHMS.get(this.configuredJwsAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(clientSecretKey, secretKeyAlgorithm);
            MacAlgorithm macAlgorithm = (MacAlgorithm)this.configuredJwsAlgorithm;
            decoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKey).macAlgorithm(macAlgorithm).build();
        } else {
            String message = String.format("Signature Verifier JWS Algorithm [%s] not supported", this.configuredJwsAlgorithm);
            OAuth2Error error = this.getVerifierError(message);
            throw new OAuth2AuthenticationException(error, message);
        }
        return decoder;
    }

    private JwsAlgorithm getJwsAlgorithm(String preferredJwsAlgorithm) {
        JwsAlgorithm jwsAlgorithm;
        if (preferredJwsAlgorithm == null || preferredJwsAlgorithm.isEmpty()) {
            jwsAlgorithm = DEFAULT_JWS_ALGORITHM;
        } else {
            MacAlgorithm macAlgorithm = MacAlgorithm.from((String)preferredJwsAlgorithm);
            if (macAlgorithm == null) {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.from((String)preferredJwsAlgorithm);
                if (signatureAlgorithm == null) {
                    String message = String.format("Preferred JWS Algorithm [%s] not supported", preferredJwsAlgorithm);
                    throw new OidcConfigurationException(message);
                }
                jwsAlgorithm = signatureAlgorithm;
            } else {
                jwsAlgorithm = macAlgorithm;
            }
        }
        return jwsAlgorithm;
    }

    private OAuth2Error getVerifierError(String message) {
        return new OAuth2Error(MISSING_SIGNATURE_VERIFIER_ERROR_CODE, message, UNSPECIFIED_ERROR_URI);
    }

    static {
        HashMap<MacAlgorithm, String> mappings = new HashMap<MacAlgorithm, String>();
        mappings.put(MacAlgorithm.HS256, "HmacSHA256");
        mappings.put(MacAlgorithm.HS384, "HmacSHA384");
        mappings.put(MacAlgorithm.HS512, "HmacSHA512");
        SECRET_KEY_ALGORITHMS = Collections.unmodifiableMap(mappings);
        DEFAULT_CLAIM_TYPE_CONVERTER = new ClaimTypeConverter(OidcIdTokenDecoderFactory.createDefaultClaimTypeConverters());
    }
}

