/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.ode.axis2.ODEServer;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;

public class BindingContextImpl
implements BindingContext {
    private ODEServer _server;
    private ProcessStore _store;

    public BindingContextImpl(ODEServer server, ProcessStore store) {
        this._server = server;
        this._store = store;
    }

    public EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
        try {
            ProcessConf pconf = this._store.getProcessConfiguration(processId);
            Definition wsdl = pconf.getDefinitionForService(myRoleEndpoint.serviceName);
            if (wsdl == null) {
                throw new ContextException("Unable to access WSDL definition to activate MyRole endpoint for service " + myRoleEndpoint.serviceName + " and port " + myRoleEndpoint.portName);
            }
            ODEService svc = this._server.createService(pconf, myRoleEndpoint.serviceName, myRoleEndpoint.portName);
            return svc.getMyServiceRef();
        }
        catch (AxisFault axisFault) {
            throw new ContextException("Could not activate endpoint for service " + myRoleEndpoint.serviceName + " and port " + myRoleEndpoint.portName, (Throwable)axisFault);
        }
    }

    public void deactivateMyRoleEndpoint(Endpoint myRoleEndpoint) {
        this._server.destroyService(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType, Endpoint initialPartnerEndpoint) {
        ProcessConf pconf = this._store.getProcessConfiguration(processId);
        Definition wsdl = pconf.getDefinitionForService(initialPartnerEndpoint.serviceName);
        if (wsdl == null) {
            throw new ContextException("Cannot find definition for service " + initialPartnerEndpoint.serviceName + " in the context of process " + processId);
        }
        return this._server.createExternalService(pconf, initialPartnerEndpoint.serviceName, initialPartnerEndpoint.portName);
    }
}

