/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.BindingContextImpl;
import org.apache.ode.axis2.EndpointReferenceContextImpl;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.MessageExchangeContextImpl;
import org.apache.ode.axis2.Messages;
import org.apache.ode.axis2.ODEConfigProperties;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.SoapExternalService;
import org.apache.ode.axis2.deploy.DeploymentPoller;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ode.axis2.hooks.ODEMessageReceiver;
import org.apache.ode.axis2.httpbinding.HttpExternalService;
import org.apache.ode.axis2.service.DeploymentWebService;
import org.apache.ode.axis2.service.ManagementService;
import org.apache.ode.bpel.connector.BpelServerConnector;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.extvar.jdbc.JdbcExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.fs.TempFileManager;
import org.apache.ode.utils.wsdl.WsdlUtils;

public class ODEServer {
    protected final Log __log = LogFactory.getLog(this.getClass());
    protected final Log __logTx = LogFactory.getLog((String)"org.apache.ode.tx");
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    protected File _appRoot;
    protected File _workRoot;
    protected BpelServerImpl _server;
    protected ProcessStoreImpl _store;
    protected ODEConfigProperties _odeConfig;
    protected AxisConfiguration _axisConfig;
    protected TransactionManager _txMgr;
    protected BpelDAOConnectionFactory _daoCF;
    protected ExecutorService _executorService;
    protected Scheduler _scheduler;
    protected Database _db;
    private DeploymentPoller _poller;
    private MultiKeyMap _services = new MultiKeyMap();
    private MultiKeyMap _externalServices = new MultiKeyMap();
    private BpelServerConnector _connector;
    private ManagementService _mgtService;

    public void init(ServletConfig config, AxisConfiguration axisConf) throws ServletException {
        this.init(config.getServletContext().getRealPath("/WEB-INF"), axisConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String contextPath, AxisConfiguration axisConf) throws ServletException {
        boolean success = false;
        try {
            this._axisConfig = axisConf;
            String rootDir = System.getProperty("org.apache.ode.rootDir");
            this._appRoot = rootDir != null ? new File(rootDir) : new File(contextPath);
            TempFileManager.setWorkingDirectory((File)this._appRoot);
            this.__log.debug((Object)"Loading properties");
            String confDir = System.getProperty("org.apache.ode.configDir");
            this._odeConfig = confDir == null ? new ODEConfigProperties(new File(this._appRoot, "conf")) : new ODEConfigProperties(new File(confDir));
            try {
                this._odeConfig.load();
            }
            catch (FileNotFoundException fnf) {
                String errmsg = __msgs.msgOdeInstallErrorCfgNotFound(this._odeConfig.getFile());
                this.__log.warn((Object)errmsg);
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgOdeInstallErrorCfgReadError(this._odeConfig.getFile());
                this.__log.error((Object)errmsg, (Throwable)ex);
                throw new ServletException(errmsg, (Throwable)ex);
            }
            String wdir = this._odeConfig.getWorkingDir();
            this._workRoot = wdir == null ? this._appRoot : new File(wdir.trim());
            this.__log.debug((Object)"Initializing transaction manager");
            this.initTxMgr();
            this.__log.debug((Object)"Creating data source.");
            this.initDataSource();
            this.__log.debug((Object)"Starting DAO.");
            this.initDAO();
            EndpointReferenceContextImpl eprContext = new EndpointReferenceContextImpl(this);
            this.__log.debug((Object)"Initializing BPEL process store.");
            this.initProcessStore(eprContext);
            this.__log.debug((Object)"Initializing BPEL server.");
            this.initBpelServer(eprContext);
            this.registerEventListeners();
            this.registerMexInterceptors();
            this.registerExternalVariableModules();
            try {
                this._server.start();
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgOdeBpelServerStartFailure();
                this.__log.error((Object)errmsg, (Throwable)ex);
                throw new ServletException(errmsg, (Throwable)ex);
            }
            File deploymentDir = new File(this._workRoot, "processes");
            this._poller = new DeploymentPoller(deploymentDir, this);
            this._mgtService = new ManagementService();
            this._mgtService.enableService(this._axisConfig, (BpelServer)this._server, (ProcessStore)this._store, this._appRoot.getAbsolutePath());
            new DeploymentWebService().enableService(this._axisConfig, (BpelServer)this._server, (ProcessStore)this._store, this._poller, this._appRoot.getAbsolutePath(), this._workRoot.getAbsolutePath());
            this._store.loadAll();
            this.__log.debug((Object)"Initializing JCA adapter.");
            this.initConnector();
            this._poller.start();
            this.__log.info((Object)__msgs.msgPollingStarted(deploymentDir.getAbsolutePath()));
            this.__log.info((Object)__msgs.msgOdeStarted());
            success = true;
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
    }

    private void initDataSource() throws ServletException {
        this._db = new Database((OdeConfigProperties)this._odeConfig);
        this._db.setTransactionManager(this._txMgr);
        this._db.setWorkRoot(this._workRoot);
        try {
            this._db.start();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeDbConfigError();
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ServletException(errmsg, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws AxisFault {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this._poller != null) {
                try {
                    this.__log.debug((Object)"shutting down poller");
                    this._poller.stop();
                    this._poller = null;
                }
                catch (Throwable t) {
                    this.__log.debug((Object)"Error stopping poller.", t);
                }
            }
            if (this._server != null) {
                try {
                    this.__log.debug((Object)"shutting down ODE server.");
                    this._server.shutdown();
                    this._server = null;
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"Error stopping services.", ex);
                }
            }
            if (this._scheduler != null) {
                try {
                    this.__log.debug((Object)"shutting down quartz scheduler.");
                    this._scheduler.shutdown();
                    this._scheduler = null;
                }
                catch (Exception ex) {
                    this.__log.debug((Object)"Scheduler couldn't be shutdown.", (Throwable)ex);
                }
            }
            if (this._store != null) {
                try {
                    this._store.shutdown();
                    this._store = null;
                }
                catch (Throwable t) {
                    this.__log.debug((Object)"Store could not be shutdown.", t);
                }
            }
            if (this._daoCF != null) {
                try {
                    this._daoCF.shutdown();
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"DOA shutdown failed.", ex);
                }
                finally {
                    this._daoCF = null;
                }
            }
            if (this._db != null) {
                try {
                    this._db.shutdown();
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"DB shutdown failed.", ex);
                }
                finally {
                    this._db = null;
                }
            }
            if (this._txMgr != null) {
                this.__log.debug((Object)"shutting down transaction manager.");
                this._txMgr = null;
            }
            if (this._connector != null) {
                try {
                    this.__log.debug((Object)"shutdown BpelConnector");
                    this._connector.shutdown();
                }
                catch (Throwable t) {
                    this.__log.error((Object)"Unable to cleanup temp files.", t);
                }
            }
            try {
                this.__log.debug((Object)"cleaning up temporary files.");
                TempFileManager.cleanup();
            }
            catch (Throwable t) {
                this.__log.error((Object)"Unable to cleanup temp files.", t);
            }
            this.__log.info((Object)__msgs.msgOdeShutdownCompleted());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public ODEService createService(ProcessConf pconf, QName serviceName, String portName) throws AxisFault {
        this.destroyService(serviceName, portName);
        AxisService axisService = ODEAxisService.createService(this._axisConfig, pconf, serviceName, portName);
        ODEService odeService = new ODEService(axisService, pconf, serviceName, portName, (BpelServer)this._server, this._txMgr);
        this._services.put((Object)serviceName, (Object)portName, (Object)odeService);
        AxisOperation firstOp = (AxisOperation)axisService.getOperations().next();
        ((ODEMessageReceiver)firstOp.getMessageReceiver()).setService(odeService);
        this._axisConfig.addService(axisService);
        this.__log.debug((Object)("Created Axis2 service " + serviceName));
        return odeService;
    }

    public ExternalService createExternalService(ProcessConf pconf, QName serviceName, String portName) throws ContextException {
        ExternalService extService = (ExternalService)this._externalServices.get((Object)serviceName);
        if (extService != null) {
            return extService;
        }
        Definition def = pconf.getDefinitionForService(serviceName);
        try {
            if (WsdlUtils.useHTTPBinding((Definition)def, (QName)serviceName, (String)portName)) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Creating HTTP-bound external service " + serviceName));
                }
                extService = new HttpExternalService(pconf, serviceName, portName, this._executorService, this._scheduler, (BpelServer)this._server);
            } else if (WsdlUtils.useSOAPBinding((Definition)def, (QName)serviceName, (String)portName)) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Creating SOAP-bound external service " + serviceName));
                }
                extService = new SoapExternalService(pconf, serviceName, portName, this._executorService, this._axisConfig, this._scheduler, (BpelServer)this._server);
            }
        }
        catch (Exception ex) {
            this.__log.error((Object)"Could not create external service.", (Throwable)ex);
            throw new ContextException("Error creating external service! name:" + serviceName + ", port:" + portName, (Throwable)ex);
        }
        if (extService == null) {
            throw new ContextException("Only SOAP and HTTP binding supported!");
        }
        this._externalServices.put((Object)serviceName, (Object)portName, (Object)extService);
        this.__log.debug((Object)("Created external service " + serviceName));
        return extService;
    }

    public void destroyService(QName serviceName, String portName) {
        this.__log.debug((Object)("Destroying service " + serviceName + " port " + portName));
        ODEService service = (ODEService)this._services.remove((Object)serviceName, (Object)portName);
        if (service != null) {
            try {
                this._axisConfig.removeService(service.getAxisService().getName());
            }
            catch (AxisFault axisFault) {
                this.__log.error((Object)("Couldn't destroy service " + serviceName));
            }
        } else {
            this.__log.debug((Object)("Couldn't find service " + serviceName + " port " + portName + " to destroy."));
        }
    }

    public ODEService getService(QName serviceName, String portName) {
        return (ODEService)this._services.get((Object)serviceName, (Object)portName);
    }

    public ODEService getService(QName serviceName, QName portTypeName) {
        for (Object o : this._services.values()) {
            ODEService service = (ODEService)o;
            if (!service.respondsTo(serviceName, portTypeName)) continue;
            return service;
        }
        return null;
    }

    public ExternalService getExternalService(QName serviceName, String portName) {
        return (ExternalService)this._externalServices.get((Object)serviceName, (Object)portName);
    }

    private void initTxMgr() throws ServletException {
        String txFactoryName = this._odeConfig.getTxFactoryClass();
        this.__log.debug((Object)("Initializing transaction manager using " + txFactoryName));
        try {
            Class<?> txFactClass = this.getClass().getClassLoader().loadClass(txFactoryName);
            Object txFact = txFactClass.newInstance();
            this._txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
            if (this.__logTx.isDebugEnabled() && System.getProperty("ode.debug.tx") != null) {
                this._txMgr = new DebugTxMgr(this._txMgr);
            }
        }
        catch (Exception e) {
            this.__log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryName), (Throwable)e);
            throw new ServletException("Couldn't initialize a transaction manager with factory: " + txFactoryName, (Throwable)e);
        }
    }

    private void initConnector() throws ServletException {
        int port = this._odeConfig.getConnectorPort();
        if (port == 0) {
            this.__log.info((Object)"Skipping connector initialization.");
        } else {
            this._connector = new BpelServerConnector();
            this._connector.setBpelServer((BpelServer)this._server);
            this._connector.setProcessStore((ProcessStore)this._store);
            this._connector.setPort(this._odeConfig.getConnectorPort());
            this._connector.setId("jcaServer");
            try {
                this._connector.start();
            }
            catch (Exception e) {
                this.__log.error((Object)"Failed to initialize JCA connector.", (Throwable)e);
            }
        }
    }

    protected void initDAO() throws ServletException {
        this.__log.info((Object)__msgs.msgOdeUsingDAOImpl(this._odeConfig.getDAOConnectionFactory()));
        try {
            this._daoCF = this._db.createDaoCF();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgDAOInstantiationFailed(this._odeConfig.getDAOConnectionFactory());
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ServletException(errmsg, (Throwable)ex);
        }
    }

    protected void initProcessStore(EndpointReferenceContext eprContext) {
        this._store = this.createProcessStore(eprContext, this._db.getDataSource());
        this._store.registerListener((ProcessStoreListener)new ProcessStoreListenerImpl());
        this._store.setDeployDir(new File(this._workRoot, "processes"));
    }

    protected ProcessStoreImpl createProcessStore(EndpointReferenceContext eprContext, DataSource ds) {
        return new ProcessStoreImpl(eprContext, ds, this._odeConfig.getDAOConnectionFactory(), (OdeConfigProperties)this._odeConfig, false);
    }

    protected Scheduler createScheduler() {
        SimpleScheduler scheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this._db.getDataSource()));
        scheduler.setExecutorService(this._executorService);
        scheduler.setTransactionManager(this._txMgr);
        return scheduler;
    }

    private void initBpelServer(EndpointReferenceContextImpl eprContext) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"ODE initializing");
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            int threadNumber = 0;

            public Thread newThread(Runnable r) {
                ++this.threadNumber;
                Thread t = new Thread(r, "ODEServer-" + this.threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
        this._executorService = this._odeConfig.getThreadPoolMaxSize() == 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(this._odeConfig.getThreadPoolMaxSize(), threadFactory);
        this._server = new BpelServerImpl();
        this._scheduler = this.createScheduler();
        this._scheduler.setJobProcessor((Scheduler.JobProcessor)this._server);
        this._server.setDaoConnectionFactory(this._daoCF);
        this._server.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl(this._scheduler, this._odeConfig.getInMemMexTtl()));
        this._server.setEndpointReferenceContext((EndpointReferenceContext)eprContext);
        this._server.setMessageExchangeContext((MessageExchangeContext)new MessageExchangeContextImpl(this));
        this._server.setBindingContext((BindingContext)new BindingContextImpl(this, (ProcessStore)this._store));
        this._server.setScheduler(this._scheduler);
        if (this._odeConfig.isDehydrationEnabled()) {
            CountLRUDehydrationPolicy dehy = new CountLRUDehydrationPolicy();
            this._server.setDehydrationPolicy((DehydrationPolicy)dehy);
        }
        this._server.setConfigProperties(this._odeConfig.getProperties());
        this._server.init();
    }

    public ProcessStoreImpl getProcessStore() {
        return this._store;
    }

    public BpelServerImpl getBpelServer() {
        return this._server;
    }

    public InstanceManagement getInstanceManagement() {
        return this._mgtService.getInstanceMgmt();
    }

    public ProcessManagement getProcessManagement() {
        return this._mgtService.getProcessMgmt();
    }

    public File getAppRoot() {
        return this._appRoot;
    }

    private void registerEventListeners() {
        String listenersStr = this._odeConfig.getEventListeners();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String listenerCN = tokenizer.nextToken();
                try {
                    this._server.registerBpelEventListener((BpelEventListener)Class.forName(listenerCN).newInstance());
                    this.__log.info((Object)__msgs.msgBpelEventListenerRegistered(listenerCN));
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the event listener " + listenerCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerMexInterceptors() {
        String listenersStr = this._odeConfig.getMessageExchangeInterceptors();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String interceptorCN = tokenizer.nextToken();
                try {
                    this._server.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(interceptorCN).newInstance());
                    this.__log.info((Object)__msgs.msgMessageExchangeInterceptorRegistered(interceptorCN));
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the event listener " + interceptorCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerExternalVariableModules() {
        JdbcExternalVariableModule jdbcext = new JdbcExternalVariableModule();
        jdbcext.registerDataSource("ode", this._db.getDataSource());
        this._server.registerExternalVariableEngine((ExternalVariableModule)jdbcext);
    }

    private void handleEvent(ProcessStoreEvent pse) {
        this.__log.debug((Object)("Process store event: " + pse));
        switch (pse.type) {
            case ACTVIATED: 
            case RETIRED: {
                this._server.unregister(pse.pid);
                ProcessConf pconf = this._store.getProcessConfiguration(pse.pid);
                if (pconf != null) {
                    this._server.register(pconf);
                    break;
                }
                this.__log.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                break;
            }
            case DISABLED: 
            case UNDEPLOYED: {
                this._server.unregister(pse.pid);
                break;
            }
            default: {
                this.__log.debug((Object)("Ignoring store event: " + pse));
            }
        }
    }

    private class DebugTx
    implements Transaction {
        private Transaction _tx;

        public DebugTx(Transaction tx) {
            this._tx = tx;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx commit");
            this._tx.commit();
        }

        public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
            return this._tx.delistResource(xaResource, i);
        }

        public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
            return this._tx.enlistResource(xaResource);
        }

        public int getStatus() throws SystemException {
            return this._tx.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
            ODEServer.this.__logTx.debug((Object)("Synchronization registration on " + synchronization.getClass().getName()));
            this._tx.registerSynchronization(synchronization);
        }

        public void rollback() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx rollback");
            this._tx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx set rollback");
            this._tx.setRollbackOnly();
        }
    }

    private class DebugTxMgr
    implements TransactionManager {
        private TransactionManager _tm;

        public DebugTxMgr(TransactionManager tm) {
            this._tm = tm;
        }

        public void begin() throws NotSupportedException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm begin");
            this._tm.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm commit");
            for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
                ODEServer.this.__logTx.debug((Object)traceElement.toString());
            }
            this._tm.commit();
        }

        public int getStatus() throws SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm status");
            return this._tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction tx = this._tm.getTransaction();
            ODEServer.this.__logTx.debug((Object)("Txm get tx " + tx));
            return tx == null ? null : new DebugTx(tx);
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm resume");
            this._tm.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm rollback");
            this._tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm set rollback");
            this._tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            ODEServer.this.__logTx.debug((Object)("Txm set tiemout " + i));
            this._tm.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm suspend");
            return this._tm.suspend();
        }
    }

    private class ProcessStoreListenerImpl
    implements ProcessStoreListener {
        private ProcessStoreListenerImpl() {
        }

        public void onProcessStoreEvent(ProcessStoreEvent event) {
            ODEServer.this.handleEvent(event);
        }
    }
}

