/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.Properties;
import org.apache.ode.axis2.util.SoapMessageConverter;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.WatchDog;
import org.apache.ode.utils.fs.FileWatchDog;
import org.apache.ode.utils.uuid.UUID;
import org.apache.ode.utils.wsdl.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapExternalService
implements ExternalService {
    private static final Log __log = LogFactory.getLog(SoapExternalService.class);
    private static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    private static final int EXPIRE_SERVICE_CLIENT = 30000;
    private static ThreadLocal<CachedOptions> _cachedOptions = new ThreadLocal();
    private static ThreadLocal<CachedServiceClient> _cachedClients = new ThreadLocal();
    private ExecutorService _executorService;
    private Definition _definition;
    private QName _serviceName;
    private String _portName;
    protected WSAEndpoint endpointReference;
    private AxisConfiguration _axisConfig;
    private SoapMessageConverter _converter;
    private Scheduler _sched;
    private BpelServer _server;
    private ProcessConf _pconf;

    public SoapExternalService(ProcessConf pconf, QName serviceName, String portName, ExecutorService executorService, AxisConfiguration axisConfig, Scheduler sched, BpelServer server) throws AxisFault {
        this._definition = pconf.getDefinitionForService(serviceName);
        this._serviceName = serviceName;
        this._portName = portName;
        this._executorService = executorService;
        this._axisConfig = axisConfig;
        this._sched = sched;
        this._converter = new SoapMessageConverter(this._definition, serviceName, portName);
        this._server = server;
        this._pconf = pconf;
        Element eprElmt = ODEService.genEPRfromWSDL(this._definition, serviceName, portName);
        if (eprElmt == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(eprElmt));
    }

    public void invoke(final PartnerRoleMessageExchange odeMex) {
        boolean isTwoWay = odeMex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        try {
            MessageContext mctx = new MessageContext();
            this.writeHeader(mctx, odeMex);
            this._converter.createSoapRequest(mctx, odeMex.getRequest(), odeMex.getOperation());
            SOAPEnvelope soapEnv = mctx.getEnvelope();
            EndpointReference axisEPR = new EndpointReference(((MutableEndpoint)odeMex.getEndpointReference()).getUrl());
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Axis2 sending message to " + axisEPR.getAddress() + " using MEX " + odeMex));
                __log.debug((Object)("Message: " + soapEnv));
            }
            ServiceClient client = this.getCachedServiceClient().client;
            final OperationClient operationClient = client.createClient(isTwoWay ? ServiceClient.ANON_OUT_IN_OP : ServiceClient.ANON_OUT_ONLY_OP);
            operationClient.addMessageContext(mctx);
            Options operationOptions = operationClient.getOptions();
            operationOptions.setAction(mctx.getSoapAction());
            operationOptions.setTo(axisEPR);
            if (isTwoWay) {
                final String mexId = odeMex.getMessageExchangeId();
                final Operation operation = odeMex.getOperation();
                this._sched.registerSynchronizer(new Scheduler.Synchronizer(){

                    public void afterCompletion(boolean success) {
                        if (!success) {
                            return;
                        }
                        SoapExternalService.this._executorService.submit(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                try {
                                    operationClient.execute(true);
                                    MessageContext response = operationClient.getMessageContext("In");
                                    MessageContext flt = operationClient.getMessageContext("Fault");
                                    if (response != null && __log.isDebugEnabled()) {
                                        __log.debug((Object)("Service response:\n" + response.getEnvelope().toString()));
                                    }
                                    if (flt != null) {
                                        SoapExternalService.this.reply(mexId, operation, flt, true);
                                    } else {
                                        SoapExternalService.this.reply(mexId, operation, response, response.isFault());
                                    }
                                }
                                catch (Throwable t) {
                                    String errmsg = "Error sending message (mex=" + odeMex + "): " + t.getMessage();
                                    __log.error((Object)errmsg, t);
                                    SoapExternalService.this.replyWithFailure(mexId, MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
                                }
                                return null;
                            }
                        });
                    }

                    public void beforeCompletion() {
                    }
                });
                odeMex.replyAsync();
            } else {
                this._executorService.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        operationClient.execute(false);
                        return null;
                    }
                });
                odeMex.replyOneWayOk();
            }
        }
        catch (AxisFault axisFault) {
            String errmsg = "Error sending message to Axis2 for ODE mex " + odeMex;
            __log.error((Object)errmsg, (Throwable)axisFault);
            odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
        }
    }

    private CachedServiceClient getCachedServiceClient() throws AxisFault {
        CachedServiceClient cachedServiceClient = _cachedClients.get();
        if (cachedServiceClient == null) {
            cachedServiceClient = new CachedServiceClient(new File(this._pconf.getBaseURI().resolve(this._serviceName.getLocalPart() + ".axis2")), 30000L);
            _cachedClients.set(cachedServiceClient);
        }
        try {
            cachedServiceClient.check();
        }
        catch (RuntimeException e) {
            throw AxisFault.makeFault((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
        CachedOptions cachedOptions = _cachedOptions.get();
        if (cachedOptions == null) {
            cachedOptions = new CachedOptions();
            _cachedOptions.set(cachedOptions);
        }
        cachedOptions.check();
        cachedServiceClient.client.setOptions(cachedOptions.options);
        return cachedServiceClient;
    }

    private String getAction(String operation) {
        String action = this._converter.getWSAInputAction(operation);
        if (action == null || "".equals(action)) {
            action = this._converter.getSoapAction(operation);
        }
        return action;
    }

    private void writeHeader(MessageContext ctxt, PartnerRoleMessageExchange odeMex) {
        Options options = ctxt.getOptions();
        WSAEndpoint targetEPR = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)odeMex.getEndpointReference()));
        WSAEndpoint myRoleEPR = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)odeMex.getMyRoleEndpointReference()));
        String partnerSessionId = odeMex.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        String myRoleSessionId = odeMex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (partnerSessionId != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Partner session identifier found for WSA endpoint: " + partnerSessionId));
            }
            targetEPR.setSessionId(partnerSessionId);
        }
        options.setProperty("targetSessionEndpoint", (Object)targetEPR);
        if (myRoleEPR != null) {
            if (myRoleSessionId != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MyRole session identifier found for myrole (callback) WSA endpoint: " + myRoleSessionId));
                }
                myRoleEPR.setSessionId(myRoleSessionId);
            }
            options.setProperty("callbackSessionEndpoint", (Object)odeMex.getMyRoleEndpointReference());
        } else {
            __log.debug((Object)"My-Role EPR not specified, SEP will not be used.");
        }
        String action = this.getAction(odeMex.getOperationName());
        ctxt.setSoapAction(action);
        if (MessageExchange.MessageExchangePattern.REQUEST_RESPONSE == odeMex.getMessageExchangePattern()) {
            EndpointReference annonEpr = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
            ctxt.setReplyTo(annonEpr);
            ctxt.setMessageID("uuid:" + new UUID().toString());
        }
    }

    public org.apache.ode.bpel.iapi.EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void close() {
    }

    public String getPortName() {
        return this._portName;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    private void replyWithFailure(final String odeMexId, final MessageExchange.FailureType error, final String errmsg, final Element details) {
        try {
            this._sched.execIsolatedTransaction((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)SoapExternalService.this._server.getEngine().getMessageExchange(odeMexId);
                    odeMex.replyWithFailure(error, errmsg, details);
                    return null;
                }
            });
        }
        catch (Exception e) {
            String emsg = "Error executing replyWithFailure transaction; reply will be lost.";
            __log.error((Object)emsg, (Throwable)e);
        }
    }

    private void reply(final String odeMexId, final Operation operation, final MessageContext reply, final boolean fault) {
        try {
            this._sched.execIsolatedTransaction((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)SoapExternalService.this._server.getEngine().getMessageExchange(odeMexId);
                    try {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Received response for MEX " + odeMex));
                        }
                        if (fault) {
                            Document odeMsg = DOMUtils.newDocument();
                            Element odeMsgEl = odeMsg.createElementNS(null, "message");
                            odeMsg.appendChild(odeMsgEl);
                            QName faultType = SoapExternalService.this._converter.parseSoapFault(odeMsgEl, reply.getEnvelope(), operation);
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("Reply is a fault, found type: " + faultType));
                            }
                            if (faultType != null) {
                                if (__log.isWarnEnabled()) {
                                    __log.warn((Object)("Fault response: faultType=" + faultType + "\n" + DOMUtils.domToString((Node)odeMsgEl)));
                                }
                                Message response = odeMex.createMessage(faultType);
                                response.setMessage(odeMsgEl);
                                odeMex.replyWithFault(faultType, response);
                            } else {
                                if (__log.isWarnEnabled()) {
                                    __log.warn((Object)("Fault response: faultType=(unkown)\n" + reply.getEnvelope().toString()));
                                }
                                odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, reply.getEnvelope().getBody().getFault().getText(), OMUtils.toDOM((OMElement)reply.getEnvelope().getBody()));
                            }
                        } else {
                            Message response = odeMex.createMessage(odeMex.getOperation().getOutput().getMessage().getQName());
                            SoapExternalService.this._converter.parseSoapResponse(response, reply.getEnvelope(), operation);
                            if (__log.isInfoEnabled()) {
                                __log.info((Object)("Response:\n" + (response.getMessage() != null ? DOMUtils.domToString((Node)response.getMessage()) : "empty")));
                            }
                            odeMex.reply(response);
                        }
                    }
                    catch (Exception ex) {
                        String errmsg = "Unable to process response: " + ex.getMessage();
                        __log.error((Object)errmsg, (Throwable)ex);
                        odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errmsg = "Error executing reply transaction; reply will be lost.";
            __log.error((Object)errmsg, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedOptions
    extends WatchDog<Map> {
        Options options;

        private CachedOptions() {
            super((WatchDog.Mutable)new WatchDog.Mutable<Map>(){

                public boolean exists() {
                    return true;
                }

                public boolean hasChangedSince(Map since) {
                    Map latest = this.lastModified();
                    return !CollectionUtils.equals((Map)latest, (Map)since);
                }

                public Map lastModified() {
                    return SoapExternalService.this._pconf.getEndpointProperties((org.apache.ode.bpel.iapi.EndpointReference)SoapExternalService.this.endpointReference);
                }
            });
        }

        protected boolean isInitialized() {
            return this.options != null;
        }

        protected void init() {
            this.options = new Options();
        }

        protected void doOnUpdate() {
            this.init();
            Map properties = SoapExternalService.this._pconf.getEndpointProperties((org.apache.ode.bpel.iapi.EndpointReference)SoapExternalService.this.endpointReference);
            Properties.Axis2.translate(properties, this.options);
            this.options.setExceptionToBeThrownOnSOAPFault(false);
            this.options.setTimeOutInMilliSeconds(60000L);
        }
    }

    private class CachedServiceClient
    extends FileWatchDog {
        ServiceClient client;

        protected CachedServiceClient(File file, long delay) {
            super(file, delay);
        }

        protected boolean isInitialized() {
            return this.client != null;
        }

        protected void init() {
            try {
                this.client = new ServiceClient(new ConfigurationContext(SoapExternalService.this._axisConfig), null);
            }
            catch (AxisFault axisFault) {
                throw new RuntimeException(axisFault);
            }
        }

        protected void doOnUpdate() {
            block4: {
                this.init();
                try {
                    InputStream ais = this.file.toURI().toURL().openStream();
                    if (ais != null) {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Configuring service " + SoapExternalService.this._serviceName + " using: " + this.file));
                        }
                        ServiceBuilder builder = new ServiceBuilder(ais, new ConfigurationContext(this.client.getAxisConfiguration()), this.client.getAxisService());
                        builder.populateService(builder.buildOM());
                    }
                }
                catch (Exception e) {
                    if (!__log.isWarnEnabled()) break block4;
                    __log.warn((Object)("Exception while configuring service: " + SoapExternalService.this._serviceName), (Throwable)e);
                }
            }
        }
    }
}

