/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.deploy;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ODEServer;

public class DeploymentPoller {
    private static Log __log = LogFactory.getLog(DeploymentPoller.class);
    private static final long POLL_TIME = 3000L;
    private File _deployDir;
    private PollingThread _poller;
    private ODEServer _odeServer;
    private boolean _onHold = false;
    private static final FileFilter _fileFilter = new FileFilter(){

        public boolean accept(File path) {
            if (path.isDirectory()) {
                return path.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().equals("deploy.xml");
                    }
                }).length == 1;
            }
            return false;
        }
    };
    private static final FileFilter _deployedFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.isFile() && path.getName().endsWith(".deployed");
        }
    };

    public DeploymentPoller(File deployDir, ODEServer odeServer) {
        this._odeServer = odeServer;
        this._deployDir = deployDir;
        if (!this._deployDir.exists()) {
            this._deployDir.mkdir();
        }
    }

    public void start() {
        this._poller = new PollingThread();
        this._poller.start();
        __log.info((Object)"Poller started.");
    }

    public void stop() {
        this._poller.kill();
        this._poller = null;
    }

    private void check() {
        File[] deployed;
        File[] files;
        for (File file : files = this._deployDir.listFiles(_fileFilter)) {
            File deployXml = new File(file, "deploy.xml");
            File deployedMarker = new File(this._deployDir, file.getName() + ".deployed");
            if (!deployXml.exists()) {
                __log.debug((Object)("Not deploying " + file + " (missing deploy.xml)"));
            }
            if (deployedMarker.exists()) continue;
            try {
                deployedMarker.createNewFile();
            }
            catch (IOException e1) {
                __log.error((Object)("Error creating deployed marker file, " + file + " will not be deployed"));
                continue;
            }
            try {
                this._odeServer.getProcessStore().undeploy(file);
            }
            catch (Exception ex) {
                __log.error((Object)("Error undeploying " + file.getName()));
            }
            try {
                Collection deployed2 = this._odeServer.getProcessStore().deploy(file);
                __log.info((Object)("Deployment of artifact " + file.getName() + " successful: " + deployed2));
            }
            catch (Exception e) {
                __log.error((Object)("Deployment of " + file.getName() + " failed, aborting for now."), (Throwable)e);
            }
        }
        for (File file : deployed = this._deployDir.listFiles(_deployedFilter)) {
            String pkg = file.getName().substring(0, file.getName().length() - ".deployed".length());
            File deployDir = new File(this._deployDir, pkg);
            if (deployDir.exists()) continue;
            Collection undeployed = this._odeServer.getProcessStore().undeploy(deployDir);
            file.delete();
            if (undeployed.size() <= 0) continue;
            __log.info((Object)("Successfully undeployed " + pkg));
        }
    }

    public void hold() {
        this._onHold = true;
    }

    public void release() {
        this._onHold = false;
    }

    public void markAsDeployed(File file) {
        File deployedMarker = new File(this._deployDir, file.getName() + ".deployed");
        try {
            deployedMarker.createNewFile();
        }
        catch (IOException e) {
            __log.error((Object)("Couldn't create marker file for " + file.getName()));
        }
    }

    public void markAsUndeployed(File file) {
        File deployedMarker = new File(this._deployDir, file.getName() + ".deployed");
        deployedMarker.delete();
    }

    private class PollingThread
    extends Thread {
        private boolean _active = true;

        private PollingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            PollingThread pollingThread = this;
            synchronized (pollingThread) {
                this._active = false;
                this.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException ie) {
                __log.fatal((Object)"Thread unexpectedly interrupted.", (Throwable)ie);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this._active) {
                    if (!DeploymentPoller.this._onHold) {
                        DeploymentPoller.this.check();
                    }
                    PollingThread pollingThread = this;
                    synchronized (pollingThread) {
                        try {
                            this.wait(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            catch (Throwable t) {
                __log.fatal((Object)"Encountered an unexpected error.  Exiting poller...", t);
            }
        }
    }
}

