/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ODEAxisDispatcher
extends AbstractDispatcher {
    private static final long serialVersionUID = 2809507126685915170L;
    private static MultiKeyMap _elmtToOperation = new MultiKeyMap();
    public static final String NAME = "ODEAxisDispatcher";
    private static final Log log = LogFactory.getLog(ODEAxisDispatcher.class);
    QName operationName = null;

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        OMElement bodyFirstChild;
        AxisOperation operation;
        String action = messageContext.getWSAAction();
        if (action != null) {
            log.debug((Object)Messages.getMessage((String)"checkingoperation", (String)action));
            operation = service.getOperationByAction(action);
            if (operation != null) {
                return operation;
            }
        }
        if ((bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement()) != null) {
            AxisOperation op;
            String localName = bodyFirstChild.getLocalName();
            log.debug((Object)("Checking for Operation using SOAP message body's first child's local name : " + localName));
            operation = service.getOperation(new QName(localName));
            if (operation != null) {
                log.debug((Object)("Found operation " + operation));
                return operation;
            }
            int index = localName.lastIndexOf("Request");
            if (index >= 0 && index + "Request".length() == localName.length() && (op = service.getOperation(new QName(localName.substring(0, index)))) != null) {
                return op;
            }
            index = localName.lastIndexOf("Response");
            if (index >= 0 && index + "Response".length() == localName.length() && (op = service.getOperation(new QName(localName.substring(0, index)))) != null) {
                return op;
            }
            String opName = (String)_elmtToOperation.get((Object)service.getName(), (Object)localName);
            if (opName != null) {
                operation = service.getOperation(new QName(opName));
                return operation;
            }
        }
        log.warn((Object)"No operation has been found!");
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            log.debug((Object)("Checking for Service using target endpoint address : " + toEPR.getAddress()));
            String path = this.parseRequestURLForService(toEPR.getAddress());
            if (path != null) {
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                AxisService service = registry.getService(path);
                log.debug((Object)("Found service in registry from name " + path + ": " + service));
                return service;
            }
        }
        log.warn((Object)"No service has been found!");
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    protected String parseRequestURLForService(String path) {
        int index = path.indexOf("/processes/");
        if (-1 != index) {
            int serviceStart = index + "/processes/".length();
            if (path.length() > serviceStart + 1) {
                String service = path.substring(serviceStart);
                int queryIndex = service.indexOf(63);
                if (queryIndex > 0) {
                    service = service.substring(0, queryIndex);
                }
                return service;
            }
        }
        return null;
    }

    public static void addElmtToOpMapping(String axisServiceName, String operationName, String elmtName) {
        if (operationName.equals(elmtName)) {
            return;
        }
        _elmtToOperation.put((Object)axisServiceName, (Object)elmtName, (Object)operationName);
    }
}

