/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ODEService;

public class ODEMessageReceiver
extends AbstractMessageReceiver {
    private static final Log __log = LogFactory.getLog(ODEMessageReceiver.class);
    private ODEService _service;

    public final void invokeBusinessLogic(MessageContext msgContext) throws AxisFault {
        if (this.hasResponse(msgContext.getAxisOperation())) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Received request message for " + msgContext.getAxisService().getName() + "." + msgContext.getAxisOperation().getName()));
            }
            MessageContext outMsgContext = Utils.createOutMessageContext((MessageContext)msgContext);
            outMsgContext.getOperationContext().addMessageContext(outMsgContext);
            this.invokeBusinessLogic(msgContext, outMsgContext);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Reply for " + msgContext.getAxisService().getName() + "." + msgContext.getAxisOperation().getName()));
                __log.debug((Object)("Reply message " + outMsgContext.getEnvelope()));
            }
            AxisEngine.send((MessageContext)outMsgContext);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Received one-way message for " + msgContext.getAxisService().getName() + "." + msgContext.getAxisOperation().getName()));
            }
            this.invokeBusinessLogic(msgContext, null);
        }
    }

    private void invokeBusinessLogic(MessageContext msgContext, MessageContext outMsgContext) throws AxisFault {
        this._service.onAxisMessageExchange(msgContext, outMsgContext, this.getSOAPFactory(msgContext));
    }

    public void setService(ODEService service) {
        this._service = service;
    }

    private boolean hasResponse(AxisOperation op) {
        switch (op.getAxisSpecificMEPConstant()) {
            case 12: {
                return true;
            }
            case 14: {
                return true;
            }
            case 17: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }
}

