/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.ProxyConf;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpClientHelper {
    private static final Log log = LogFactory.getLog(HttpClientHelper.class);
    private static final Pattern NON_LWS_PATTERN = Pattern.compile("\r\n([^\\s])");

    public static void configure(HostConfiguration hostConfig, HttpState state, URI targetURI, HttpParams params) throws URIException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring http client...");
        }
        if (ProxyConf.isProxyEnabled(params, targetURI.getHost())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ProxyConf");
            }
            ProxyConf.configure(hostConfig, state, (HttpTransportProperties.ProxyProperties)params.getParameter("http.proxy."));
        }
    }

    public static Element statusLineToElement(String statusLine) throws HttpException {
        return HttpClientHelper.statusLineToElement(new StatusLine(statusLine));
    }

    public static Element statusLineToElement(StatusLine statusLine) {
        return HttpClientHelper.statusLineToElement(DOMUtils.newDocument(), statusLine);
    }

    public static Element statusLineToElement(Document doc, StatusLine statusLine) {
        Element statusLineEl = doc.createElementNS(null, "Status-Line");
        Element versionEl = doc.createElementNS(null, "HTTP-Version");
        Element codeEl = doc.createElementNS(null, "Status-Code");
        Element reasonEl = doc.createElementNS(null, "Reason-Phrase");
        doc.appendChild(statusLineEl);
        statusLineEl.appendChild(versionEl);
        statusLineEl.appendChild(codeEl);
        statusLineEl.appendChild(reasonEl);
        versionEl.setTextContent(statusLine.getHttpVersion());
        codeEl.setTextContent(String.valueOf(statusLine.getStatusCode()));
        reasonEl.setTextContent(statusLine.getReasonPhrase());
        return statusLineEl;
    }

    public static Element prepareDetailsElement(HttpMethod method) throws IOException {
        return HttpClientHelper.prepareDetailsElement(method, true);
    }

    public static Element prepareDetailsElement(HttpMethod method, boolean bodyIsXml) throws IOException {
        Document doc = DOMUtils.newDocument();
        Element detailsEl = doc.createElementNS(null, "details");
        Element statusLineEl = HttpClientHelper.statusLineToElement(doc, method.getStatusLine());
        detailsEl.appendChild(statusLineEl);
        InputStream bodyAsStream = method.getResponseBodyAsStream();
        if (bodyAsStream != null) {
            Element bodyEl = doc.createElementNS(null, "responseBody");
            detailsEl.appendChild(bodyEl);
            boolean exceptionDuringParsing = false;
            if (bodyIsXml) {
                try {
                    Element parsedBodyEl = DOMUtils.parse((InputStream)bodyAsStream).getDocumentElement();
                    bodyEl.appendChild(parsedBodyEl);
                }
                catch (Exception e) {
                    String errmsg = "Unable to parse the response body as xml. Body will be inserted as string.";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errmsg, (Throwable)e);
                    }
                    exceptionDuringParsing = true;
                }
            }
            if (!bodyIsXml || exceptionDuringParsing) {
                bodyEl.setTextContent(method.getResponseBodyAsString());
            }
        }
        return detailsEl;
    }

    public static String replaceCRLFwithLWS(String header) {
        Matcher m = NON_LWS_PATTERN.matcher(header);
        StringBuffer sb = new StringBuffer(header.length());
        while (m.find()) {
            m.appendReplacement(sb, "\r\n\t");
            sb.append(m.group(1));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

