/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.Properties;
import org.apache.ode.axis2.httpbinding.HttpClientHelper;
import org.apache.ode.axis2.httpbinding.HttpMethodConverter;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpExternalService
implements ExternalService {
    private static final Log log = LogFactory.getLog(HttpExternalService.class);
    private static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    private MultiThreadedHttpConnectionManager connections;
    protected ExecutorService executorService;
    protected Scheduler scheduler;
    protected BpelServer server;
    protected ProcessConf pconf;
    private String targetNamespace;
    protected QName serviceName;
    protected String portName;
    protected WSAEndpoint endpointReference;
    protected HttpMethodConverter httpMethodConverter;
    protected Binding portBinding;

    public HttpExternalService(ProcessConf pconf, QName serviceName, String portName, ExecutorService executorService, Scheduler scheduler, BpelServer server) {
        this.portName = portName;
        this.serviceName = serviceName;
        this.executorService = executorService;
        this.scheduler = scheduler;
        this.server = server;
        this.pconf = pconf;
        Definition definition = pconf.getDefinitionForService(serviceName);
        this.targetNamespace = definition.getTargetNamespace();
        Service serviceDef = definition.getService(serviceName);
        if (serviceDef == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(serviceName));
        }
        Port port = serviceDef.getPort(portName);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this.portBinding = port.getBinding();
        if (this.portBinding == null) {
            throw new IllegalArgumentException(msgs.msgBindingNotFound(portName));
        }
        if (!WsdlUtils.useHTTPBinding((Port)port)) {
            throw new IllegalArgumentException(msgs.msgNoHTTPBindingForPort(portName));
        }
        Element eprElmt = ODEService.genEPRfromWSDL(definition, serviceName, portName);
        if (eprElmt == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(eprElmt));
        this.httpMethodConverter = new HttpMethodConverter(this.portBinding);
        this.connections = new MultiThreadedHttpConnectionManager();
    }

    public String getPortName() {
        return this.portName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void close() {
        this.connections.shutdown();
    }

    public EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void invoke(PartnerRoleMessageExchange odeMex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Preparing " + this.getClass().getSimpleName() + " invocation..."));
        }
        try {
            boolean isTwoWay;
            Map properties = this.pconf.getEndpointProperties((EndpointReference)this.endpointReference);
            HttpParams params = Properties.HttpClient.translate(properties);
            HttpMethod method = this.httpMethodConverter.createHttpRequest(odeMex, params);
            HttpClient client = new HttpClient((HttpConnectionManager)this.connections);
            client.getParams().setDefaults(params);
            HttpClientHelper.configure(client.getHostConfiguration(), client.getState(), method.getURI(), params);
            boolean bl = isTwoWay = odeMex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
            if (isTwoWay) {
                final TwoWayCallable executionCallable = new TwoWayCallable(client, method, odeMex.getMessageExchangeId(), odeMex.getOperation());
                this.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                    public void afterCompletion(boolean success) {
                        if (!success) {
                            return;
                        }
                        HttpExternalService.this.executorService.submit(executionCallable);
                    }

                    public void beforeCompletion() {
                    }
                });
                odeMex.replyAsync();
            } else {
                OneWayCallable executionCallable = new OneWayCallable(client, method, odeMex.getMessageExchangeId(), odeMex.getOperation());
                this.executorService.submit(executionCallable);
                odeMex.replyOneWayOk();
            }
        }
        catch (UnsupportedEncodingException e) {
            String errmsg = "The HTTP encoding returned isn't supported " + odeMex;
            log.error((Object)errmsg, (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
        }
        catch (URIException e) {
            String errmsg = "Error sending message to " + this.getClass().getSimpleName() + " for ODE mex " + odeMex;
            log.error((Object)errmsg, (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
        }
        catch (Exception e) {
            String errmsg = "Unknown HTTP call error for ODE mex " + odeMex;
            log.error((Object)errmsg, (Throwable)e);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
        }
    }

    private class TwoWayCallable
    extends OneWayCallable {
        public TwoWayCallable(HttpClient client, HttpMethod method, String mexId, Operation operation) {
            super(client, method, mexId, operation);
        }

        public void processResponse(final int statusCode) {
            try {
                HttpExternalService.this.scheduler.execIsolatedTransaction((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (statusCode >= 200 && statusCode < 300) {
                            TwoWayCallable.this._2xx_success();
                        } else if (statusCode >= 300 && statusCode < 400) {
                            TwoWayCallable.this._3xx_redirection();
                        } else if (statusCode >= 400 && statusCode < 500) {
                            TwoWayCallable.this._4xx_badRequest();
                        } else if (statusCode >= 500 && statusCode < 600) {
                            TwoWayCallable.this._5xx_serverError();
                        } else {
                            TwoWayCallable.this.unmanagedStatus();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                String errmsg = "Error executing reply transaction; reply will be lost.";
                log.error((Object)errmsg, (Throwable)e);
            }
        }

        private void unmanagedStatus() throws IOException {
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            String errmsg = "Unmanaged Status Code! " + this.method.getStatusLine();
            log.error((Object)errmsg);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
        }

        private void _5xx_serverError() throws IOException {
            String errmsg = "Internal Server Error! " + this.method.getStatusLine();
            log.error((Object)errmsg);
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            Operation opDef = odeMex.getOperation();
            BindingOperation opBinding = HttpExternalService.this.portBinding.getBindingOperation(opDef.getName(), opDef.getInput().getName(), opDef.getOutput().getName());
            if (opDef.getFaults().isEmpty()) {
                errmsg = "Operation has no fault. This 500 error will be considered as a failure.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)errmsg);
                }
                odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
            } else if (opBinding.getBindingFaults().isEmpty()) {
                errmsg = "No fault binding. This 500 error will be considered as a failure.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)errmsg);
                }
                odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
            } else if (this.method.getResponseBodyAsStream() == null) {
                errmsg = "No body in the response. This 500 error will be considered as a failure.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)errmsg);
                }
                odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
            } else {
                InputStream bodyAsStream = this.method.getResponseBodyAsStream();
                try {
                    Element bodyEl = DOMUtils.parse((InputStream)bodyAsStream).getDocumentElement();
                    QName bodyName = new QName(bodyEl.getNamespaceURI(), bodyEl.getNodeName());
                    Fault faultDef = WsdlUtils.inferFault((Operation)opDef, (QName)bodyName);
                    if (!WsdlUtils.isOdeFault((BindingFault)opBinding.getBindingFault(faultDef.getName()))) {
                        errmsg = "Fault " + bodyName + " is not bound with " + new QName("http://www.apache.org/ode/type/extension/http", "fault") + ". This 500 error will be considered as a failure.";
                        if (log.isDebugEnabled()) {
                            log.debug((Object)errmsg);
                        }
                        odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
                    } else {
                        Part partDef = (Part)faultDef.getMessage().getParts().values().iterator().next();
                        Document odeMsg = DOMUtils.newDocument();
                        Element odeMsgEl = odeMsg.createElementNS(null, "message");
                        Element partEl = odeMsgEl.getOwnerDocument().createElementNS(null, partDef.getName());
                        odeMsgEl.appendChild(partEl);
                        partEl.appendChild(odeMsgEl.getOwnerDocument().importNode(bodyEl, true));
                        QName faultType = new QName(HttpExternalService.this.targetNamespace, faultDef.getName());
                        org.apache.ode.bpel.iapi.Message response = odeMex.createMessage(faultType);
                        response.setMessage(odeMsgEl);
                        HttpExternalService.this.httpMethodConverter.extractHttpResponseHeaders(response, this.method, faultDef.getMessage(), opBinding.getBindingOutput());
                        odeMex.replyWithFault(faultType, response);
                    }
                }
                catch (Exception e) {
                    errmsg = "Unable to parse the response body as xml. This 500 error will be considered as a failure.";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errmsg, (Throwable)e);
                    }
                    odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method, false));
                }
            }
        }

        private void _4xx_badRequest() throws IOException {
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            String errmsg = "Bad Request! " + this.method.getStatusLine();
            log.error((Object)errmsg);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
        }

        private void _3xx_redirection() throws IOException {
            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
            String errmsg = "Redirections are not supported! " + this.method.getStatusLine();
            log.error((Object)errmsg);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
        }

        private void _2xx_success() {
            block11: {
                Operation opDef;
                BindingOperation opBinding;
                MIMEContent outputContent;
                PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(this.mexId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Http Status Line=" + this.method.getStatusLine()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received response for MEX " + odeMex));
                }
                boolean isBodyMandatory = (outputContent = WsdlUtils.getMimeContent((List)(opBinding = HttpExternalService.this.portBinding.getBindingOperation((opDef = odeMex.getOperation()).getName(), opDef.getInput().getName(), opDef.getOutput().getName())).getBindingOutput().getExtensibilityElements())) != null && outputContent.getType().endsWith("text/xml");
                try {
                    InputStream bodyAsStream = this.method.getResponseBodyAsStream();
                    if (isBodyMandatory && bodyAsStream == null) {
                        String errmsg = "Response body is mandatory but missing! Msg Id=" + odeMex.getMessageExchangeId();
                        log.error((Object)errmsg);
                        odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
                        break block11;
                    }
                    Message outputMessage = odeMex.getOperation().getOutput().getMessage();
                    org.apache.ode.bpel.iapi.Message odeResponse = odeMex.createMessage(outputMessage.getQName());
                    if (bodyAsStream != null) {
                        try {
                            Element bodyElement = DOMUtils.parse((InputStream)bodyAsStream).getDocumentElement();
                            Part part = (Part)outputMessage.getParts().values().iterator().next();
                            Element partElement = HttpExternalService.this.httpMethodConverter.createPartElement(part, bodyElement);
                            odeResponse.setPart(part.getName(), partElement);
                        }
                        catch (Exception e) {
                            String errmsg = "Unable to parse the response body: " + e.getMessage();
                            log.error((Object)errmsg, (Throwable)e);
                            odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
                            return;
                        }
                    }
                    HttpExternalService.this.httpMethodConverter.extractHttpResponseHeaders(odeResponse, this.method, outputMessage, opBinding.getBindingOutput());
                    try {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Response:\n" + DOMUtils.domToString((Node)odeResponse.getMessage())));
                        }
                        odeMex.reply(odeResponse);
                    }
                    catch (Exception ex) {
                        String errmsg = "Unable to process response: " + ex.getMessage();
                        log.error((Object)errmsg, (Throwable)ex);
                        odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, HttpClientHelper.prepareDetailsElement(this.method));
                    }
                }
                catch (IOException e) {
                    String errmsg = "Unable to get the request body : " + e.getMessage();
                    log.error((Object)errmsg, (Throwable)e);
                    odeMex.replyWithFailure(MessageExchange.FailureType.FORMAT_ERROR, errmsg, null);
                    return;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneWayCallable
    implements Callable<Void> {
        HttpMethod method;
        String mexId;
        Operation operation;
        HttpClient client;

        public OneWayCallable(HttpClient client, HttpMethod method, String mexId, Operation operation) {
            this.method = method;
            this.mexId = mexId;
            this.operation = operation;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing http request : " + this.method.getName() + " " + this.method.getURI()));
                }
                int statusCode = this.client.executeMethod(this.method);
                byte[] responseBody = this.method.getResponseBody();
                this.processResponse(statusCode);
            }
            catch (IOException e) {
                try {
                    HttpExternalService.this.scheduler.execIsolatedTransaction((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)HttpExternalService.this.server.getEngine().getMessageExchange(OneWayCallable.this.mexId);
                            String errmsg = "Unable to execute http request : " + e.getMessage();
                            log.error((Object)errmsg, (Throwable)e);
                            odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
                            return null;
                        }
                    });
                }
                catch (Exception e1) {
                    String errmsg = "Error executing reply transaction; reply will be lost.";
                    log.error((Object)errmsg, (Throwable)e);
                }
            }
            finally {
                this.method.releaseConnection();
            }
            return null;
        }

        public void processResponse(int statusCode) {
            block6: {
                try {
                    if (statusCode >= 400) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("OneWay http request [" + this.method.getURI() + "] failed with status: " + this.method.getStatusLine()));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("OneWay http request [" + this.method.getURI() + "] status: " + this.method.getStatusLine()));
                    }
                }
                catch (URIException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)e);
                }
            }
        }
    }
}

