/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.HttpClientHelper;
import org.apache.ode.axis2.util.URLEncodedTransformer;
import org.apache.ode.axis2.util.UrlReplacementTransformer;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodConverter {
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final Log log = LogFactory.getLog(HttpMethodConverter.class);
    protected static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    protected Binding binding;

    public HttpMethodConverter(Binding binding) {
        this.binding = binding;
    }

    public HttpMethod createHttpRequest(PartnerRoleMessageExchange odeMex, HttpParams params) throws UnsupportedEncodingException {
        Operation operation = odeMex.getOperation();
        BindingOperation bindingOperation = this.binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        Element message = odeMex.getRequest().getMessage();
        Message msgDef = operation.getInput().getMessage();
        String url = ((MutableEndpoint)odeMex.getEndpointReference()).getUrl();
        Map<String, Element> partElements = this.extractPartElements(msgDef, message);
        String verb = WsdlUtils.resolveVerb((Binding)this.binding, (BindingOperation)bindingOperation);
        HttpMethod method = this.prepareHttpMethod(bindingOperation, verb, partElements, url, params);
        return method;
    }

    protected HttpMethod prepareHttpMethod(BindingOperation opBinding, String verb, Map<String, Element> partValues, String rootUri, HttpParams params) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing http request...");
        }
        BindingInput bindingInput = opBinding.getBindingInput();
        HTTPOperation httpOperation = (HTTPOperation)WsdlUtils.getOperationExtension((BindingOperation)opBinding);
        MIMEContent content = WsdlUtils.getMimeContent((List)bindingInput.getExtensibilityElements());
        String contentType = content == null ? "" : content.getType();
        boolean useUrlEncoded = WsdlUtils.useUrlEncoded((BindingInput)bindingInput) || "application/x-www-form-urlencoded".equalsIgnoreCase(contentType);
        boolean useUrlReplacement = WsdlUtils.useUrlReplacement((BindingInput)bindingInput);
        GetMethod method = null;
        String relativeUri = httpOperation.getLocationURI();
        String queryPath = null;
        String encodedParams = null;
        String completeUri = rootUri;
        if (StringUtils.isNotEmpty((String)relativeUri)) {
            completeUri = completeUri + (completeUri.endsWith("/") || relativeUri.startsWith("/") ? "" : "/") + relativeUri;
        }
        if (useUrlReplacement) {
            completeUri = new UrlReplacementTransformer().transform(completeUri, partValues);
        } else if (useUrlEncoded) {
            encodedParams = new URLEncodedTransformer().transform(partValues);
        }
        if ("GET".equalsIgnoreCase(verb) || "DELETE".equalsIgnoreCase(verb)) {
            if ("GET".equalsIgnoreCase(verb)) {
                method = new GetMethod();
            } else if ("DELETE".equalsIgnoreCase(verb)) {
                method = new DeleteMethod();
            }
            if (useUrlEncoded) {
                queryPath = encodedParams;
            }
            method.setFollowRedirects(true);
        } else if ("POST".equalsIgnoreCase(verb) || "PUT".equalsIgnoreCase(verb)) {
            StringRequestEntity requestEntity;
            if ("POST".equalsIgnoreCase(verb)) {
                method = new PostMethod();
            } else if ("PUT".equalsIgnoreCase(verb)) {
                method = new PutMethod();
            }
            if (useUrlEncoded) {
                requestEntity = new StringRequestEntity(encodedParams, "application/x-www-form-urlencoded", method.getParams().getContentCharset());
            } else if (contentType.endsWith(CONTENT_TYPE_TEXT_XML)) {
                Part part = opBinding.getOperation().getInput().getMessage().getPart(content.getPart());
                Element partValue = partValues.get(part.getName());
                if (part.getElementName() != null) {
                    partValue = DOMUtils.getFirstChildElement((Element)partValue);
                }
                String xmlString = DOMUtils.domToString((Node)partValue);
                requestEntity = new ByteArrayRequestEntity(xmlString.getBytes(), contentType);
            } else {
                throw new IllegalArgumentException("Unsupported content-type!");
            }
            EntityEnclosingMethod enclosingMethod = (EntityEnclosingMethod)method;
            enclosingMethod.setRequestEntity((RequestEntity)requestEntity);
            enclosingMethod.setContentChunked(params.getBooleanParameter("http.request.chunk", false));
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + verb);
        }
        method.getParams().setDefaults(params);
        method.setPath(completeUri);
        method.setQueryString(queryPath);
        this.setHttpRequestHeaders((HttpMethod)method, partValues, opBinding.getOperation().getInput().getMessage(), opBinding.getBindingInput());
        return method;
    }

    public void setHttpRequestHeaders(HttpMethod method, Map<String, Element> partValues, Message inputMessage, BindingInput bindingInput) {
        Collection headerBindings = WsdlUtils.getHttpHeaders((List)bindingInput.getExtensibilityElements());
        Iterator iterator = headerBindings.iterator();
        while (iterator.hasNext()) {
            String headerValue;
            Element binding = ((UnknownExtensibilityElement)iterator.next()).getElement();
            String headerName = binding.getAttribute("name");
            String partName = binding.getAttribute("part");
            String value = binding.getAttribute("value");
            if (StringUtils.isNotEmpty((String)partName)) {
                Part part = inputMessage.getPart(partName);
                Element partValue = partValues.get(part.getName());
                if (part.getElementName() != null) {
                    partValue = DOMUtils.getFirstChildElement((Element)partValue);
                }
                headerValue = DOMUtils.domToString((Node)partValue);
            } else if (StringUtils.isNotEmpty((String)value)) {
                headerValue = value;
            } else {
                String errMsg = "Invalid binding: missing attribute! Expecting " + new QName("http://www.apache.org/ode/type/extension/http", "part") + " or " + new QName("http://www.apache.org/ode/type/extension/http", "value");
                if (log.isErrorEnabled()) {
                    log.error((Object)errMsg);
                }
                throw new RuntimeException(errMsg);
            }
            method.setRequestHeader(headerName, HttpClientHelper.replaceCRLFwithLWS(headerValue));
        }
    }

    protected Map<String, Element> extractPartElements(Message msgDef, Element message) {
        HashMap<String, Element> partValues = new HashMap<String, Element>();
        for (Part part : msgDef.getParts().values()) {
            Element partEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, part.getName()));
            if (partEl == null) {
                throw new IllegalArgumentException(msgs.msgOdeMessageMissingRequiredPart(part.getName()));
            }
            partValues.put(part.getName(), partEl);
        }
        return partValues;
    }

    public Element createPartElement(Part part, String textContent) {
        Document doc = DOMUtils.newDocument();
        Element partElement = doc.createElementNS(null, part.getName());
        if (part.getElementName() != null) {
            Element element = doc.createElementNS(part.getElementName().getNamespaceURI(), part.getElementName().getLocalPart());
            element.setTextContent(textContent);
            partElement.appendChild(element);
        } else {
            partElement.setTextContent(textContent);
        }
        return partElement;
    }

    public Element createPartElement(Part part, Element receivedElement) {
        Document doc = DOMUtils.newDocument();
        Element partElement = doc.createElementNS(null, part.getName());
        if (part.getElementName() != null) {
            partElement.appendChild(doc.importNode(receivedElement, true));
        } else if (DOMUtils.isEmptyElement((Element)receivedElement)) {
            partElement.appendChild(doc.createTextNode(""));
        } else {
            for (int m = 0; m < receivedElement.getChildNodes().getLength(); ++m) {
                Node child = receivedElement.getChildNodes().item(m);
                partElement.appendChild(doc.importNode(child, true));
            }
        }
        return partElement;
    }

    public void extractHttpResponseHeaders(org.apache.ode.bpel.iapi.Message odeMessage, HttpMethod method, Message messageDef, BindingOutput bindingOutput) {
        Collection headerBindings = WsdlUtils.getHttpHeaders((List)bindingOutput.getExtensibilityElements());
        Iterator iterator = headerBindings.iterator();
        while (iterator.hasNext()) {
            Element binding = ((UnknownExtensibilityElement)iterator.next()).getElement();
            String partName = binding.getAttribute("part");
            String headerName = binding.getAttribute("name");
            Part part = messageDef.getPart(partName);
            if (StringUtils.isNotEmpty((String)partName)) {
                odeMessage.setPart(partName, this.createPartElement(part, method.getRequestHeader(headerName).getValue()));
                continue;
            }
            String errMsg = "Invalid binding: missing required attribute! Part name: " + new QName("http://www.apache.org/ode/type/extension/http", "part");
            if (log.isErrorEnabled()) {
                log.error((Object)errMsg);
            }
            throw new RuntimeException(errMsg);
        }
        Header[] reqHeaders = method.getResponseHeaders();
        for (int i = 0; i < reqHeaders.length; ++i) {
            Header h = reqHeaders[i];
            odeMessage.setHeaderPart(h.getName(), h.getValue());
        }
    }
}

