/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.store.ProcessStoreImpl;

public class DeploymentBrowser {
    private ProcessStoreImpl _store;
    private AxisConfiguration _config;
    private File _appRoot;
    private static final String CSS = "body {\n    font: 75% Verdana, Helvetica, Arial, sans-serif;\n    background: White;\n    color: Black;\n    margin: 1em;\n    padding: 1em;\n}\n\nh1, h2, h3, h4, h5, h6 {\n    color: Black;\n    clear: left;\n    font: 100% Verdana, Helvetica, Arial, sans-serif;\n    margin: 0;\n    padding-left: 0.5em;\n} \n\nh1 {\n    font-size: 150%;\n    border-bottom: none;\n    text-align: right;\n    border-bottom: 1px solid Gray;\n}\n    \nh2 {\n    font-size: 130%;\n    border-bottom: 1px solid Gray;\n}\n\nh3 {\n    font-size: 120%;\n    padding-left: 1.0em;\n    border-bottom: 1px solid Gray;\n}\n\nh4 {\n    font-size: 110%;\n    padding-left: 1.5em;\n    border-bottom: 1px solid Gray;\n}\n\np {\n    text-align: justify;\n    line-height: 1.5em;\n    padding-left: 1.5em;\n}\n\na {\n    text-decoration: underline;\n    color: Black;\n}";

    public DeploymentBrowser(ProcessStoreImpl store, AxisConfiguration config, File appRoot) {
        this._store = store;
        this._config = config;
        this._appRoot = appRoot;
    }

    public boolean doFilter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        int deplUri = requestURI.indexOf("/deployment");
        if (deplUri > 0) {
            int offset = requestURI.length() > deplUri + 11 ? 1 : 0;
            final String[] segments = requestURI.substring(deplUri + 11 + offset).split("/");
            if (segments.length == 0 || segments[0].length() == 0) {
                this.renderHtml(response, "ODE Deployment Browser", new DocBody(){

                    public void render(Writer out) throws IOException {
                        out.write("<p><a href=\"bundles/\">Deployed Bundles</a></p>");
                        out.write("<p><a href=\"services/\">Process Services</a></p>");
                        out.write("<p><a href=\"processes/\">Deployed Processes</a></p>");
                    }
                });
            } else if (segments.length > 0) {
                if ("services".equals(segments[0])) {
                    if (segments.length == 1) {
                        this.renderHtml(response, "Services Implemented by Your Processes", new DocBody(){

                            public void render(Writer out) throws IOException {
                                for (Object serviceName : DeploymentBrowser.this._config.getServices().keySet()) {
                                    if ("Version".equals(serviceName)) continue;
                                    out.write("<p><a href=\"" + serviceName + "\">" + serviceName + "</a></p>");
                                }
                            }
                        });
                    } else {
                        final String serviceName = requestURI.substring(deplUri + 12 + 9);
                        final AxisService axisService = this._config.getService(serviceName);
                        if (axisService != null) {
                            this.renderXml(response, new DocBody(){

                                public void render(Writer out) throws IOException {
                                    if ("InstanceManagement".equals(serviceName) || "ProcessManagement".equals(serviceName)) {
                                        DeploymentBrowser.this.write(out, new File(DeploymentBrowser.this._appRoot, "pmapi.wsdl").getPath());
                                    } else if ("DeploymentService".equals(serviceName)) {
                                        DeploymentBrowser.this.write(out, new File(DeploymentBrowser.this._appRoot, "deploy.wsdl").getPath());
                                    } else {
                                        DeploymentBrowser.this.write(out, axisService.getFileName().getFile());
                                    }
                                }
                            });
                        } else {
                            this.renderHtml(response, "Service Not Found", new DocBody(){

                                public void render(Writer out) throws IOException {
                                    out.write("<p>Couldn't find service " + serviceName + "</p>");
                                }
                            });
                        }
                    }
                } else if ("processes".equals(segments[0])) {
                    if (segments.length == 1) {
                        this.renderHtml(response, "Deployed Processes", new DocBody(){

                            public void render(Writer out) throws IOException {
                                for (QName process : DeploymentBrowser.this._store.getProcesses()) {
                                    out.write("<p><a href=\"" + process.getLocalPart() + "?ns=" + process.getNamespaceURI() + "\">" + process + "</a></p>");
                                }
                            }
                        });
                    } else {
                        final String processName = requestURI.substring(deplUri + 12 + 10);
                        final String processNs = request.getParameter("ns");
                        final ProcessConf pconf = this._store.getProcessConfiguration(new QName(processNs, processName));
                        if (pconf != null) {
                            this.renderXml(response, new DocBody(){

                                public void render(Writer out) throws IOException {
                                    DeploymentBrowser.this.write(out, new File(pconf.getBaseURI().toURL().getFile(), pconf.getBpelDocument()).getPath());
                                }
                            });
                        } else {
                            this.renderHtml(response, "Process Not Found", new DocBody(){

                                public void render(Writer out) throws IOException {
                                    out.write("<p>Couldn't find process " + new QName(processNs, processName) + "</p>");
                                }
                            });
                        }
                    }
                } else if ("bundles".equals(segments[0])) {
                    if (segments.length == 1) {
                        this.renderHtml(response, "Deployment Bundles", new DocBody(){

                            public void render(Writer out) throws IOException {
                                for (String bundle : DeploymentBrowser.this._store.getPackages()) {
                                    out.write("<p><a href=\"" + bundle + "\">" + bundle + "</a></p>");
                                }
                            }
                        });
                    } else if (segments.length == 2) {
                        this.renderHtml(response, "Files in Bundle " + segments[1], new DocBody(){

                            public void render(Writer out) throws IOException {
                                List processes = DeploymentBrowser.this._store.listProcesses(segments[1]);
                                if (processes != null) {
                                    List files = DeploymentBrowser.this._store.getProcessConfiguration((QName)processes.get(0)).getFiles();
                                    for (File file : files) {
                                        String relativePath = file.getPath().substring(DeploymentBrowser.this._store.getDeployDir().getPath().length() + 1);
                                        out.write("<p><a href=\"" + relativePath + "\">" + relativePath + "</a></p>");
                                    }
                                } else {
                                    out.write("<p>Couldn't find bundle " + segments[2] + "</p>");
                                }
                            }
                        });
                    } else if (segments.length > 2) {
                        List processes = this._store.listProcesses(segments[1]);
                        if (processes != null) {
                            List files = this._store.getProcessConfiguration((QName)processes.get(0)).getFiles();
                            for (final File file : files) {
                                String relativePath = requestURI.substring(deplUri + 12 + 9 + segments[1].length());
                                if (file.getPath().indexOf(relativePath) < 0) continue;
                                this.renderXml(response, new DocBody(){

                                    public void render(Writer out) throws IOException {
                                        DeploymentBrowser.this.write(out, file.getPath());
                                    }
                                });
                                return true;
                            }
                        } else {
                            this.renderHtml(response, "No Bundle Found", new DocBody(){

                                public void render(Writer out) throws IOException {
                                    out.write("<p>Couldn't find bundle " + segments[2] + "</p>");
                                }
                            });
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void renderHtml(HttpServletResponse response, String title, DocBody docBody) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ((Writer)out).write("<html><header><style type=\"text/css\">body {\n    font: 75% Verdana, Helvetica, Arial, sans-serif;\n    background: White;\n    color: Black;\n    margin: 1em;\n    padding: 1em;\n}\n\nh1, h2, h3, h4, h5, h6 {\n    color: Black;\n    clear: left;\n    font: 100% Verdana, Helvetica, Arial, sans-serif;\n    margin: 0;\n    padding-left: 0.5em;\n} \n\nh1 {\n    font-size: 150%;\n    border-bottom: none;\n    text-align: right;\n    border-bottom: 1px solid Gray;\n}\n    \nh2 {\n    font-size: 130%;\n    border-bottom: 1px solid Gray;\n}\n\nh3 {\n    font-size: 120%;\n    padding-left: 1.0em;\n    border-bottom: 1px solid Gray;\n}\n\nh4 {\n    font-size: 110%;\n    padding-left: 1.5em;\n    border-bottom: 1px solid Gray;\n}\n\np {\n    text-align: justify;\n    line-height: 1.5em;\n    padding-left: 1.5em;\n}\n\na {\n    text-decoration: underline;\n    color: Black;\n}</style></header><body>\n");
        ((Writer)out).write("<h2>" + title + "</h2><p/>\n");
        docBody.render(out);
        ((Writer)out).write("</body></html>");
    }

    private void renderXml(HttpServletResponse response, DocBody docBody) throws IOException {
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        docBody.render(out);
    }

    private void write(Writer out, String filePath) throws IOException {
        String line;
        BufferedReader wsdlReader = new BufferedReader(new FileReader(filePath));
        while ((line = wsdlReader.readLine()) != null) {
            out.write(line + "\n");
        }
        wsdlReader.close();
    }

    static interface DocBody {
        public void render(Writer var1) throws IOException;
    }
}

