/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.deploy.DeploymentPoller;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.fs.FileUtils;

public class DeploymentWebService {
    private static final Log __log = LogFactory.getLog(DeploymentWebService.class);
    private final OMNamespace _pmapi = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.apache.org/ode/pmapi", "pmapi");
    private File _deployPath;
    private DeploymentPoller _poller;
    private ProcessStore _store;

    public void enableService(AxisConfiguration axisConfig, BpelServer server, ProcessStore store, DeploymentPoller poller, String rootpath, String workPath) {
        this._deployPath = new File(workPath, "processes");
        this._store = store;
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            File wsdlFile = new File(rootpath + "/deploy.wsdl");
            Definition def = wsdlReader.readWSDL(wsdlFile.toURI().toString());
            AxisService deployService = ODEAxisService.createService(axisConfig, new QName("http://www.apache.org/ode/deployapi", "DeploymentService"), "DeploymentPort", "DeploymentService", def, (MessageReceiver)new DeploymentMessageReceiver());
            axisConfig.addService(deployService);
            this._poller = poller;
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
    }

    class DeploymentMessageReceiver
    extends AbstractMessageReceiver {
        DeploymentMessageReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
            boolean unknown;
            block28: {
                String operation = messageContext.getAxisOperation().getName().getLocalPart();
                SOAPFactory factory = this.getSOAPFactory(messageContext);
                unknown = false;
                try {
                    if (operation.equals("deploy")) {
                        OMElement zip;
                        OMElement namePart = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        OMElement zipPart = (OMElement)namePart.getNextOMSibling();
                        OMElement oMElement = zip = zipPart == null ? null : zipPart.getFirstElement();
                        if (zip == null || !zipPart.getQName().getLocalPart().equals("package") || !zip.getQName().getLocalPart().equals("zip")) {
                            throw new OdeFault("Your message should contain an element named 'package' with a 'zip' element");
                        }
                        OMText binaryNode = (OMText)zip.getFirstOMChild();
                        if (binaryNode == null) {
                            throw new OdeFault("Empty binary node under <zip> element");
                        }
                        binaryNode.setOptimize(true);
                        try {
                            DeploymentWebService.this._poller.hold();
                            File dest = new File(DeploymentWebService.this._deployPath, namePart.getText() + "-" + DeploymentWebService.this._store.getCurrentVersion());
                            dest.mkdir();
                            this.unzip(dest, (DataHandler)binaryNode.getDataHandler());
                            File deployXml = new File(dest, "deploy.xml");
                            if (!deployXml.exists()) {
                                throw new OdeFault("The deployment doesn't appear to contain a deployment descriptor in its root directory named deploy.xml, aborting.");
                            }
                            Collection deployed = DeploymentWebService.this._store.deploy(dest);
                            File deployedMarker = new File(DeploymentWebService.this._deployPath, dest.getName() + ".deployed");
                            deployedMarker.createNewFile();
                            DeploymentWebService.this._poller.markAsDeployed(dest);
                            __log.info((Object)("Deployment of artifact " + dest.getName() + " successful."));
                            OMElement response = factory.createOMElement("response", null);
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("Deployed package: " + dest.getName()));
                            }
                            OMElement d = factory.createOMElement("name", null);
                            d.setText(dest.getName());
                            response.addChild((OMNode)d);
                            for (QName pid : deployed) {
                                if (__log.isDebugEnabled()) {
                                    __log.debug((Object)("Deployed PID: " + pid));
                                }
                                d = factory.createOMElement("id", null);
                                d.setText(pid);
                                response.addChild((OMNode)d);
                            }
                            this.sendResponse(factory, messageContext, "deployResponse", response);
                            break block28;
                        }
                        finally {
                            DeploymentWebService.this._poller.release();
                        }
                    }
                    if (operation.equals("undeploy")) {
                        OMElement part = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        String pkg = part.getText();
                        File deploymentDir = new File(DeploymentWebService.this._deployPath, pkg);
                        if (!deploymentDir.exists()) {
                            throw new OdeFault("Couldn't find deployment package " + pkg + " in directory " + DeploymentWebService.this._deployPath);
                        }
                        try {
                            DeploymentWebService.this._poller.hold();
                            Collection undeployed = DeploymentWebService.this._store.undeploy(deploymentDir);
                            File deployedMarker = new File(DeploymentWebService.this._deployPath, pkg + ".deployed");
                            deployedMarker.delete();
                            FileUtils.deepDelete((File)new File(DeploymentWebService.this._deployPath, pkg));
                            OMElement response = factory.createOMElement("response", null);
                            response.setText("" + (undeployed.size() > 0));
                            this.sendResponse(factory, messageContext, "undeployResponse", response);
                            DeploymentWebService.this._poller.markAsUndeployed(deploymentDir);
                            break block28;
                        }
                        finally {
                            DeploymentWebService.this._poller.release();
                        }
                    }
                    if (operation.equals("listDeployedPackages")) {
                        Collection packageNames = DeploymentWebService.this._store.getPackages();
                        OMElement response = factory.createOMElement("deployedPackages", null);
                        for (String name : packageNames) {
                            OMElement nameElmt = factory.createOMElement("name", null);
                            nameElmt.setText(name);
                            response.addChild((OMNode)nameElmt);
                        }
                        this.sendResponse(factory, messageContext, "listDeployedPackagesResponse", response);
                    } else if (operation.equals("listProcesses")) {
                        OMElement namePart = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        List processIds = DeploymentWebService.this._store.listProcesses(namePart.getText());
                        OMElement response = factory.createOMElement("processIds", null);
                        for (QName qname : processIds) {
                            OMElement nameElmt = factory.createOMElement("id", null);
                            nameElmt.setText(qname);
                            response.addChild((OMNode)nameElmt);
                        }
                        this.sendResponse(factory, messageContext, "listProcessResponse", response);
                    } else if (operation.equals("getProcessPackage")) {
                        OMElement qnamePart = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        ProcessConf process = DeploymentWebService.this._store.getProcessConfiguration(OMUtils.getTextAsQName((OMElement)qnamePart));
                        if (process == null) {
                            throw new OdeFault("Could not find process: " + qnamePart.getTextAsQName());
                        }
                        String packageName = DeploymentWebService.this._store.getProcessConfiguration(OMUtils.getTextAsQName((OMElement)qnamePart)).getPackage();
                        OMElement response = factory.createOMElement("packageName", null);
                        response.setText(packageName);
                        this.sendResponse(factory, messageContext, "getProcessPackageResponse", response);
                    } else {
                        unknown = true;
                    }
                }
                catch (Throwable t) {
                    Throwable source;
                    for (source = t; source.getCause() != null && source.getCause() != source; source = source.getCause()) {
                    }
                    __log.warn((Object)("Invocation of operation " + operation + " failed"), t);
                    throw new OdeFault("Invocation of operation " + operation + " failed: " + source.toString(), t);
                }
            }
            if (unknown) {
                throw new OdeFault("Unknown operation: '" + messageContext.getAxisOperation().getName() + "'");
            }
        }

        private File buildUnusedDir(File deployPath, String dirName) {
            int v = 1;
            while (new File(deployPath, dirName + "-" + v).exists()) {
                ++v;
            }
            return new File(deployPath, dirName + "-" + v);
        }

        private void unzip(File dest, DataHandler dataHandler) throws AxisFault {
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(dataHandler.getDataSource().getInputStream());
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        __log.debug((Object)("Extracting directory: " + entry.getName()));
                        new File(dest, entry.getName()).mkdir();
                        continue;
                    }
                    __log.debug((Object)("Extracting file: " + entry.getName()));
                    File destFile = new File(dest, entry.getName());
                    if (!destFile.getParentFile().exists()) {
                        destFile.getParentFile().mkdirs();
                    }
                    DeploymentWebService.copyInputStream(zis, new BufferedOutputStream(new FileOutputStream(destFile)));
                }
                zis.close();
            }
            catch (IOException e) {
                throw new OdeFault("An error occured on deployment.", e);
            }
        }

        private void sendResponse(SOAPFactory factory, MessageContext messageContext, String op, OMElement response) throws AxisFault {
            MessageContext outMsgContext = Utils.createOutMessageContext((MessageContext)messageContext);
            outMsgContext.getOperationContext().addMessageContext(outMsgContext);
            SOAPEnvelope envelope = factory.getDefaultEnvelope();
            outMsgContext.setEnvelope(envelope);
            OMElement responseOp = factory.createOMElement(op, DeploymentWebService.this._pmapi);
            responseOp.addChild((OMNode)response);
            envelope.getBody().addChild((OMNode)response);
            AxisEngine.send((MessageContext)outMsgContext);
        }
    }
}

