/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.iapi;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.ode.bpel.iapi.ContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Scheduler {
    public void setJobProcessor(JobProcessor var1) throws ContextException;

    public String schedulePersistedJob(Map<String, Object> var1, Date var2) throws ContextException;

    public String scheduleVolatileJob(boolean var1, Map<String, Object> var2) throws ContextException;

    public void cancelJob(String var1) throws ContextException;

    public <T> T execTransaction(Callable<T> var1) throws Exception, ContextException;

    public <T> Future<T> execIsolatedTransaction(Callable<T> var1) throws Exception, ContextException;

    public boolean isTransacted();

    public void registerSynchronizer(Synchronizer var1) throws ContextException;

    public void start();

    public void stop();

    public void shutdown();

    public static class JobProcessorException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final boolean retry;

        public JobProcessorException(boolean retry) {
            this.retry = retry;
        }

        public JobProcessorException(Throwable cause, boolean retry) {
            super(cause);
            this.retry = retry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String jobName;
        public final int retryCount;
        public final Map<String, Object> jobDetail;

        public JobInfo(String jobName, Map<String, Object> jobDetail, int retryCount) {
            this.jobName = jobName;
            this.jobDetail = jobDetail;
            this.retryCount = retryCount;
        }

        public String toString() {
            return this.jobName + "[" + this.retryCount + "]: " + new HashMap<String, Object>(this.jobDetail);
        }
    }

    public static interface JobProcessor {
        public void onScheduledJob(JobInfo var1) throws JobProcessorException;
    }

    public static interface Synchronizer {
        public void afterCompletion(boolean var1);

        public void beforeCompletion();
    }
}

