/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.BpelCompiler11;
import org.apache.ode.bpel.compiler.BpelCompiler20;
import org.apache.ode.bpel.compiler.BpelCompiler20Draft;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultResourceFinder;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.SourceLocationImpl;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompileListener;
import org.apache.ode.bpel.compiler.api.SourceLocation;
import org.apache.ode.bpel.compiler.bom.BpelObjectFactory;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelC {
    private static final Log __log = LogFactory.getLog(BpelC.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    public static final String PROCESS_CUSTOM_PROPERTIES = "customProps";
    private CompileListener _compileListener;
    public OutputStream _outputStream = null;
    private File _bpelFile;
    private File _suDir;
    private ResourceFinder _wsdlFinder;
    private URI _bpel11wsdl;
    private Map<String, Object> _compileProperties;
    private boolean _dryRun = false;

    public static BpelC newBpelCompiler() {
        return new BpelC();
    }

    private BpelC() {
    }

    protected void finalize() throws Throwable {
        this.invalidate();
        super.finalize();
    }

    private void invalidate() {
        this.setResourceFinder(null);
        this.setCompileListener(null);
        this.setOutputStream(null);
    }

    public void setCompileListener(CompileListener cl) {
        this._compileListener = cl;
    }

    public void setDryRun(boolean dryRun) {
        this._dryRun = dryRun;
    }

    public void setResourceFinder(ResourceFinder finder) {
        this._wsdlFinder = finder;
    }

    public void setProcessWSDL(URI wsdl) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Adding WSDL import: \"" + wsdl.toASCIIString() + "\"."));
        }
        this._bpel11wsdl = wsdl;
    }

    public void setCompileProperties(Map<String, Object> compileProperties) {
        this._compileProperties = compileProperties;
    }

    public void setOutputStream(OutputStream os) {
        if (this._outputStream != null) {
            try {
                this._outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._outputStream = os;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Sett output to stream " + os));
        }
    }

    public void setBaseDirectory(File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 'baseDir' is null");
        }
        if (!baseDir.exists()) {
            throw new IllegalArgumentException("Directory " + baseDir + " does not exist");
        }
        this._suDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(final Process process, String outputPath) throws CompilationException, IOException {
        OProcess oprocess;
        BpelCompiler compiler;
        ResourceFinder wf;
        if (process == null) {
            throw new NullPointerException("Attempt to compile NULL process.");
        }
        this.logCompilationMessage(__cmsgs.infCompilingProcess());
        if (this._wsdlFinder != null) {
            wf = this._wsdlFinder;
        } else {
            File suDir = this._suDir != null ? this._suDir : this._bpelFile.getParentFile();
            wf = new DefaultResourceFinder(this._bpelFile.getAbsoluteFile().getParentFile(), suDir.getAbsoluteFile());
        }
        CompileListener clistener = new CompileListener(){

            public void onCompilationMessage(CompilationMessage compilationMessage) {
                SourceLocation location = compilationMessage.source;
                if (location == null) {
                    compilationMessage.source = process;
                }
                BpelC.this.logCompilationMessage(compilationMessage);
            }
        };
        try {
            switch (process.getBpelVersion()) {
                case BPEL20: {
                    compiler = new BpelCompiler20();
                    compiler.setResourceFinder(wf);
                    if (this._bpel11wsdl == null) break;
                    CompilationMessage cmsg = __cmsgs.warnWsdlUriIgnoredFor20Process();
                    this.logCompilationMessage(cmsg);
                    break;
                }
                case BPEL20_DRAFT: {
                    compiler = new BpelCompiler20Draft();
                    compiler.setResourceFinder(wf);
                    if (this._bpel11wsdl == null) break;
                    CompilationMessage cmsg = __cmsgs.warnWsdlUriIgnoredFor20Process();
                    this.logCompilationMessage(cmsg);
                    break;
                }
                case BPEL11: {
                    compiler = new BpelCompiler11();
                    compiler.setResourceFinder(wf);
                    if (this._bpel11wsdl != null) {
                        compiler.addWsdlImport(new URI(this._bpelFile.getName()), this._bpel11wsdl, null);
                        break;
                    }
                    CompilationMessage cmsg = __cmsgs.errBpel11RequiresWsdl();
                    this.logCompilationMessage(cmsg);
                    this.invalidate();
                    throw new CompilationException(cmsg);
                }
                default: {
                    CompilationMessage cmsg = __cmsgs.errUnrecognizedBpelVersion();
                    this.logCompilationMessage(cmsg);
                    this.invalidate();
                    throw new CompilationException(cmsg);
                }
            }
            compiler.setCompileListener(clistener);
            if (this._compileProperties != null && this._compileProperties.get(PROCESS_CUSTOM_PROPERTIES) != null) {
                compiler.setCustomProperties((Map)this._compileProperties.get(PROCESS_CUSTOM_PROPERTIES));
            }
        }
        catch (CompilationException ce) {
            this.invalidate();
            throw ce;
        }
        catch (Exception ex) {
            CompilationMessage cmsg = __cmsgs.errBpelParseErr();
            this.logCompilationMessage(cmsg);
            this.invalidate();
            throw new CompilationException(cmsg, (Throwable)ex);
        }
        try {
            oprocess = compiler.compile(process, wf);
        }
        catch (CompilationException cex) {
            this.invalidate();
            throw cex;
        }
        if (!this._dryRun) {
            if (outputPath != null) {
                this.setOutputStream(new BufferedOutputStream(new FileOutputStream(outputPath)));
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Writing compilation results to " + outputPath));
                }
            } else if (this._outputStream != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Writing compilation results to " + this._outputStream.getClass().getName()));
                }
            } else {
                throw new IllegalStateException("must setOutputStream() or setOutputDirectory()!");
            }
            try {
                Serializer fileHeader = new Serializer(System.currentTimeMillis());
                fileHeader.writeOProcess(oprocess, this._outputStream);
                Object var9_14 = null;
                this.invalidate();
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.invalidate();
                throw throwable;
            }
        }
    }

    public void compile(File bpelFile) throws CompilationException, IOException {
        Process process;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"compile(URL)");
        }
        if (bpelFile == null) {
            this.invalidate();
            throw new IllegalArgumentException("Null bpelFile");
        }
        this._bpelFile = bpelFile;
        try {
            InputSource isrc = new InputSource(new ByteArrayInputStream(StreamUtils.read((URL)bpelFile.toURL())));
            isrc.setSystemId(bpelFile.getAbsolutePath());
            process = BpelObjectFactory.getInstance().parse(isrc, this._bpelFile.toURI());
        }
        catch (Exception e) {
            CompilationMessage cmsg = __cmsgs.errBpelParseErr().setSource(new SourceLocationImpl(bpelFile.toURI()));
            this.invalidate();
            throw new CompilationException(cmsg, (Throwable)e);
        }
        assert (process != null);
        String bpelPath = bpelFile.getAbsolutePath();
        String cbpPath = bpelPath.substring(0, bpelPath.lastIndexOf(".")) + ".cbp";
        this.compile(process, cbpPath);
        this.invalidate();
    }

    private void logCompilationMessage(CompilationMessage cmsg) {
        if (this._compileListener != null) {
            this._compileListener.onCompilationMessage(cmsg);
        } else {
            switch (cmsg.severity) {
                case 2: {
                    if (!__log.isErrorEnabled()) break;
                    __log.error((Object)cmsg.toErrorString());
                    break;
                }
                case 0: {
                    if (!__log.isInfoEnabled()) break;
                    __log.info((Object)cmsg.toErrorString());
                    break;
                }
                case 1: {
                    if (!__log.isWarnEnabled()) break;
                    __log.warn((Object)cmsg.toErrorString());
                }
            }
        }
    }
}

