/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class LocalEntityResolver
implements EntityResolver {
    private static final Log __log = LogFactory.getLog(LocalEntityResolver.class);
    private final HashMap<String, URL> _mappings = new HashMap();

    LocalEntityResolver() {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URL target;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("resolveEntity(" + publicId + "," + systemId + ")"));
        }
        if ((target = this._mappings.get(systemId)) == null) {
            target = this._mappings.get(publicId);
        }
        if (target == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("resolveEntity(" + publicId + "," + systemId + ") failed (resource not found) "));
            }
            throw new IOException("Resource not found: " + publicId + " : " + systemId);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolveEntity(" + publicId + "," + systemId + ") ==> target"));
        }
        return new InputSource(target.openStream());
    }

    void register(String id, URL location) {
        if (id == null) {
            throw new NullPointerException("id arg must not be null!");
        }
        if (location == null) {
            throw new NullPointerException("location arg must not be null");
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("mapping " + id + " ==> " + location));
        }
        this._mappings.put(id, location);
    }
}

