/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.SourceLocationImpl;
import org.apache.ode.bpel.compiler.WsdlFinderXMLEntityResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.bom.PartnerLinkType;
import org.apache.ode.bpel.compiler.bom.Property;
import org.apache.ode.bpel.compiler.bom.PropertyAlias;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.XMLSchemaType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.ode.utils.xsd.SchemaModelImpl;
import org.apache.ode.utils.xsd.XSUtils;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSDLRegistry {
    private static final Log __log = LogFactory.getLog(WSDLRegistry.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private final HashMap<String, ArrayList<Definition4BPEL>> _definitions = new HashMap();
    private final Map<URI, byte[]> _schemas = new HashMap<URI, byte[]>();
    private final Map<URI, String> _internalSchemas = new HashMap<URI, String>();
    private SchemaModel _model;
    private CompilerContext _ctx;

    WSDLRegistry(CompilerContext cc) {
        this._schemas.put(URI.create("http://fivesight.com/bogus/namespace"), "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://fivesight.com/bogus/namespace\"><xsd:simpleType name=\"__bogusType__\"><xsd:restriction base=\"xsd:normalizedString\"/></xsd:simpleType></xsd:schema>".getBytes());
        try {
            this._schemas.put(URI.create("http://schemas.xmlsoap.org/wsdl/"), StreamUtils.read((URL)this.getClass().getResource("/wsdl.xsd")));
            this._schemas.put(URI.create("http://www.w3.org/2001/xml.xsd"), StreamUtils.read((URL)this.getClass().getResource("/xml.xsd")));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load default schemas.", e);
        }
        this._ctx = cc;
    }

    public Definition4BPEL[] getDefinitions() {
        ArrayList<Definition4BPEL> result = new ArrayList<Definition4BPEL>();
        for (ArrayList<Definition4BPEL> definition4BPELs : this._definitions.values()) {
            for (Definition4BPEL definition4BPEL : definition4BPELs) {
                result.add(definition4BPEL);
            }
        }
        return result.toArray(new Definition4BPEL[result.size()]);
    }

    public SchemaModel getSchemaModel() {
        if (this._model == null) {
            this._model = SchemaModelImpl.newModel(this._schemas);
        }
        assert (this._model != null);
        return this._model;
    }

    public void addDefinition(Definition4BPEL def, ResourceFinder rf, URI defuri) throws CompilationException {
        if (def == null) {
            throw new NullPointerException("def=null");
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addDefinition(" + def.getTargetNamespace() + " from " + def.getDocumentBaseURI() + ")"));
        }
        if (this._definitions.containsKey(def.getTargetNamespace()) && __log.isInfoEnabled()) {
            __log.info((Object)("WSDL at " + defuri + " is a duplicate import, your documents " + "should all be in different namespaces (its's not nice but will still work)."));
        }
        ArrayList<Definition4BPEL> defs = null;
        defs = this._definitions.get(def.getTargetNamespace()) == null ? new ArrayList<Definition4BPEL>() : this._definitions.get(def.getTargetNamespace());
        defs.add(def);
        this._definitions.put(def.getTargetNamespace(), defs);
        this.captureSchemas(def, rf, defuri);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Processing <imports> in " + def.getDocumentBaseURI()));
        }
        for (List imports : def.getImports().values()) {
            HashSet<String> imported = new HashSet<String>();
            for (Import im : imports) {
                Definition4BPEL importDef;
                if (imported.contains(im.getNamespaceURI()) && __log.isInfoEnabled()) {
                    __log.info((Object)("WSDL at " + im.getLocationURI() + " imports several documents in the same " + "namespace (" + im.getNamespaceURI() + "), your documents should all be in different " + "namespaces (its's not nice but will still work)."));
                }
                if ((importDef = (Definition4BPEL)im.getDefinition()) == null) {
                    CompilationException ce = new CompilationException(__cmsgs.errWsdlImportNotFound(im.getNamespaceURI(), im.getLocationURI()).setSource(new SourceLocationImpl(defuri)));
                    if (this._ctx == null) {
                        throw ce;
                    }
                    this._ctx.recoveredFromError(new SourceLocationImpl(defuri), ce);
                    continue;
                }
                imported.add(im.getNamespaceURI());
                this.addDefinition((Definition4BPEL)im.getDefinition(), rf, defuri.resolve(im.getLocationURI()));
            }
        }
    }

    public void addSchemas(Map<URI, byte[]> capture) {
        this._schemas.putAll(capture);
    }

    private void captureSchemas(Definition def, ResourceFinder rf, URI defuri) throws CompilationException {
        Types types;
        assert (def != null);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Processing XSD schemas in " + def.getDocumentBaseURI()));
        }
        if ((types = def.getTypes()) != null) {
            for (ExtensibilityElement ee : def.getTypes().getExtensibilityElements()) {
                if (!(ee instanceof XMLSchemaType)) continue;
                String schema = ((XMLSchemaType)ee).getXMLSchema();
                WsdlFinderXMLEntityResolver resolver = new WsdlFinderXMLEntityResolver(rf, defuri, this._internalSchemas, false);
                try {
                    Map capture = XSUtils.captureSchema((URI)defuri, (String)schema, (XMLEntityResolver)resolver);
                    this._schemas.putAll(capture);
                    try {
                        Document doc = DOMUtils.parse((InputSource)new InputSource(new StringReader(schema)));
                        String schemaTargetNS = doc.getDocumentElement().getAttribute("targetNamespace");
                        if (schemaTargetNS != null && schemaTargetNS.length() > 0) {
                            this._internalSchemas.put(new URI(schemaTargetNS), schema);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't parse schema in " + def.getTargetNamespace(), e);
                    }
                }
                catch (XsdException xsde) {
                    __log.debug((Object)("captureSchemas: capture failed for " + defuri), (Throwable)xsde);
                    LinkedList<void> exceptions = new LinkedList<void>();
                    while (xsde != null) {
                        exceptions.addFirst((void)xsde);
                        xsde = xsde.getPrevious();
                    }
                    for (XsdException xsdException : exceptions) {
                        CompilationException ce = new CompilationException(__cmsgs.errSchemaError(xsdException.getDetailMessage()).setSource(new SourceLocationImpl(defuri)));
                        if (this._ctx != null) {
                            this._ctx.recoveredFromError(new SourceLocationImpl(defuri), ce);
                            continue;
                        }
                        throw ce;
                    }
                }
                this._model = null;
            }
        }
    }

    public Property getProperty(QName name) {
        ArrayList<Definition4BPEL> defs = this._definitions.get(name.getNamespaceURI());
        if (defs == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : defs) {
            if (definition4BPEL == null || definition4BPEL.getProperty(name) == null) continue;
            return definition4BPEL.getProperty(name);
        }
        return null;
    }

    public PropertyAlias getPropertyAlias(QName propertyName, QName messageType) {
        ArrayList<Definition4BPEL> defs = this._definitions.get(propertyName.getNamespaceURI());
        if (defs == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : defs) {
            if (definition4BPEL == null || definition4BPEL.getPropertyAlias(propertyName, messageType) == null) continue;
            return definition4BPEL.getPropertyAlias(propertyName, messageType);
        }
        return null;
    }

    public PartnerLinkType getPartnerLinkType(QName partnerLinkType) {
        ArrayList<Definition4BPEL> defs = this._definitions.get(partnerLinkType.getNamespaceURI());
        if (defs == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : defs) {
            if (definition4BPEL == null || definition4BPEL.getPartnerLinkType(partnerLinkType) == null) continue;
            return definition4BPEL.getPartnerLinkType(partnerLinkType);
        }
        return null;
    }

    public PortType getPortType(QName portType) {
        ArrayList<Definition4BPEL> defs = this._definitions.get(portType.getNamespaceURI());
        if (defs == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : defs) {
            if (definition4BPEL == null || definition4BPEL.getPortType(portType) == null) continue;
            return definition4BPEL.getPortType(portType);
        }
        return null;
    }

    public Message getMessage(QName msgType) {
        ArrayList<Definition4BPEL> defs = this._definitions.get(msgType.getNamespaceURI());
        if (defs == null) {
            return null;
        }
        for (Definition4BPEL definition4BPEL : defs) {
            if (definition4BPEL == null || definition4BPEL.getMessage(msgType) == null) continue;
            return definition4BPEL.getMessage(msgType);
        }
        return null;
    }
}

