/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.List;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.Variable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathFunctionLibrary;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.OdeXPathFunctionLibrary;

public class SaxonContext
extends StandaloneContext {
    private JaxpVariableResolver _varResolver;
    private JaxpFunctionResolver _funcResolver;

    public SaxonContext(Configuration config, JaxpVariableResolver varResolver, JaxpFunctionResolver funcResolver) {
        super(config);
        List libList = ((FunctionLibraryList)this.getFunctionLibrary()).libraryList;
        XPathFunctionLibrary xpathLib = null;
        for (Object lib : libList) {
            FunctionLibrary flib = (FunctionLibrary)lib;
            if (!(flib instanceof XPathFunctionLibrary)) continue;
            xpathLib = (XPathFunctionLibrary)flib;
        }
        if (xpathLib != null) {
            libList.remove(xpathLib);
        }
        OdeXPathFunctionLibrary oxpfl = new OdeXPathFunctionLibrary(funcResolver);
        oxpfl.setXPathFunctionResolver(funcResolver);
        oxpfl.setXPathFunctionResolver(this._funcResolver);
        ((FunctionLibraryList)this.getFunctionLibrary()).addFunctionLibrary((FunctionLibrary)oxpfl);
        this._varResolver = varResolver;
        this._funcResolver = funcResolver;
    }

    public Variable declareVariable(String qname, Object initialValue) throws XPathException {
        String localName;
        String prefix;
        NameChecker checker = this.getConfiguration().getNameChecker();
        try {
            String[] parts = checker.getQNameParts((CharSequence)qname);
            prefix = parts[0];
            localName = parts[1];
        }
        catch (QNameException err) {
            throw new StaticError("Invalid QName for variable: " + qname);
        }
        String uri = "";
        if (!"".equals(prefix)) {
            uri = this.getURIForPrefix(prefix);
        }
        this._varResolver.resolveVariable(new QName(uri, localName, prefix));
        return super.declareVariable(qname, initialValue);
    }

    public VariableReference bindVariable(int fingerprint) throws StaticError {
        String localName = this.getNamePool().getLocalName(fingerprint);
        String prefix = this.getNamePool().getPrefix(fingerprint);
        String ns = this.getNamePool().getURI(fingerprint);
        if ("http://www.apache.org/ode/type/extension".equals(ns)) {
            prefix = "ode";
        }
        if (prefix != null && prefix.length() > 0) {
            prefix = prefix + ":";
        }
        try {
            this.declareVariable(prefix + localName, null);
        }
        catch (XPathException e) {
            throw new StaticError((Exception)((Object)e));
        }
        return super.bindVariable(fingerprint);
    }
}

