/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ActivityGenerator;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.DefaultResourceFinder;
import org.apache.ode.bpel.compiler.ExpressionValidatorFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.WSDLLocatorImpl;
import org.apache.ode.bpel.compiler.WSDLRegistry;
import org.apache.ode.bpel.compiler.WsdlFinderXMLEntityResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompileListener;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.api.ExpressionValidator;
import org.apache.ode.bpel.compiler.api.SourceLocation;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.BpelObject;
import org.apache.ode.bpel.compiler.bom.Catch;
import org.apache.ode.bpel.compiler.bom.CompensationHandler;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.CorrelationSet;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.bom.Expression11;
import org.apache.ode.bpel.compiler.bom.FaultHandler;
import org.apache.ode.bpel.compiler.bom.Import;
import org.apache.ode.bpel.compiler.bom.LinkSource;
import org.apache.ode.bpel.compiler.bom.LinkTarget;
import org.apache.ode.bpel.compiler.bom.OnAlarm;
import org.apache.ode.bpel.compiler.bom.OnEvent;
import org.apache.ode.bpel.compiler.bom.PartnerLink;
import org.apache.ode.bpel.compiler.bom.PartnerLinkType;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.compiler.bom.Property;
import org.apache.ode.bpel.compiler.bom.PropertyAlias;
import org.apache.ode.bpel.compiler.bom.Scope;
import org.apache.ode.bpel.compiler.bom.ScopeActivity;
import org.apache.ode.bpel.compiler.bom.ScopeLikeActivity;
import org.apache.ode.bpel.compiler.bom.TerminationHandler;
import org.apache.ode.bpel.compiler.bom.Variable;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.WSDLFactory4BPEL;
import org.apache.ode.bpel.o.DebugInfo;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OAssign;
import org.apache.ode.bpel.o.OCatch;
import org.apache.ode.bpel.o.OCompensate;
import org.apache.ode.bpel.o.OCompensationHandler;
import org.apache.ode.bpel.o.OConstantExpression;
import org.apache.ode.bpel.o.OConstantVarType;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OEventHandler;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.o.OExtVar;
import org.apache.ode.bpel.o.OFaultHandler;
import org.apache.ode.bpel.o.OFlow;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.ORethrow;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OSequence;
import org.apache.ode.bpel.o.OTerminationHandler;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.ode.utils.xsd.XSUtils;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BpelCompiler
implements CompilerContext {
    protected static final Log __log = LogFactory.getLog(BpelCompiler.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private Process _processDef;
    private Date _generatedDate;
    private HashMap<Class, ActivityGenerator> _actGenerators = new HashMap();
    private boolean _supressJoinFailure = false;
    private boolean _atomicScope = false;
    private StructureStack _structureStack = new StructureStack();
    private Stack<OScope> _recoveryContextStack = new Stack();
    private List<OActivity> _compiledActivities = new ArrayList<OActivity>();
    private OProcess _oprocess;
    private ResourceFinder _resourceFinder;
    private WSDLRegistry _wsdlRegistry;
    private final List<CompilationMessage> _errors = new ArrayList<CompilationMessage>();
    private CompileListener _compileListener;
    private final HashMap<String, ExpressionCompiler> _expLanguageCompilers = new HashMap();
    private final HashMap<String, OExpressionLanguage> _expLanguages = new HashMap();
    private ExpressionValidatorFactory _expressionValidatorFactory = new ExpressionValidatorFactory(System.getProperties());
    private WSDLFactory4BPEL _wsdlFactory;
    private OExpressionLanguage _konstExprLang;
    private Map<QName, Node> _customProcessProperties;
    private URI _processURI;

    BpelCompiler(WSDLFactory4BPEL wSDLFactory4BPEL) {
        this._wsdlFactory = wSDLFactory4BPEL;
        this._wsdlRegistry = new WSDLRegistry(this);
    }

    public void addWsdlImport(URI uRI, URI uRI2, SourceLocation sourceLocation) {
        Definition4BPEL definition4BPEL;
        try {
            WSDLReader wSDLReader = this._wsdlFactory.newWSDLReader();
            WSDLLocatorImpl wSDLLocatorImpl = new WSDLLocatorImpl(this._resourceFinder, this._resourceFinder.resolve(uRI, uRI2));
            definition4BPEL = (Definition4BPEL)wSDLReader.readWSDL((WSDLLocator)wSDLLocatorImpl);
        }
        catch (WSDLException wSDLException) {
            this.recoveredFromError(sourceLocation, new CompilationException(__cmsgs.errWsdlParseError(wSDLException.getFaultCode(), wSDLException.getLocation(), wSDLException.getMessage())));
            throw new CompilationException(__cmsgs.errWsdlImportFailed(uRI2.toASCIIString(), wSDLException.getFaultCode()).setSource(sourceLocation), (Throwable)wSDLException);
        }
        try {
            this._wsdlRegistry.addDefinition(definition4BPEL, this._resourceFinder, this._resourceFinder.resolve(uRI, uRI2));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Added WSDL Definition: " + uRI2));
            }
        }
        catch (CompilationException compilationException) {
            this.recoveredFromError(sourceLocation, compilationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXsdImport(URI uRI, URI uRI2, SourceLocation sourceLocation) {
        URI uRI3 = this._resourceFinder.resolve(uRI, uRI2);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Adding XSD import from " + uRI3 + " location " + uRI2));
        }
        WsdlFinderXMLEntityResolver wsdlFinderXMLEntityResolver = new WsdlFinderXMLEntityResolver(this._resourceFinder, uRI2, new HashMap<URI, byte[]>(), true);
        try {
            byte[] byArray;
            InputStream inputStream = this._resourceFinder.openResource(uRI3);
            try {
                byArray = StreamUtils.read((InputStream)inputStream);
            }
            finally {
                inputStream.close();
            }
            Map map = XSUtils.captureSchema((URI)uRI3, (byte[])byArray, (XMLEntityResolver)wsdlFinderXMLEntityResolver);
            this._wsdlRegistry.addSchemas(map);
        }
        catch (XsdException xsdException) {
            CompilationException compilationException = new CompilationException(__cmsgs.errInvalidImport(uRI2.toString()));
            this.recoveredFromError(sourceLocation, compilationException);
        }
        catch (MalformedURLException malformedURLException) {
            CompilationException compilationException = new CompilationException(__cmsgs.errInvalidImport(uRI2.toString()));
            this.recoveredFromError(sourceLocation, compilationException);
        }
        catch (IOException iOException) {
            CompilationException compilationException = new CompilationException(__cmsgs.errInvalidImport(uRI2.toString()));
            this.recoveredFromError(sourceLocation, compilationException);
        }
    }

    public void setResourceFinder(ResourceFinder resourceFinder) {
        this._resourceFinder = resourceFinder == null ? new DefaultResourceFinder() : resourceFinder;
    }

    public void setCompileListener(CompileListener compileListener) {
        this._compileListener = compileListener;
    }

    public CompileListener getCompileListener() {
        return this._compileListener;
    }

    public void setCustomProperties(Map<QName, Node> map) {
        this._customProcessProperties = map;
    }

    public Process getProcessDef() {
        return this._processDef;
    }

    public PortType resolvePortType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null portTypeName argument!");
        }
        PortType portType = this._wsdlRegistry.getPortType(qName);
        if (portType == null) {
            throw new CompilationException(__cmsgs.errUndeclaredPortType(qName));
        }
        return portType;
    }

    @Override
    public OLink resolveLink(String string) {
        OLink oLink = null;
        Iterator<OActivity> iterator = this._structureStack.iterator();
        while (iterator.hasNext()) {
            OActivity oActivity = iterator.next();
            if (oActivity instanceof OFlow) {
                oLink = ((OFlow)oActivity).getLocalLink(string);
            }
            if (oLink == null) continue;
            return oLink;
        }
        throw new CompilationException(__cmsgs.errUndeclaredLink(string));
    }

    @Override
    public OScope.Variable resolveVariable(String string) {
        Iterator<OScope> iterator = this._structureStack.oscopeIterator();
        while (iterator.hasNext()) {
            OScope.Variable variable = iterator.next().getLocalVariable(string);
            if (variable == null) continue;
            return variable;
        }
        if (this._customProcessProperties == null || this._customProcessProperties.get(QName.valueOf(string)) != null) {
            // empty if block
        }
        throw new CompilationException(__cmsgs.errUndeclaredVariable(string));
    }

    @Override
    public List<OScope.Variable> getAccessibleVariables() {
        ArrayList<OScope.Variable> arrayList = new ArrayList<OScope.Variable>();
        Iterator<OScope> iterator = this._structureStack.oscopeIterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().variables.values());
        }
        return arrayList;
    }

    @Override
    public OScope.Variable resolveMessageVariable(String string) throws CompilationException {
        OScope.Variable variable = this.resolveVariable(string);
        if (!(variable.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(string));
        }
        return variable;
    }

    @Override
    public OScope.Variable resolveMessageVariable(String string, QName qName) throws CompilationException {
        OScope.Variable variable = this.resolveMessageVariable(string);
        if (!((OMessageVarType)variable.type).messageType.equals(qName)) {
            throw new CompilationException(__cmsgs.errVariableTypeMismatch(variable.name, qName, ((OMessageVarType)variable.type).messageType));
        }
        return variable;
    }

    @Override
    public OProcess.OProperty resolveProperty(QName qName) {
        for (OProcess.OProperty oProperty : this._oprocess.properties) {
            if (!oProperty.name.equals(qName)) continue;
            return oProperty;
        }
        throw new CompilationException(__cmsgs.errUndeclaredProperty(qName));
    }

    @Override
    public OProcess.OPropertyAlias resolvePropertyAlias(OScope.Variable variable, QName qName) {
        if (!(variable.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(variable.name));
        }
        OProcess.OProperty oProperty = this.resolveProperty(qName);
        OProcess.OPropertyAlias oPropertyAlias = oProperty.getAlias(variable.type);
        if (oPropertyAlias == null) {
            throw new CompilationException(__cmsgs.errUndeclaredPropertyAlias(variable.type.toString(), qName));
        }
        return oPropertyAlias;
    }

    @Override
    public OScope resolveCompensatableScope(final String string) throws CompilationException {
        if (this._recoveryContextStack.isEmpty()) {
            throw new CompilationException(__cmsgs.errCompensateNAtoContext());
        }
        OScope oScope = this._recoveryContextStack.peek();
        OScope oScope2 = (OScope)CollectionsX.find_if((Collection)oScope.compensatable, (MemberOfFunction)new MemberOfFunction<OScope>(){

            public boolean isMember(OScope oScope) {
                return oScope.name != null && oScope.name.equals(string);
            }
        });
        if (oScope2 == null) {
            throw new CompilationException(__cmsgs.errCompensateOfInvalidScope(string));
        }
        return oScope2;
    }

    @Override
    public String getSourceLocation() {
        return this._processDef.getSource() == null ? null : this._processDef.getSource();
    }

    @Override
    public OScope.CorrelationSet resolveCorrelationSet(String string) {
        Iterator<OScope> iterator = this._structureStack.oscopeIterator();
        while (iterator.hasNext()) {
            OScope.CorrelationSet correlationSet = iterator.next().getCorrelationSet(string);
            if (correlationSet == null) continue;
            return correlationSet;
        }
        throw new CompilationException(__cmsgs.errUndeclaredCorrelationSet(string));
    }

    public OMessageVarType resolveMessageType(QName qName) {
        OMessageVarType oMessageVarType = (OMessageVarType)this._oprocess.messageTypes.get(qName);
        if (oMessageVarType == null) {
            Message message = this._wsdlRegistry.getMessage(qName);
            if (message == null) {
                throw new CompilationException(__cmsgs.errUndeclaredMessage(qName.getLocalPart(), qName.getNamespaceURI()));
            }
            ArrayList arrayList = new ArrayList();
            CollectionsX.transform(arrayList, (Collection)message.getOrderedParts(null), (UnaryFunction)new UnaryFunction<Part, OMessageVarType.Part>(){

                public OMessageVarType.Part apply(Part part) {
                    Object object = part.getElementName() != null ? BpelCompiler.this.resolveElementType(part.getElementName()) : BpelCompiler.this.resolveXsdType(part.getTypeName());
                    OMessageVarType.Part part2 = new OMessageVarType.Part(BpelCompiler.this._oprocess, part.getName(), (OVarType)object);
                    part2.debugInfo = BpelCompiler.this.createDebugInfo(BpelCompiler.this._processDef, "Message Variable Part: " + part.getName());
                    return part2;
                }
            });
            oMessageVarType = new OMessageVarType(this._oprocess, message.getQName(), arrayList);
            oMessageVarType.debugInfo = this.createDebugInfo(this._processDef, "Message Type: " + message.getQName());
            this._oprocess.messageTypes.put(message.getQName(), oMessageVarType);
        }
        return oMessageVarType;
    }

    @Override
    public OXsdTypeVarType resolveXsdType(QName qName) throws CompilationException {
        OXsdTypeVarType oXsdTypeVarType = (OXsdTypeVarType)this._oprocess.xsdTypes.get(qName);
        if (oXsdTypeVarType == null) {
            __log.debug((Object)("Resolving XSD type " + qName));
            SchemaModel schemaModel = null;
            try {
                schemaModel = this._wsdlRegistry.getSchemaModel();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (schemaModel == null || !schemaModel.knowsSchemaType(qName)) {
                throw new CompilationException(__cmsgs.errUndeclaredXsdType(qName));
            }
            oXsdTypeVarType = new OXsdTypeVarType(this._oprocess);
            oXsdTypeVarType.debugInfo = this.createDebugInfo(this._processDef, "XSD Type: " + qName);
            oXsdTypeVarType.xsdType = qName;
            oXsdTypeVarType.simple = this._wsdlRegistry.getSchemaModel().isSimpleType(qName);
            this._oprocess.xsdTypes.put(qName, oXsdTypeVarType);
        }
        return oXsdTypeVarType;
    }

    @Override
    public OMessageVarType.Part resolvePart(OScope.Variable variable, String string) {
        if (!(variable.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(variable.name));
        }
        OMessageVarType oMessageVarType = (OMessageVarType)variable.type;
        OMessageVarType.Part part = (OMessageVarType.Part)oMessageVarType.parts.get(string);
        if (part == null) {
            throw new CompilationException(__cmsgs.errUndeclaredMessagePart(variable.name, ((OMessageVarType)variable.type).messageType, string));
        }
        return part;
    }

    @Override
    public OMessageVarType.Part resolveHeaderPart(OScope.Variable variable, String string) {
        if (!(variable.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(variable.name));
        }
        OMessageVarType oMessageVarType = (OMessageVarType)variable.type;
        return (OMessageVarType.Part)oMessageVarType.parts.get(string);
    }

    public PartnerLinkType resolvePartnerLinkType(QName qName) {
        PartnerLinkType partnerLinkType = this._wsdlRegistry.getPartnerLinkType(qName);
        if (partnerLinkType == null) {
            throw new CompilationException(__cmsgs.errUndeclaredPartnerLinkType(qName));
        }
        return partnerLinkType;
    }

    @Override
    public OPartnerLink resolvePartnerLink(String string) {
        Iterator<OScope> iterator = this._structureStack.oscopeIterator();
        while (iterator.hasNext()) {
            OPartnerLink oPartnerLink = iterator.next().getLocalPartnerLink(string);
            if (oPartnerLink == null) continue;
            return oPartnerLink;
        }
        throw new CompilationException(__cmsgs.errUndeclaredPartnerLink(string));
    }

    @Override
    public Operation resolvePartnerRoleOperation(OPartnerLink oPartnerLink, final String string) {
        if (oPartnerLink.partnerRolePortType == null) {
            throw new CompilationException(__cmsgs.errPartnerLinkDoesNotDeclarePartnerRole(oPartnerLink.getName()));
        }
        Operation operation = (Operation)CollectionsX.find_if((Collection)oPartnerLink.partnerRolePortType.getOperations(), (MemberOfFunction)new MemberOfFunction<Operation>(){

            public boolean isMember(Operation operation) {
                if (!(operation.getInput() != null && operation.getInput().getMessage() != null || operation.getOutput() != null && operation.getOutput().getMessage() != null)) {
                    return false;
                }
                return operation.getName().equals(string);
            }
        });
        if (operation == null) {
            throw new CompilationException(__cmsgs.errUndeclaredOperation(oPartnerLink.partnerRolePortType.getQName(), string));
        }
        return operation;
    }

    @Override
    public Operation resolveMyRoleOperation(OPartnerLink oPartnerLink, final String string) {
        if (oPartnerLink.myRolePortType == null) {
            throw new CompilationException(__cmsgs.errPartnerLinkDoesNotDeclareMyRole(oPartnerLink.getName()));
        }
        Operation operation = (Operation)CollectionsX.find_if((Collection)oPartnerLink.myRolePortType.getOperations(), (MemberOfFunction)new MemberOfFunction<Operation>(){

            public boolean isMember(Operation operation) {
                if (!(operation.getInput() != null && operation.getInput().getMessage() != null || operation.getOutput() != null && operation.getOutput().getMessage() != null)) {
                    return false;
                }
                return operation.getName().equals(string);
            }
        });
        if (operation == null) {
            throw new CompilationException(__cmsgs.errUndeclaredOperation(oPartnerLink.myRolePortType.getQName(), string));
        }
        return operation;
    }

    @Override
    public OExpression constantExpr(boolean bl) {
        OConstantExpression oConstantExpression = new OConstantExpression(this._oprocess, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        oConstantExpression.debugInfo = this.createDebugInfo(this._processDef, "Constant Boolean Expression: " + bl);
        oConstantExpression.expressionLanguage = this._konstExprLang;
        return oConstantExpression;
    }

    @Override
    public OLValueExpression compileLValueExpr(Expression expression) throws CompilationException {
        return this.compileLValueExpr(expression, null, null, new Object[1]);
    }

    @Override
    public OLValueExpression compileLValueExpr(Expression expression, OVarType oVarType, Object object, Object[] objectArray) throws CompilationException {
        return (OLValueExpression)this.compileExpr(expression, false, true, oVarType, object, objectArray);
    }

    @Override
    public OExpression compileJoinCondition(Expression expression) throws CompilationException {
        return this.compileExpr(expression, true, false, null, null, new Object[1]);
    }

    @Override
    public OExpression compileExpr(Expression expression) throws CompilationException {
        return this.compileExpr(expression, null, null, new Object[1]);
    }

    @Override
    public OExpression compileExpr(Expression expression, OVarType oVarType, Object object, Object[] objectArray) throws CompilationException {
        return this.compileExpr(expression, false, false, oVarType, object, objectArray);
    }

    @Override
    public OExpression compileExpr(String string, NSContext nSContext) {
        BpelObject bpelObject = this._structureStack.topSource();
        return this.compileExpr(new Expression11(bpelObject.getElement(), bpelObject.getElement().getOwnerDocument().createTextNode(string)), false, false, null, null, new Object[1]);
    }

    private OExpression compileExpr(Expression expression, boolean bl, boolean bl2, OVarType oVarType, Object object, Object[] objectArray) {
        String string = this.getExpressionLanguage(expression);
        ExpressionCompiler expressionCompiler = this.findExpLangCompiler(string);
        expressionCompiler.setCompilerContext(this);
        ExpressionValidator expressionValidator = this._expressionValidatorFactory.getValidator();
        try {
            OExpression oExpression;
            if (bl) {
                oExpression = expressionCompiler.compileJoinCondition(expression);
            } else {
                oExpression = expressionCompiler.compile(expression);
                objectArray[0] = expressionValidator.validate(expression, oVarType, object);
            }
            oExpression.debugInfo = this.createDebugInfo(expression, expression.toString());
            OExpressionLanguage oExpressionLanguage = this._expLanguages.get(string);
            if (oExpressionLanguage == null) {
                oExpressionLanguage = new OExpressionLanguage(this._oprocess, expressionCompiler.getProperties());
                oExpressionLanguage.debugInfo = this.createDebugInfo(this._processDef, "Expression Language: " + string);
                oExpressionLanguage.expressionLanguageUri = string;
                this._expLanguages.put(string, oExpressionLanguage);
                this._oprocess.expressionLanguages.add(oExpressionLanguage);
            }
            oExpression.expressionLanguage = oExpressionLanguage;
            expressionCompiler.setCompilerContext(null);
            return oExpression;
        }
        catch (CompilationException compilationException) {
            if (compilationException.getCompilationMessage().source == null) {
                compilationException.getCompilationMessage().setSource(expression);
            }
            throw compilationException;
        }
    }

    @Override
    public OProcess getOProcess() throws CompilationException {
        return this._oprocess;
    }

    @Override
    public void recoveredFromError(SourceLocation sourceLocation, CompilationException compilationException) throws CompilationException {
        if (compilationException.getCompilationMessage().source == null) {
            compilationException.getCompilationMessage().source = sourceLocation;
        }
        if (this._compileListener == null) {
            switch (compilationException.getCompilationMessage().severity) {
                case 0: {
                    if (!__log.isInfoEnabled()) break;
                    __log.info((Object)compilationException.toErrorMessage());
                    break;
                }
                case 1: {
                    if (!__log.isWarnEnabled()) break;
                    __log.warn((Object)compilationException.toErrorMessage());
                    break;
                }
                case 2: {
                    if (!__log.isErrorEnabled()) break;
                    __log.error((Object)compilationException.toErrorMessage());
                }
            }
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)compilationException.toErrorMessage(), (Throwable)compilationException);
            }
            this._compileListener.onCompilationMessage(compilationException.getCompilationMessage());
        }
        this._errors.add(compilationException.getCompilationMessage());
    }

    public static long getVersion(String string) {
        try {
            return Integer.parseInt(string.substring(string.lastIndexOf("-") + 1));
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public OProcess compile(final Process process, ResourceFinder resourceFinder, long l) throws CompilationException {
        Object object22;
        OScope oScope;
        if (process == null) {
            throw new NullPointerException("Null process parameter");
        }
        this.setResourceFinder(resourceFinder);
        this._processURI = process.getURI();
        this._processDef = process;
        this._generatedDate = new Date();
        this._structureStack.clear();
        String string = null;
        switch (process.getBpelVersion()) {
            case BPEL11: {
                string = "http://schemas.xmlsoap.org/ws/2003/03/business-process/";
                break;
            }
            case BPEL20_DRAFT: {
                string = "http://schemas.xmlsoap.org/ws/2004/03/business-process/";
                break;
            }
            case BPEL20: {
                string = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
                break;
            }
            default: {
                throw new IllegalStateException("Bad bpel version: " + (Object)((Object)process.getBpelVersion()));
            }
        }
        this._oprocess = new OProcess(string);
        this._oprocess.guid = null;
        this._oprocess.constants = this.makeConstants();
        this._oprocess.debugInfo = this.createDebugInfo(process, "process");
        if (process.getTargetNamespace() == null) {
            this._oprocess.targetNamespace = "--UNSPECIFIED--";
            this.recoveredFromError(process, new CompilationException(__cmsgs.errProcessNamespaceNotSpecified()));
        } else {
            this._oprocess.targetNamespace = this._processDef.getTargetNamespace();
        }
        if (process.getName() == null) {
            this._oprocess.processName = "--UNSPECIFIED--";
            this.recoveredFromError(process, new CompilationException(__cmsgs.errProcessNameNotSpecified()));
        } else {
            this._oprocess.processName = this._processDef.getName();
        }
        this._oprocess.compileDate = this._generatedDate;
        this._konstExprLang = new OExpressionLanguage(this._oprocess, null);
        this._konstExprLang.debugInfo = this.createDebugInfo(this._processDef, "Constant Value Expression Language");
        this._konstExprLang.expressionLanguageUri = "uri:www.fivesight.com/konstExpression";
        this._konstExprLang.properties.put("runtime-class", "org.apache.ode.bpel.runtime.explang.konst.KonstExpressionLanguageRuntimeImpl");
        this._oprocess.expressionLanguages.add(this._konstExprLang);
        OScope oScope2 = this._processDef.getImports().iterator();
        while (oScope2.hasNext()) {
            oScope = oScope2.next();
            try {
                this.compile(this._processURI, (Import)oScope);
            }
            catch (CompilationException compilationException) {
                this.recoveredFromError((SourceLocation)oScope, compilationException);
            }
        }
        this._expressionValidatorFactory.getValidator().bpelImportsLoaded(this._processDef, this);
        switch (this._processDef.getSuppressJoinFailure()) {
            case NO: 
            case NOTSET: {
                this._supressJoinFailure = false;
                break;
            }
            case YES: {
                this._supressJoinFailure = true;
            }
        }
        for (Object object22 : oScope2 = this._wsdlRegistry.getDefinitions()) {
            for (Property property : object22.getProperties()) {
                this.compile(property);
            }
        }
        for (Object object22 : oScope2) {
            for (PropertyAlias propertyAlias : object22.getPropertyAliases()) {
                this.compile(propertyAlias);
            }
        }
        oScope = new OScope(this._oprocess, null);
        oScope.name = "__PROCESS_SCOPE:" + process.getName();
        oScope.debugInfo = this.createDebugInfo(process, null);
        this._oprocess.procesScope = this.compileScope(oScope, process, new Runnable(){

            public void run() {
                if (process.getRootActivity() == null) {
                    throw new CompilationException(__cmsgs.errNoRootActivity());
                }
                if (BpelCompiler.this._customProcessProperties != null) {
                    for (Map.Entry entry : BpelCompiler.this._customProcessProperties.entrySet()) {
                        OScope oScope = BpelCompiler.this._structureStack.topScope();
                        OConstantVarType oConstantVarType = new OConstantVarType(BpelCompiler.this._oprocess, (Node)entry.getValue());
                        OScope.Variable variable = new OScope.Variable(BpelCompiler.this._oprocess, (OVarType)oConstantVarType);
                        variable.name = ((QName)entry.getKey()).getLocalPart();
                        variable.declaringScope = oScope;
                        variable.debugInfo = BpelCompiler.this.createDebugInfo(null, "Process custom property variable");
                        oScope.addLocalVariable(variable);
                        if (!__log.isDebugEnabled()) continue;
                        __log.debug((Object)("Compiled custom property variable " + variable));
                    }
                }
                ((BpelCompiler)BpelCompiler.this)._structureStack.topScope().activity = BpelCompiler.this.compile(process.getRootActivity());
            }
        });
        assert (this._structureStack.size() == 0);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (CompilationMessage compilationMessage : this._errors) {
            if (compilationMessage.severity < 2) continue;
            n = 1;
            stringBuffer.append('\t');
            stringBuffer.append(compilationMessage.toErrorString());
            stringBuffer.append('\n');
        }
        XslTransformHandler.getInstance().clearXSLSheets(this._oprocess.getQName());
        this._expressionValidatorFactory.getValidator().bpelCompilationCompleted(this._processDef);
        if (n != 0) {
            throw new CompilationException(__cmsgs.errCompilationErrors(this._errors.size(), stringBuffer.toString()));
        }
        object22 = "version:" + l + ";" + this._oprocess.digest();
        this._oprocess.guid = GUID.makeGUID((String)object22);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled process digest: " + (String)object22 + "\nguid: " + this._oprocess.guid));
        }
        return this._oprocess;
    }

    private OConstants makeConstants() {
        OConstants oConstants = new OConstants(this._oprocess);
        oConstants.qnConflictingReceive = new QName(this.getBpwsNamespace(), "conflictingReceive");
        oConstants.qnConflictingRequest = new QName(this.getBpwsNamespace(), "conflictingRequest");
        oConstants.qnCorrelationViolation = new QName(this.getBpwsNamespace(), "correlationViolation");
        oConstants.qnForcedTermination = new QName(this.getBpwsNamespace(), "forcedTermination");
        oConstants.qnJoinFailure = new QName(this.getBpwsNamespace(), "joinFailure");
        oConstants.qnMismatchedAssignmentFailure = new QName(this.getBpwsNamespace(), "mismatchedAssignment");
        oConstants.qnMissingReply = new QName(this.getBpwsNamespace(), "missingReply");
        oConstants.qnMissingRequest = new QName(this.getBpwsNamespace(), "missingRequest");
        oConstants.qnSelectionFailure = new QName(this.getBpwsNamespace(), "selectionFailure");
        oConstants.qnUninitializedVariable = new QName(this.getBpwsNamespace(), "uninitializedVariable");
        oConstants.qnXsltInvalidSource = new QName(this.getBpwsNamespace(), "xsltInvalidSource");
        oConstants.qnSubLanguageExecutionFault = new QName(this.getBpwsNamespace(), "subLanguageExecutionFault");
        oConstants.qnUninitializedPartnerRole = new QName(this.getBpwsNamespace(), "uninitializedPartnerRole");
        oConstants.qnForEachCounterError = new QName(this.getBpwsNamespace(), "forEachCounterError");
        oConstants.qnInvalidBranchCondition = new QName(this.getBpwsNamespace(), "invalidBranchCondition");
        oConstants.qnInvalidExpressionValue = new QName(this.getBpwsNamespace(), "invalidExpressionValue");
        oConstants.qnRetiredProcess = new QName(this.getOdeNamespace(), "retiredProcess");
        oConstants.qnTooManyInstances = new QName(this.getOdeNamespace(), "tooManyInstances");
        oConstants.qnUnknownFault = new QName(this.getOdeNamespace(), "unknownFault");
        oConstants.qnTooManyProcesses = new QName(this.getOdeNamespace(), "tooManyProcesses");
        oConstants.qnTooHugeProcesses = new QName(this.getOdeNamespace(), "tooHugeProcesses");
        return oConstants;
    }

    private String getOdeNamespace() {
        return Namespaces.ODE_EXTENSION_NS;
    }

    private void compile(URI uRI, Import import_) {
        block7: {
            try {
                if (import_.getImportType() == null) {
                    throw new CompilationException(__cmsgs.errUnspecifiedImportType().setSource(import_));
                }
                if (import_.getLocation() == null) {
                    throw new CompilationException(__cmsgs.errMissingImportLocation().setSource(import_));
                }
                if ("http://schemas.xmlsoap.org/wsdl/".equals(import_.getImportType())) {
                    this.addWsdlImport(uRI, import_.getLocation(), import_);
                    break block7;
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(import_.getImportType())) {
                    this.addXsdImport(uRI, import_.getLocation(), import_);
                    break block7;
                }
                throw new CompilationException(__cmsgs.errUnknownImportType(import_.getImportType()).setSource(import_));
            }
            catch (CompilationException compilationException) {
                if (compilationException.getCompilationMessage().source == null) {
                    compilationException.getCompilationMessage().setSource(import_);
                }
                throw compilationException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OActivity compile(Activity activity) {
        OActivity oActivity;
        if (activity == null) {
            throw new IllegalArgumentException("null-argument");
        }
        boolean bl = this._supressJoinFailure;
        switch (activity.getSuppressJoinFailure()) {
            case NO: {
                this._supressJoinFailure = false;
                break;
            }
            case YES: {
                this._supressJoinFailure = true;
            }
        }
        try {
            oActivity = activity instanceof ScopeLikeActivity ? this.compileSLC((ScopeLikeActivity)activity, new OScope.Variable[0]) : this.compileActivity(true, activity);
            oActivity.suppressJoinFailure = this._supressJoinFailure;
        }
        finally {
            this._supressJoinFailure = bl;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled activity " + oActivity));
        }
        return oActivity;
    }

    private OCompensate createDefaultCompensateActivity(BpelObject bpelObject, String string) {
        OCompensate oCompensate = new OCompensate(this._oprocess, this.getCurrent());
        oCompensate.name = "__autoGenCompensate:" + this._structureStack.topScope().name;
        oCompensate.debugInfo = this.createDebugInfo(bpelObject, string);
        return oCompensate;
    }

    @Override
    public OScope compileSLC(final ScopeLikeActivity scopeLikeActivity, final OScope.Variable[] variableArray) {
        final OScope oScope = new OScope(this._oprocess, this.getCurrent());
        oScope.implicitScope = true;
        oScope.name = this.createName(scopeLikeActivity, "implicit-scope");
        oScope.debugInfo = this.createDebugInfo(scopeLikeActivity, "Scope-like construct " + scopeLikeActivity);
        this.compileScope(oScope, scopeLikeActivity.getScope(), new Runnable(){

            public void run() {
                BpelCompiler.this.compileLinks(scopeLikeActivity);
                for (OScope.Variable variable : variableArray) {
                    variable.declaringScope = oScope;
                    oScope.addLocalVariable(variable);
                }
                if (scopeLikeActivity instanceof ScopeActivity) {
                    Activity activity = ((ScopeActivity)scopeLikeActivity).getChildActivity();
                    if (activity == null) {
                        throw new CompilationException(__cmsgs.errEmptyScope().setSource(scopeLikeActivity));
                    }
                    oScope.activity = BpelCompiler.this.compile(activity);
                } else {
                    oScope.activity = BpelCompiler.this.compileActivity(false, scopeLikeActivity);
                }
            }
        });
        return oScope;
    }

    private OActivity compileActivity(final boolean bl, final Activity activity) {
        final ActivityGenerator activityGenerator = this.findActivityGen(activity);
        final OActivity oActivity = activityGenerator.newInstance(activity);
        oActivity.name = this.createName(activity, "activity");
        oActivity.debugInfo = this.createDebugInfo(activity, "Activity body for " + activity);
        this._compiledActivities.add(oActivity);
        this.compile(oActivity, activity, new Runnable(){

            public void run() {
                if (bl) {
                    BpelCompiler.this.compileLinks(activity);
                }
                activityGenerator.compile(oActivity, activity);
            }
        });
        return oActivity;
    }

    private void compileLinks(Activity activity) {
        for (LinkSource bpelObject : activity.getLinkSources()) {
            this.compileLinkSource(bpelObject);
        }
        for (LinkTarget linkTarget : activity.getLinkTargets()) {
            this.compileLinkTarget(linkTarget);
        }
        this._structureStack.topActivity().joinCondition = activity.getJoinCondition() == null || activity.getLinkTargets().isEmpty() ? null : this.compileJoinCondition(activity.getJoinCondition());
    }

    private String createName(Activity activity, String string) {
        if (activity.getName() != null) {
            return activity.getName();
        }
        return activity.getType().getLocalPart() + "-" + string + "-line-" + activity.getLineNo();
    }

    private OProcess.OProperty compile(Property property) {
        OProcess.OProperty oProperty = new OProcess.OProperty(this._oprocess);
        oProperty.name = property.getName();
        oProperty.debugInfo = this.createDebugInfo(this._processDef, "Property " + property.getName());
        if (!this._wsdlRegistry.getSchemaModel().isSimpleType(property.getPropertyType())) {
            throw new CompilationException(__cmsgs.errPropertyDeclaredWithComplexType(property.getName(), property.getPropertyType()).setSource(property));
        }
        this._oprocess.properties.add(oProperty);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled property " + oProperty));
        }
        return oProperty;
    }

    private OProcess.OPropertyAlias compile(PropertyAlias propertyAlias) {
        OMessageVarType oMessageVarType;
        OProcess.OProperty oProperty = this.resolveProperty(propertyAlias.getPropertyName());
        OProcess.OPropertyAlias oPropertyAlias = new OProcess.OPropertyAlias(this._oprocess);
        oPropertyAlias.debugInfo = this.createDebugInfo(this._processDef, "PropertyAlias " + propertyAlias.getPropertyName() + " for " + propertyAlias.getMessageType());
        if (propertyAlias.getMessageType() == null) {
            throw new CompilationException(__cmsgs.errAliasUndeclaredMessage(propertyAlias.getPropertyName(), propertyAlias.getQuery().getPath()));
        }
        OMessageVarType oMessageVarType2 = oMessageVarType = this.resolveMessageType(propertyAlias.getMessageType());
        oPropertyAlias.varType = oMessageVarType;
        if (propertyAlias.getPart() != null) {
            oPropertyAlias.part = (OMessageVarType.Part)oMessageVarType.parts.get(propertyAlias.getPart());
            if (oPropertyAlias.part == null) {
                throw new CompilationException(__cmsgs.errUnknownPartInAlias(propertyAlias.getPart(), oMessageVarType.messageType.toString()));
            }
            oMessageVarType2 = oPropertyAlias.part.type;
        }
        if (propertyAlias.getQuery() != null) {
            oPropertyAlias.location = this.compileExpr(propertyAlias.getQuery(), (OVarType)oMessageVarType2, null, new Object[1]);
        }
        oProperty.aliases.add(oPropertyAlias);
        oPropertyAlias.debugInfo = this.createDebugInfo(this._processDef, propertyAlias.getMessageType() + " --> " + propertyAlias.getPropertyName());
        return oPropertyAlias;
    }

    private void compileLinkTarget(LinkTarget linkTarget) {
        OLink oLink = this.resolveLink(linkTarget.getLinkName());
        assert (oLink != null);
        oLink.debugInfo = this.createDebugInfo(linkTarget, linkTarget.toString());
        if (oLink.target != null) {
            throw new CompilationException(__cmsgs.errDuplicateLinkTarget(linkTarget.getLinkName()).setSource(linkTarget));
        }
        oLink.target = this._structureStack.topActivity();
        this._structureStack.topActivity().targetLinks.add(oLink);
    }

    private void compileLinkSource(LinkSource linkSource) {
        OLink oLink = this.resolveLink(linkSource.getLinkName());
        assert (oLink != null);
        oLink.debugInfo = this.createDebugInfo(linkSource, linkSource.toString());
        if (oLink.source != null) {
            throw new CompilationException(__cmsgs.errDuplicateLinkSource(linkSource.getLinkName()).setSource(linkSource));
        }
        oLink.source = this._structureStack.topActivity();
        oLink.transitionCondition = linkSource.getTransitionCondition() == null ? this.constantExpr(true) : this.compileExpr(linkSource.getTransitionCondition());
        this._structureStack.topActivity().sourceLinks.add(oLink);
        this._structureStack.topActivity().outgoingLinks.add(oLink);
    }

    private void compile(PartnerLink partnerLink) {
        OPartnerLink oPartnerLink = new OPartnerLink(this._oprocess);
        oPartnerLink.debugInfo = this.createDebugInfo(partnerLink, partnerLink.toString());
        try {
            QName qName;
            PartnerLinkType.Role role;
            PartnerLinkType partnerLinkType = this.resolvePartnerLinkType(partnerLink.getPartnerLinkType());
            oPartnerLink.partnerLinkType = partnerLinkType.getName();
            oPartnerLink.name = partnerLink.getName();
            oPartnerLink.initializePartnerRole = partnerLink.isInitializePartnerRole();
            if (partnerLink.hasMyRole()) {
                role = partnerLinkType.getRole(partnerLink.getMyRole());
                if (role == null) {
                    throw new CompilationException(__cmsgs.errUndeclaredRole(partnerLink.getMyRole(), partnerLinkType.getName()));
                }
                oPartnerLink.myRoleName = role.getName();
                qName = role.getPortType();
                if (qName == null) {
                    throw new CompilationException(__cmsgs.errMissingMyRolePortType(role.getPortType(), partnerLink.getMyRole(), partnerLinkType.getName()));
                }
                oPartnerLink.myRolePortType = this.resolvePortType(qName);
            }
            if (partnerLink.isInitializePartnerRole() && !partnerLink.hasPartnerRole()) {
                throw new CompilationException(__cmsgs.errPartnerLinkNoPartnerRoleButInitialize(partnerLink.getName()));
            }
            if (partnerLink.hasPartnerRole()) {
                role = partnerLinkType.getRole(partnerLink.getPartnerRole());
                if (role == null) {
                    throw new CompilationException(__cmsgs.errUndeclaredRole(partnerLink.getPartnerRole(), partnerLinkType.getName()));
                }
                oPartnerLink.partnerRoleName = role.getName();
                qName = role.getPortType();
                if (qName == null) {
                    throw new CompilationException(__cmsgs.errMissingPartnerRolePortType(role.getPortType(), partnerLink.getPartnerRole(), partnerLinkType.getName()));
                }
                oPartnerLink.partnerRolePortType = this.resolvePortType(qName);
            }
            oPartnerLink.declaringScope = this._structureStack.topScope();
            if (oPartnerLink.declaringScope.partnerLinks.containsKey(oPartnerLink.name)) {
                throw new CompilationException(__cmsgs.errDuplicatePartnerLinkDecl(oPartnerLink.name));
            }
            oPartnerLink.declaringScope.partnerLinks.put(oPartnerLink.name, oPartnerLink);
            this._oprocess.allPartnerLinks.add(oPartnerLink);
        }
        catch (CompilationException compilationException) {
            compilationException.getCompilationMessage().setSource(partnerLink);
            throw compilationException;
        }
    }

    private void compile(CorrelationSet correlationSet) {
        OScope oScope = this._structureStack.topScope();
        OScope.CorrelationSet correlationSet2 = new OScope.CorrelationSet(this._oprocess);
        correlationSet2.name = correlationSet.getName();
        correlationSet2.declaringScope = oScope;
        correlationSet2.debugInfo = this.createDebugInfo(correlationSet, correlationSet.toString());
        QName[] qNameArray = correlationSet.getProperties();
        for (int i = 0; i < qNameArray.length; ++i) {
            correlationSet2.properties.add(this.resolveProperty(qNameArray[i]));
        }
        oScope.addCorrelationSet(correlationSet2);
    }

    @Override
    public OActivity getCurrent() {
        return this._structureStack.topActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(OActivity oActivity, BpelObject bpelObject, Runnable runnable) {
        OScope oScope;
        OActivity oActivity2;
        block9: {
            OActivity oActivity3;
            DefaultActivityGenerator.defaultExtensibilityElements(oActivity, bpelObject);
            this._structureStack.push(oActivity, bpelObject);
            try {
                runnable.run();
                Object var5_4 = null;
                oActivity2 = this._structureStack.pop();
                oActivity3 = this._structureStack.topActivity();
                oScope = this._structureStack.topScope();
                if (oActivity3 == null) break block9;
                oActivity3.nested.add(oActivity2);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                OActivity oActivity4 = this._structureStack.pop();
                OActivity oActivity5 = this._structureStack.topActivity();
                OScope oScope2 = this._structureStack.topScope();
                if (oActivity5 != null) {
                    oActivity5.nested.add(oActivity4);
                    oActivity5.incomingLinks.addAll(oActivity4.incomingLinks);
                    if (oActivity5 instanceof OFlow) {
                        oActivity5.incomingLinks.removeAll(((OFlow)oActivity5).localLinks);
                    }
                    oActivity5.outgoingLinks.addAll(oActivity4.outgoingLinks);
                    if (oActivity5 instanceof OFlow) {
                        oActivity5.outgoingLinks.removeAll(((OFlow)oActivity5).localLinks);
                    }
                    oActivity5.variableRd.addAll(oActivity4.variableRd);
                    oActivity5.variableWr.addAll(oActivity4.variableWr);
                }
                if (oScope2 != null && oActivity4 instanceof OScope) {
                    oScope2.compensatable.add((OScope)oActivity4);
                }
                throw throwable;
            }
            oActivity3.incomingLinks.addAll(oActivity2.incomingLinks);
            if (oActivity3 instanceof OFlow) {
                oActivity3.incomingLinks.removeAll(((OFlow)oActivity3).localLinks);
            }
            oActivity3.outgoingLinks.addAll(oActivity2.outgoingLinks);
            if (oActivity3 instanceof OFlow) {
                oActivity3.outgoingLinks.removeAll(((OFlow)oActivity3).localLinks);
            }
            oActivity3.variableRd.addAll(oActivity2.variableRd);
            oActivity3.variableWr.addAll(oActivity2.variableWr);
        }
        if (oScope != null && oActivity2 instanceof OScope) {
            oScope.compensatable.add((OScope)oActivity2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OScope compileScope(final OScope oScope, final Scope scope, final Runnable runnable) {
        if (oScope.name == null) {
            throw new IllegalArgumentException("Unnamed scope:" + scope);
        }
        oScope.debugInfo = this.createDebugInfo(scope, scope.toString());
        boolean bl = this._atomicScope;
        if (scope.getAtomicScope() != null) {
            boolean bl2 = scope.getAtomicScope();
            if (this._atomicScope) {
                throw new CompilationException(__cmsgs.errAtomicScopeNesting(bl2));
            }
            oScope.atomicScope = this._atomicScope = bl2;
        }
        try {
            this.compile((OActivity)oScope, scope, new Runnable(){

                public void run() {
                    for (Variable bpelObject : scope.getVariables()) {
                        try {
                            BpelCompiler.this.compile(bpelObject);
                        }
                        catch (CompilationException compilationException) {
                            BpelCompiler.this.recoveredFromError(bpelObject, compilationException);
                        }
                    }
                    for (CorrelationSet correlationSet : scope.getCorrelationSetDecls()) {
                        try {
                            BpelCompiler.this.compile(correlationSet);
                        }
                        catch (CompilationException compilationException) {
                            BpelCompiler.this.recoveredFromError(correlationSet, compilationException);
                        }
                    }
                    for (PartnerLink partnerLink : scope.getPartnerLinks()) {
                        try {
                            BpelCompiler.this.compile(partnerLink);
                        }
                        catch (CompilationException compilationException) {
                            BpelCompiler.this.recoveredFromError(partnerLink, compilationException);
                        }
                    }
                    if (!scope.getEvents().isEmpty() || !scope.getAlarms().isEmpty()) {
                        oScope.eventHandler = new OEventHandler(BpelCompiler.this._oprocess);
                        oScope.eventHandler.debugInfo = BpelCompiler.this.createDebugInfo(scope, "Event Handler for " + scope);
                    }
                    for (OnEvent onEvent : scope.getEvents()) {
                        try {
                            BpelCompiler.this.compile(onEvent);
                        }
                        catch (CompilationException compilationException) {
                            BpelCompiler.this.recoveredFromError(scope, compilationException);
                        }
                    }
                    for (OnAlarm onAlarm : scope.getAlarms()) {
                        try {
                            BpelCompiler.this.compile(onAlarm);
                        }
                        catch (CompilationException compilationException) {
                            BpelCompiler.this.recoveredFromError(scope, compilationException);
                        }
                    }
                    if (runnable != null) {
                        try {
                            runnable.run();
                        }
                        catch (CompilationException compilationException) {
                            BpelCompiler.this.recoveredFromError(scope, compilationException);
                        }
                    }
                    try {
                        BpelCompiler.this.compile(scope.getCompensationHandler());
                    }
                    catch (CompilationException compilationException) {
                        BpelCompiler.this.recoveredFromError(scope.getCompensationHandler(), compilationException);
                    }
                    try {
                        BpelCompiler.this.compile(scope.getTerminationHandler());
                    }
                    catch (CompilationException compilationException) {
                        BpelCompiler.this.recoveredFromError(scope.getTerminationHandler(), compilationException);
                    }
                    try {
                        BpelCompiler.this.compile(scope.getFaultHandler());
                    }
                    catch (CompilationException compilationException) {
                        BpelCompiler.this.recoveredFromError(scope.getFaultHandler(), compilationException);
                    }
                }
            });
            Object var7_6 = null;
            this._atomicScope = bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._atomicScope = bl;
            throw throwable;
        }
        return oScope;
    }

    private void compile(OnAlarm onAlarm) {
        OScope oScope = this._structureStack.topScope();
        assert (oScope.eventHandler != null);
        OEventHandler.OAlarm oAlarm = new OEventHandler.OAlarm(this._oprocess);
        oAlarm.debugInfo = this.createDebugInfo(onAlarm, "OnAlarm Event Handler: " + onAlarm);
        if (onAlarm.getFor() != null && onAlarm.getUntil() == null) {
            oAlarm.forExpr = this.compileExpr(onAlarm.getFor());
        } else if (onAlarm.getFor() == null && onAlarm.getUntil() != null) {
            oAlarm.untilExpr = this.compileExpr(onAlarm.getUntil());
        } else {
            if (onAlarm.getFor() != null && onAlarm.getUntil() != null) {
                throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onAlarm));
            }
            if (onAlarm.getRepeatEvery() == null) {
                throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onAlarm));
            }
        }
        if (onAlarm.getRepeatEvery() != null) {
            oAlarm.repeatExpr = this.compileExpr(onAlarm.getRepeatEvery());
        }
        if (onAlarm.getActivity() == null) {
            throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onAlarm));
        }
        oAlarm.activity = this.compile(onAlarm.getActivity());
        for (OLink oLink : oAlarm.incomingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(oLink.name).setSource(onAlarm));
            }
            catch (CompilationException compilationException) {
                this.recoveredFromError(onAlarm, compilationException);
            }
        }
        for (OLink oLink : oAlarm.outgoingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(oLink.name).setSource(onAlarm));
            }
            catch (CompilationException compilationException) {
                this.recoveredFromError(onAlarm, compilationException);
            }
        }
        oScope.eventHandler.onAlarms.add(oAlarm);
    }

    private void compile(final OnEvent onEvent) {
        OScope oScope = this._structureStack.topScope();
        assert (oScope.eventHandler != null);
        final OEventHandler.OEvent oEvent = new OEventHandler.OEvent(this._oprocess, (OActivity)oScope);
        oEvent.name = "__eventHandler:";
        oEvent.debugInfo = this.createDebugInfo(onEvent, null);
        this.compile((OActivity)oEvent, onEvent, new Runnable(){

            public void run() {
                Object object;
                switch (BpelCompiler.this._processDef.getBpelVersion()) {
                    case BPEL11: {
                        oEvent.variable = BpelCompiler.this.resolveMessageVariable(onEvent.getVariable());
                        break;
                    }
                    case BPEL20_DRAFT: 
                    case BPEL20: {
                        if (onEvent.getMessageType() == null && onEvent.getElementType() == null) {
                            throw new CompilationException(__cmsgs.errVariableDeclMissingType(onEvent.getVariable()).setSource(onEvent));
                        }
                        if (onEvent.getMessageType() != null && onEvent.getElementType() != null) {
                            throw new CompilationException(__cmsgs.errVariableDeclInvalid(onEvent.getVariable()).setSource(onEvent));
                        }
                        if (onEvent.getMessageType() != null) {
                            object = BpelCompiler.this.resolveMessageType(onEvent.getMessageType());
                        } else if (onEvent.getElement() != null) {
                            object = BpelCompiler.this.resolveElementType(onEvent.getElementType());
                        } else {
                            throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(onEvent.getVariable()));
                        }
                        oEvent.variable = new OScope.Variable(BpelCompiler.this._oprocess, (OVarType)object);
                        oEvent.variable.name = onEvent.getVariable();
                        oEvent.variable.declaringScope = BpelCompiler.this._structureStack.topScope();
                        oEvent.addLocalVariable(oEvent.variable);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected BPEL VERSION constatnt: " + (Object)((Object)BpelCompiler.this._processDef.getBpelVersion())));
                    }
                }
                oEvent.partnerLink = BpelCompiler.this.resolvePartnerLink(onEvent.getPartnerLink());
                oEvent.operation = BpelCompiler.this.resolveMyRoleOperation(oEvent.partnerLink, onEvent.getOperation());
                oEvent.messageExchangeId = onEvent.getMessageExchangeId();
                oEvent.route = onEvent.getRoute();
                if (onEvent.getPortType() != null && !onEvent.getPortType().equals(oEvent.partnerLink.myRolePortType.getQName())) {
                    throw new CompilationException(__cmsgs.errPortTypeMismatch(onEvent.getPortType(), oEvent.partnerLink.myRolePortType.getQName()));
                }
                object = new HashSet();
                for (Correlation correlation : onEvent.getCorrelations()) {
                    if (object.contains(correlation.getCorrelationSet())) {
                        throw new CompilationException(__cmsgs.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
                    }
                    OScope.CorrelationSet correlationSet = BpelCompiler.this.resolveCorrelationSet(correlation.getCorrelationSet());
                    switch (correlation.getInitiate()) {
                        case UNSET: 
                        case NO: {
                            oEvent.matchCorrelations.add(correlationSet);
                            oEvent.partnerLink.addCorrelationSetForOperation(oEvent.operation, correlationSet, false);
                            break;
                        }
                        case YES: {
                            oEvent.initCorrelations.add(correlationSet);
                            break;
                        }
                        case JOIN: {
                            correlationSet.hasJoinUseCases = true;
                            oEvent.joinCorrelations.add(correlationSet);
                            oEvent.partnerLink.addCorrelationSetForOperation(oEvent.operation, correlationSet, true);
                        }
                    }
                    for (OProcess.OProperty oProperty : correlationSet.properties) {
                        BpelCompiler.this.resolvePropertyAlias(oEvent.variable, oProperty.name);
                    }
                    object.add(correlation.getCorrelationSet());
                }
                if (onEvent.getActivity() == null) {
                    throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onEvent));
                }
                oEvent.activity = BpelCompiler.this.compile(onEvent.getActivity());
            }
        });
        for (OLink oLink : oEvent.incomingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(oLink.name));
            }
            catch (CompilationException compilationException) {
                this.recoveredFromError(onEvent, compilationException);
            }
        }
        for (OLink oLink : oEvent.outgoingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(oLink.name));
            }
            catch (CompilationException compilationException) {
                this.recoveredFromError(onEvent, compilationException);
            }
        }
        oScope.eventHandler.onMessages.add(oEvent);
    }

    private DebugInfo createDebugInfo(BpelObject bpelObject, String string) {
        int n = bpelObject == null ? -1 : bpelObject.getLineNo();
        String string2 = string == null && bpelObject != null ? bpelObject.toString() : null;
        Map<QName, Object> map = bpelObject == null ? null : bpelObject.getExtensibilityElements();
        DebugInfo debugInfo = new DebugInfo(this._processDef.getSource(), n, map);
        debugInfo.description = string2;
        return debugInfo;
    }

    private void compile(Variable variable) {
        OElementVarType oElementVarType;
        OScope oScope = this._structureStack.topScope();
        if (variable.getKind() == null) {
            throw new CompilationException(__cmsgs.errVariableDeclMissingType(variable.getName()).setSource(variable));
        }
        if (oScope.getLocalVariable(variable.getName()) != null) {
            throw new CompilationException(__cmsgs.errDuplicateVariableDecl(variable.getName()).setSource(variable));
        }
        if (variable.getTypeName() == null) {
            throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(variable.getName()));
        }
        switch (variable.getKind()) {
            case ELEMENT: {
                oElementVarType = this.resolveElementType(variable.getTypeName());
                break;
            }
            case MESSAGE: {
                oElementVarType = this.resolveMessageType(variable.getTypeName());
                break;
            }
            case SCHEMA: {
                oElementVarType = this.resolveXsdType(variable.getTypeName());
                break;
            }
            default: {
                throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(variable.getName()));
            }
        }
        OScope.Variable variable2 = new OScope.Variable(this._oprocess, (OVarType)oElementVarType);
        variable2.name = variable.getName();
        variable2.declaringScope = oScope;
        variable2.debugInfo = this.createDebugInfo(variable, null);
        variable2.extVar = this.compileExtVar(variable);
        oScope.addLocalVariable(variable2);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled variable " + variable2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(TerminationHandler terminationHandler) {
        OScope oScope = this._structureStack.topScope();
        oScope.terminationHandler = new OTerminationHandler(this._oprocess, (OActivity)oScope);
        oScope.terminationHandler.name = "__terminationHandler:" + oScope.name;
        oScope.terminationHandler.debugInfo = this.createDebugInfo(terminationHandler, null);
        if (terminationHandler == null) {
            oScope.terminationHandler.activity = this.createDefaultCompensateActivity(null, "Auto-generated 'compensate all' pseudo-activity for default termination handler on " + oScope.toString());
        } else {
            this._recoveryContextStack.push(oScope);
            try {
                oScope.terminationHandler.activity = this.compile(terminationHandler.getActivity());
                Object var4_3 = null;
                this._recoveryContextStack.pop();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this._recoveryContextStack.pop();
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(CompensationHandler compensationHandler) {
        OScope oScope = this._structureStack.topScope();
        oScope.compensationHandler = new OCompensationHandler(this._oprocess, (OActivity)oScope);
        oScope.compensationHandler.name = "__compenationHandler_" + oScope.name;
        oScope.compensationHandler.debugInfo = this.createDebugInfo(compensationHandler, null);
        if (compensationHandler == null) {
            oScope.compensationHandler.activity = this.createDefaultCompensateActivity(compensationHandler, "Auto-generated 'compensate all' pseudo-activity for default compensation handler on  " + oScope.toString());
        } else {
            this._recoveryContextStack.push(oScope);
            try {
                oScope.compensationHandler.activity = this.compile(compensationHandler.getActivity());
                Object var4_3 = null;
                this._recoveryContextStack.pop();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this._recoveryContextStack.pop();
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(FaultHandler faultHandler) {
        OScope oScope = this._structureStack.topScope();
        oScope.faultHandler = new OFaultHandler(this._oprocess);
        if (faultHandler == null) {
            OCatch oCatch = new OCatch(this._oprocess, (OActivity)oScope);
            oCatch.name = "__defaultFaultHandler:" + oScope.name;
            oCatch.faultName = null;
            oCatch.faultVariable = null;
            OSequence oSequence = new OSequence(this._oprocess, (OActivity)oCatch);
            oSequence.name = "__defaultFaultHandler_sequence:" + oScope.name;
            oSequence.debugInfo = this.createDebugInfo(faultHandler, "Auto-generated sequence activity.");
            ORethrow oRethrow = new ORethrow(this._oprocess, (OActivity)oSequence);
            oRethrow.name = "__defaultFaultHandler_rethrow:" + oScope.name;
            oRethrow.debugInfo = this.createDebugInfo(faultHandler, "Auto-generated re-throw activity.");
            oSequence.sequence.add(this.createDefaultCompensateActivity(faultHandler, "Default compensation handler for " + oScope));
            oSequence.sequence.add(oRethrow);
            oCatch.activity = oSequence;
            oScope.faultHandler.catchBlocks.add(oCatch);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Compiled default catch block " + oCatch + " for " + oScope));
            }
        } else {
            this._recoveryContextStack.push(oScope);
            try {
                int n = 0;
                for (final Catch catch_ : faultHandler.getCatches()) {
                    final OCatch oCatch = new OCatch(this._oprocess, (OActivity)oScope);
                    oCatch.debugInfo = this.createDebugInfo(catch_, catch_.toString());
                    oCatch.name = "__catch#" + n + ":" + this._structureStack.topScope().name;
                    oCatch.faultName = catch_.getFaultName();
                    this.compile((OActivity)oCatch, catch_, new Runnable(){

                        public void run() {
                            if (catch_.getFaultVariable() != null) {
                                OScope.Variable variable;
                                switch (BpelCompiler.this._processDef.getBpelVersion()) {
                                    case BPEL11: {
                                        variable = BpelCompiler.this.resolveVariable(catch_.getFaultVariable());
                                        if (variable.type instanceof OMessageVarType) break;
                                        throw new CompilationException(__cmsgs.errMessageVariableRequired(catch_.getFaultVariable()).setSource(catch_));
                                    }
                                    case BPEL20_DRAFT: 
                                    case BPEL20: {
                                        OMessageVarType oMessageVarType;
                                        if (catch_.getFaultVariableMessageType() == null && catch_.getFaultVariableElementType() == null) {
                                            throw new CompilationException(__cmsgs.errVariableDeclMissingType(catch_.getFaultVariable()).setSource(catch_));
                                        }
                                        if (catch_.getFaultVariableMessageType() != null && catch_.getFaultVariableElementType() != null) {
                                            throw new CompilationException(__cmsgs.errVariableDeclMissingType(catch_.getFaultVariable()).setSource(catch_));
                                        }
                                        if (catch_.getFaultVariableMessageType() != null) {
                                            oMessageVarType = BpelCompiler.this.resolveMessageType(catch_.getFaultVariableMessageType());
                                        } else if (catch_.getFaultVariableElementType() != null) {
                                            oMessageVarType = BpelCompiler.this.resolveElementType(catch_.getFaultVariableElementType());
                                        } else {
                                            throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(catch_.getFaultVariable()));
                                        }
                                        variable = new OScope.Variable(BpelCompiler.this._oprocess, (OVarType)oMessageVarType);
                                        variable.name = catch_.getFaultVariable();
                                        variable.declaringScope = BpelCompiler.this._structureStack.topScope();
                                        oCatch.addLocalVariable(variable);
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError((Object)("Unexpected BPEL VERSION constatnt: " + (Object)((Object)BpelCompiler.this._processDef.getBpelVersion())));
                                    }
                                }
                                oCatch.faultVariable = variable;
                            }
                            if (catch_.getActivity() == null) {
                                throw new CompilationException(__cmsgs.errEmptyCatch().setSource(catch_));
                            }
                            ((BpelCompiler)BpelCompiler.this)._structureStack.topScope().activity = BpelCompiler.this.compile(catch_.getActivity());
                        }
                    });
                    oScope.faultHandler.catchBlocks.add(oCatch);
                    ++n;
                }
                Object var8_10 = null;
                this._recoveryContextStack.pop();
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this._recoveryContextStack.pop();
                throw throwable;
            }
            {
            }
        }
    }

    @Override
    public OXslSheet compileXslt(String string) throws CompilationException {
        URI uRI;
        try {
            uRI = new URI(FileUtils.encodePath((String)string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CompilationException(__cmsgs.errInvalidDocXsltUri(string));
        }
        String string2 = this.loadXsltSheet(this._processURI.resolve(uRI));
        if (string2 == null) {
            throw new CompilationException(__cmsgs.errCantFindXslt(string));
        }
        OXslSheet oXslSheet = new OXslSheet(this._oprocess);
        oXslSheet.uri = uRI;
        oXslSheet.sheetBody = string2;
        this._oprocess.xslSheets.put(oXslSheet.uri, oXslSheet);
        return oXslSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadXsltSheet(URI uRI) {
        String string;
        InputStream inputStream;
        try {
            inputStream = this._resourceFinder.openResource(uRI);
        }
        catch (Exception exception) {
            return null;
        }
        if (inputStream == null) {
            return null;
        }
        try {
            try {
                Document document = DOMUtils.parse((InputStream)inputStream);
                string = DOMUtils.domToString((Node)document);
                Object var6_8 = null;
            }
            catch (Exception exception) {
                __log.debug((Object)"IO error", (Throwable)exception);
                String string2 = null;
                Object var6_9 = null;
                try {
                    inputStream.close();
                    return string2;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            inputStream.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return string;
        }
        inputStream.close();
        return string;
    }

    @Override
    public boolean isPartnerLinkAssigned(String string) {
        for (OActivity oActivity : this._compiledActivities) {
            if (!(oActivity instanceof OAssign)) continue;
            OAssign oAssign = (OAssign)oActivity;
            for (OAssign.Copy copy : oAssign.copy) {
                if (!(copy.to instanceof OAssign.PartnerLinkRef) || !((OAssign.PartnerLinkRef)copy.to).partnerLink.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Definition[] getWsdlDefinitions() {
        Definition[] definitionArray = new Definition[this._wsdlRegistry.getDefinitions().length];
        for (int i = 0; i < this._wsdlRegistry.getDefinitions().length; ++i) {
            Definition4BPEL definition4BPEL = this._wsdlRegistry.getDefinitions()[i];
            definitionArray[i] = definition4BPEL.getDefinition();
        }
        return definitionArray;
    }

    private OElementVarType resolveElementType(QName qName) {
        OElementVarType oElementVarType = (OElementVarType)this._oprocess.elementTypes.get(qName);
        if (oElementVarType == null) {
            oElementVarType = new OElementVarType(this._oprocess, qName);
            this._oprocess.elementTypes.put(qName, oElementVarType);
        }
        return oElementVarType;
    }

    private ActivityGenerator findActivityGen(Activity activity) {
        Class<?> clazz = activity.getClass();
        for (Map.Entry<Class, ActivityGenerator> entry : this._actGenerators.entrySet()) {
            Class clazz2 = entry.getKey();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            ActivityGenerator activityGenerator = entry.getValue();
            activityGenerator.setContext(this);
            return activityGenerator;
        }
        throw new CompilationException(__cmsgs.errUnknownActivity(clazz.getName()).setSource(activity));
    }

    protected void registerActivityCompiler(Class clazz, ActivityGenerator activityGenerator) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Adding compiler for nodes class \"" + clazz.getName() + " = " + activityGenerator));
        }
        this._actGenerators.put(clazz, activityGenerator);
    }

    private ExpressionCompiler findExpLangCompiler(String string) {
        ExpressionCompiler expressionCompiler = this._expLanguageCompilers.get(string);
        if (expressionCompiler == null) {
            throw new CompilationException(__cmsgs.errUnknownExpressionLanguage(string));
        }
        return expressionCompiler;
    }

    private String getExpressionLanguage(Expression expression) {
        String string = expression.getExpressionLanguage();
        if (string == null) {
            string = this._processDef.getExpressionLanguage();
        }
        if (string == null) {
            string = this.getDefaultExpressionLanguage();
        }
        return string;
    }

    protected abstract String getDefaultExpressionLanguage();

    protected abstract String getBpwsNamespace();

    protected void registerExpressionLanguage(String string, ExpressionCompiler expressionCompiler) {
        this._expLanguageCompilers.put(string, expressionCompiler);
    }

    protected void registerExpressionLanguage(String string, String string2) throws Exception {
        Class<?> clazz = Class.forName(string2);
        this.registerExpressionLanguage(string, (ExpressionCompiler)clazz.newInstance());
    }

    @Override
    public List<OActivity> getActivityStack() {
        ArrayList<OActivity> arrayList = new ArrayList<OActivity>(this._structureStack._stack);
        Collections.reverse(arrayList);
        return arrayList;
    }

    @Override
    public Map<URI, Source> getSchemaSources() {
        return this._wsdlRegistry.getSchemaSources();
    }

    @Override
    public URI getBaseResourceURI() {
        return this._resourceFinder.getBaseResourceURI();
    }

    private OExtVar compileExtVar(Variable variable) {
        if (!variable.isExternal()) {
            return null;
        }
        OExtVar oExtVar = new OExtVar(this._oprocess);
        oExtVar.externalVariableId = variable.getExternalId();
        oExtVar.debugInfo = this.createDebugInfo(variable, null);
        if (variable.getExternalId() == null) {
            throw new CompilationException(__cmsgs.errMustSpecifyExternalVariableId(variable.getName()));
        }
        if (variable.getRelated() == null) {
            throw new CompilationException(__cmsgs.errMustSpecifyRelatedVariable(variable.getName()));
        }
        oExtVar.related = this.resolveVariable(variable.getRelated());
        return oExtVar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StructureStack {
        private Stack<OActivity> _stack = new Stack();
        private Map<OActivity, BpelObject> _srcMap = new HashMap<OActivity, BpelObject>();

        private StructureStack() {
        }

        public void push(OActivity oActivity, BpelObject bpelObject) {
            this._stack.push(oActivity);
            this._srcMap.put(oActivity, bpelObject);
        }

        public BpelObject topSource() {
            return this._srcMap.get(this.topActivity());
        }

        public OScope topScope() {
            List<OScope> list = this.scopeStack();
            return list.isEmpty() ? null : list.get(list.size() - 1);
        }

        public OScope rootScope() {
            for (OActivity oActivity : this._stack) {
                if (!(oActivity instanceof OScope)) continue;
                return (OScope)oActivity;
            }
            return null;
        }

        public OActivity pop() {
            return this._stack.pop();
        }

        public void clear() {
            this._stack.clear();
        }

        public int size() {
            return this._stack.size();
        }

        public Iterator<OScope> oscopeIterator() {
            List<OScope> list = this.scopeStack();
            Collections.reverse(list);
            return list.iterator();
        }

        private List<OScope> scopeStack() {
            ArrayList<OScope> arrayList = new ArrayList<OScope>();
            CollectionsX.filter(arrayList, this._stack.iterator(), OScope.class);
            return arrayList;
        }

        public OActivity topActivity() {
            return this._stack.isEmpty() ? null : this._stack.peek();
        }

        public Iterator<OActivity> iterator() {
            ArrayList<OActivity> arrayList = new ArrayList<OActivity>(this._stack);
            Collections.reverse(arrayList);
            return arrayList.iterator();
        }
    }
}

