/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;

public class DefaultResourceFinder
implements ResourceFinder {
    private static final Log __log = LogFactory.getLog(DefaultResourceFinder.class);
    private File _relativeDir;
    private File _absoluteDir;

    public DefaultResourceFinder() {
        this._relativeDir = this._absoluteDir = new File("");
    }

    public DefaultResourceFinder(File file, File file2) {
        this.checkDir("relativeDir", file);
        this.checkDir("absoluteDir", file2);
        this._relativeDir = file;
        this._absoluteDir = file2;
    }

    private void checkDir(String string, File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument '" + string + "' is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + file);
        }
    }

    public InputStream openResource(URI uRI) throws MalformedURLException, IOException {
        InputStream inputStream = this.openFileResource(uRI = this.relativize(uRI));
        if (inputStream != null) {
            return inputStream;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("trying classpath resource for " + uRI));
        }
        if ((inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(uRI.getPath())) != null) {
            return inputStream;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("classpath resource not found " + uRI));
        }
        return null;
    }

    private InputStream openFileResource(URI uRI) throws MalformedURLException, IOException {
        URI uRI2 = this._absoluteDir.toURI();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("openResource: uri=" + uRI + " relativeDir=" + this._relativeDir + " absoluteDir=" + this._absoluteDir));
        }
        if (uRI.isAbsolute() && uRI.getScheme().equals("file")) {
            try {
                return uRI.toURL().openStream();
            }
            catch (Exception exception) {
                __log.debug((Object)("openResource: unable to open file URL " + uRI + "; " + exception.toString()));
                return null;
            }
        }
        URI uRI3 = this._relativeDir.toURI().relativize(uRI);
        if (uRI3.isAbsolute() && !uRI3.getScheme().equals("urn")) {
            __log.fatal((Object)("openResource: invalid scheme (should be urn:)  " + uRI));
            return null;
        }
        File file = new File(uRI2.getPath(), uRI3.getPath());
        if (file.exists()) {
            return new FileInputStream(file);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("fileNotFound: " + file));
        }
        return null;
    }

    public URI getBaseResourceURI() {
        return this._absoluteDir.toURI();
    }

    private URI relativize(URI uRI) {
        if (uRI.isAbsolute()) {
            return this._absoluteDir.toURI().relativize(uRI);
        }
        return uRI;
    }

    public URI resolve(URI uRI, URI uRI2) {
        uRI = this.relativize(uRI);
        uRI2 = this.relativize(uRI2);
        URI uRI3 = uRI.resolve(uRI2);
        URI uRI4 = this._absoluteDir.toURI().resolve(uRI3);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolving URI: parent " + uRI + " child " + uRI2 + " result " + uRI3 + " resultAbsolute:" + uRI4));
        }
        return uRI4;
    }
}

