/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionValidator;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.o.OVarType;

public class ExpressionValidatorFactory {
    private static final Log __log = LogFactory.getLog(ExpressionValidatorFactory.class);
    private ExpressionValidator _validator = new EmptyValidator();

    public ExpressionValidatorFactory(Properties properties) {
        String string = "org.apache.ode.validator";
        String string2 = properties.getProperty(string, "");
        __log.debug((Object)("Trying property " + string + " got value: " + string2));
        if (!string2.equals("")) {
            try {
                this.getClass();
                this._validator = (ExpressionValidator)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                __log.warn((Object)("Cannot instantiate expression validator of class " + string2));
            }
        }
    }

    public ExpressionValidator getValidator() {
        return this._validator;
    }

    private static class EmptyValidator
    implements ExpressionValidator {
        private EmptyValidator() {
        }

        public void bpelImportsLoaded(Process process, CompilerContext compilerContext) throws CompilationException {
        }

        public void bpelCompilationCompleted(Process process) throws CompilationException {
        }

        public Object validate(Expression expression, OVarType oVarType, Object object) throws CompilationException {
            return null;
        }
    }
}

