/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.OperationType;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.InvokeGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.InvokeActivity;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OInvoke;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvokeGenerator
extends DefaultActivityGenerator {
    private static final CommonCompilationMessages __cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private static final InvokeGeneratorMessages __imsgs = (InvokeGeneratorMessages)MessageBundle.getMessages(InvokeGeneratorMessages.class);

    InvokeGenerator() {
    }

    @Override
    public OActivity newInstance(Activity activity) {
        return new OInvoke(this._context.getOProcess(), this._context.getCurrent());
    }

    @Override
    public void compile(OActivity oActivity, Activity activity) {
        InvokeActivity invokeActivity = (InvokeActivity)activity;
        final OInvoke oInvoke = (OInvoke)oActivity;
        oInvoke.partnerLink = this._context.resolvePartnerLink(invokeActivity.getPartnerLink());
        oInvoke.operation = this._context.resolvePartnerRoleOperation(oInvoke.partnerLink, invokeActivity.getOperation());
        assert (oInvoke.operation.getInput() != null);
        assert (oInvoke.operation.getInput().getMessage() != null);
        if (oInvoke.operation.getInput() != null && oInvoke.operation.getInput().getMessage() != null && oInvoke.operation.getInput().getMessage().getParts().size() > 0) {
            if (invokeActivity.getInputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoInputMessageForInputOp(oInvoke.operation.getName()));
            }
            oInvoke.inputVar = this._context.resolveMessageVariable(invokeActivity.getInputVar(), oInvoke.operation.getInput().getMessage().getQName());
        }
        if (oInvoke.operation.getOutput() != null && oInvoke.operation.getOutput().getMessage() != null) {
            if (invokeActivity.getOutputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoOutputMessageForOutputOp(oInvoke.operation.getName()));
            }
            oInvoke.outputVar = this._context.resolveMessageVariable(invokeActivity.getOutputVar(), oInvoke.operation.getOutput().getMessage().getQName());
        }
        List<Correlation> list = invokeActivity.getCorrelations();
        List list2 = (List)CollectionsX.filter(new ArrayList(), list, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation correlation) {
                return correlation.getPattern() == Correlation.CorrelationPattern.IN;
            }
        });
        List list3 = (List)CollectionsX.filter(new ArrayList(), list, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation correlation) {
                return correlation.getPattern() == Correlation.CorrelationPattern.OUT || correlation.getPattern() == Correlation.CorrelationPattern.UNSET && oInvoke.operation.getStyle() == OperationType.ONE_WAY;
            }
        });
        List list4 = (List)CollectionsX.filter(new ArrayList(), list, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation correlation) {
                return correlation.getPattern() == Correlation.CorrelationPattern.INOUT;
            }
        });
        if (oInvoke.inputVar != null) {
            this.doCorrelations(list3, oInvoke.inputVar, oInvoke.assertCorrelationsInput, oInvoke.initCorrelationsInput, oInvoke.joinCorrelationsInput);
            this.doCorrelations(list4, oInvoke.inputVar, oInvoke.assertCorrelationsInput, oInvoke.initCorrelationsInput, oInvoke.joinCorrelationsInput);
        }
        if (oInvoke.outputVar != null) {
            this.doCorrelations(list2, oInvoke.outputVar, oInvoke.assertCorrelationsOutput, oInvoke.initCorrelationsOutput, oInvoke.joinCorrelationsOutput);
            this.doCorrelations(list4, oInvoke.outputVar, oInvoke.assertCorrelationsOutput, oInvoke.initCorrelationsOutput, oInvoke.joinCorrelationsOutput);
        }
    }

    private void doCorrelations(List<Correlation> list, OScope.Variable variable, Collection<OScope.CorrelationSet> collection, Collection<OScope.CorrelationSet> collection2, Collection<OScope.CorrelationSet> collection3) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Correlation correlation : list) {
            if (hashSet.contains(correlation.getCorrelationSet())) {
                throw new CompilationException(__cmsgsGeneral.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
            }
            OScope.CorrelationSet correlationSet = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case NO: {
                    collection.add(correlationSet);
                    break;
                }
                case YES: {
                    collection2.add(correlationSet);
                    break;
                }
                case JOIN: {
                    correlationSet.hasJoinUseCases = true;
                    collection3.add(correlationSet);
                }
            }
            for (OProcess.OProperty oProperty : correlationSet.properties) {
                try {
                    this._context.resolvePropertyAlias(variable, oProperty.name);
                }
                catch (CompilationException compilationException) {
                    if (compilationException.getCompilationMessage().source == null) {
                        compilationException.getCompilationMessage().source = correlation;
                    }
                    throw compilationException;
                }
            }
            hashSet.add(correlation.getCorrelationSet());
        }
    }
}

