/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10ExpressionBPEL20 _oxpath;

    public JaxpVariableResolver(CompilerContext compilerContext, OXPath10ExpressionBPEL20 oXPath10ExpressionBPEL20) {
        this._cctx = compilerContext;
        this._oxpath = oXPath10ExpressionBPEL20;
    }

    public Object resolveVariable(QName qName) {
        if ("ode".equals(qName.getPrefix()) || Namespaces.ODE_EXTENSION_NS.equals(qName.getNamespaceURI())) {
            if ("pid".equals(qName.getLocalPart()) || "processQName".equals(qName.getLocalPart())) {
                return "";
            }
            if ("currentEventDateTime".equals(qName.getLocalPart())) {
                return new Date(1L);
            }
        }
        try {
            String string = qName.getLocalPart();
            if (this._oxpath.isJoinExpression) {
                OLink oLink = this._cctx.resolveLink(string);
                this._oxpath.links.put(string, oLink);
                return Boolean.TRUE;
            }
            int n = string.indexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            OScope.Variable variable = this._cctx.resolveVariable(string);
            this._oxpath.vars.put(string, variable);
            return this.extractValue(variable, variable.type);
        }
        catch (CompilationException compilationException) {
            throw new WrappedResolverException(compilationException);
        }
    }

    private Object extractValue(OScope.Variable variable, OVarType oVarType) {
        if (oVarType instanceof OXsdTypeVarType) {
            return this.generateFromType(((OXsdTypeVarType)oVarType).xsdType);
        }
        if (oVarType instanceof OElementVarType) {
            return this.generateFromType(((OElementVarType)oVarType).elementType);
        }
        if (oVarType instanceof OMessageVarType) {
            if (((OMessageVarType)oVarType).parts.size() == 0) {
                throw new WrappedResolverException(__msgs.errExpressionMessageNoPart(variable.name));
            }
            return this.extractValue(variable, ((OMessageVarType.Part)((OMessageVarType)oVarType).parts.values().iterator().next()).type);
        }
        return "";
    }

    private Object generateFromType(QName qName) {
        if (qName.getNamespaceURI().equals(Namespaces.XML_SCHEMA)) {
            if (qName.getLocalPart().equals("int") || qName.getLocalPart().equals("integer") || qName.getLocalPart().equals("short") || qName.getLocalPart().equals("long") || qName.getLocalPart().equals("byte") || qName.getLocalPart().equals("float") || qName.getLocalPart().equals("double") || qName.getLocalPart().equals("nonPositiveInteger") || qName.getLocalPart().equals("nonNegativeInteger") || qName.getLocalPart().equals("negativeInteger") || qName.getLocalPart().equals("unsignedLong") || qName.getLocalPart().equals("unsignedInt") || qName.getLocalPart().equals("unsignedShort") || qName.getLocalPart().equals("unsignedByte")) {
                return 0;
            }
            if (qName.getLocalPart().equals("boolean")) {
                return Boolean.TRUE;
            }
            if (qName.getLocalPart().equals("string")) {
                return "";
            }
        }
        Document document = DOMUtils.newDocument();
        document.appendChild(document.createElement("empty"));
        return document.getDocumentElement();
    }
}

