/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompilationErrorListener;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.compiler.XPath20ExpressionCompilerBPEL20;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath20ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Log __log = LogFactory.getLog(XPath20ExpressionCompilerBPEL20.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XPath20ExpressionCompilerImpl(String string) {
        this._bpelNS = string;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.elang.xpath20.runtime.XPath20ExpressionRuntime");
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xslCompilationErrorListener = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener((ErrorListener)xslCompilationErrorListener);
    }

    @Override
    public OExpression compileJoinCondition(Object object) throws CompilationException {
        return this._compile((Expression)object, true);
    }

    @Override
    public OExpression compile(Object object) throws CompilationException {
        return this._compile((Expression)object, false);
    }

    @Override
    public OLValueExpression compileLValue(Object object) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)object, false);
    }

    private OExpression _compile(Expression expression, boolean bl) throws CompilationException {
        OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20 = new OXPath20ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, bl);
        oXPath20ExpressionBPEL20.namespaceCtx = expression.getNamespaceContext();
        this.doJaxpCompile(oXPath20ExpressionBPEL20, expression);
        return oXPath20ExpressionBPEL20;
    }

    private void doJaxpCompile(OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20, Expression expression) throws CompilationException {
        Node node = expression.getExpression();
        if (node == null) {
            throw new CompilationException(this.__msgs.errEmptyExpression(expression.getURI(), new QName(expression.getElement().getNamespaceURI(), expression.getElement().getNodeName())));
        }
        if (node.getNodeType() != 3 && node.getNodeType() != 4) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString((Node)node)));
        }
        String string = node.getNodeValue();
        if ((string = string.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString((Node)node), "empty string"));
        }
        oXPath20ExpressionBPEL20.xpath = string;
        try {
            __log.debug((Object)("Compiling expression " + string));
            XPathFactoryImpl xPathFactoryImpl = new XPathFactoryImpl();
            JaxpFunctionResolver jaxpFunctionResolver = new JaxpFunctionResolver(this._compilerContext, oXPath20ExpressionBPEL20, expression.getNamespaceContext(), this._bpelNS);
            JaxpVariableResolver jaxpVariableResolver = new JaxpVariableResolver(this._compilerContext, (OXPath10ExpressionBPEL20)oXPath20ExpressionBPEL20);
            XPath xPath = xPathFactoryImpl.newXPath();
            xPath.setXPathFunctionResolver(jaxpFunctionResolver);
            xPath.setXPathVariableResolver(jaxpVariableResolver);
            xPath.setNamespaceContext((NamespaceContext)expression.getNamespaceContext());
            XPathExpression xPathExpression = xPath.compile(string);
            try {
                xPathExpression.evaluate(node);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            for (String string2 : this.extractVariableExprs(string)) {
                xPathExpression = xPath.compile(string2);
                try {
                    xPathExpression.evaluate(node);
                }
                catch (XPathExpressionException xPathExpressionException) {}
            }
            for (String string2 : this.extractFunctionExprs(string)) {
                xPathExpression = xPath.compile(string2);
                try {
                    xPathExpression.evaluate(node);
                }
                catch (XPathExpressionException xPathExpressionException) {}
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            __log.debug((Object)xPathExpressionException);
            __log.info((Object)("Couldn't validate properly expression " + string));
        }
        catch (WrappedResolverException wrappedResolverException) {
            if (wrappedResolverException._compilationMsg != null) {
                throw new CompilationException(wrappedResolverException._compilationMsg, (Throwable)wrappedResolverException);
            }
            if (wrappedResolverException.getCause() instanceof CompilationException) {
                throw (CompilationException)wrappedResolverException.getCause();
            }
            throw wrappedResolverException;
        }
    }

    private List<String> extractVariableExprs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("$");
        int n2 = string.lastIndexOf("$");
        int n3 = string.indexOf("(");
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0 && n3 > 0 || n < n2) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Name11Checker name11Checker = Name11Checker.getInstance();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    boolean bl4 = bl = !bl;
                }
                if (c == '\"') {
                    boolean bl5 = bl2 = !bl2;
                }
                if (bl || bl2) continue;
                if (c == '$') {
                    bl3 = true;
                    stringBuffer.setLength(0);
                    stringBuffer.append(c);
                    continue;
                }
                if (!bl3) continue;
                stringBuffer.append(c);
                if (c == ':' || i != string.length() && name11Checker.isQName(stringBuffer.substring(1))) continue;
                bl3 = false;
                stringBuffer.setLength(stringBuffer.length() - 1);
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            if (stringBuffer.length() > 0) {
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    private List<String> extractFunctionExprs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("(");
        int n2 = string.lastIndexOf("(");
        if (n > 0 && n < n2) {
            Pattern pattern = Pattern.compile("(\\w+:)?\\w+\\((.+)?\\)");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }
}

