/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.v1.BpelCompiler11;
import org.apache.ode.bpel.compiler.v1.BpelCompiler20;
import org.apache.ode.bpel.compiler.v2.BpelCompiler20Draft;
import org.apache.ode.utils.msg.MessageBundle;

public class BpelCompilerFactory {
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    public static int forceVersion = -1;

    public static BpelCompiler latestCompiler(BpelCompiler.Version bpelVersion) throws Exception {
        if (forceVersion > 0) {
            return BpelCompilerFactory.versionCompiler(bpelVersion, forceVersion);
        }
        return BpelCompilerFactory.versionCompiler(bpelVersion, 2);
    }

    public static BpelCompiler versionCompiler(BpelCompiler.Version bpelVersion, int version) throws Exception {
        BpelCompiler compiler = null;
        block0 : switch (version) {
            case 1: {
                switch (bpelVersion) {
                    case BPEL20: {
                        compiler = new BpelCompiler20();
                        break block0;
                    }
                    case BPEL20_DRAFT: {
                        compiler = new org.apache.ode.bpel.compiler.v1.BpelCompiler20Draft();
                        break block0;
                    }
                    case BPEL11: {
                        compiler = new BpelCompiler11();
                        break block0;
                    }
                }
                CompilationMessage cmsg = __cmsgs.errUnrecognizedBpelVersion();
                throw new CompilationException(cmsg);
            }
            case 2: {
                switch (bpelVersion) {
                    case BPEL20: {
                        compiler = new org.apache.ode.bpel.compiler.v2.BpelCompiler20();
                        break block0;
                    }
                    case BPEL20_DRAFT: {
                        compiler = new BpelCompiler20Draft();
                        break block0;
                    }
                    case BPEL11: {
                        compiler = new org.apache.ode.bpel.compiler.v2.BpelCompiler11();
                        break block0;
                    }
                }
                CompilationMessage cmsg = __cmsgs.errUnrecognizedBpelVersion();
                throw new CompilationException(cmsg);
            }
            default: {
                throw new RuntimeException("Non existant version: " + version);
            }
        }
        return compiler;
    }
}

