/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlFinderXMLEntityResolver
implements XMLEntityResolver {
    private static final Log __log = LogFactory.getLog(WsdlFinderXMLEntityResolver.class);
    private boolean _failIfNotFound = true;
    private ResourceFinder _wsdlFinder;
    private Map<URI, String> _internalSchemas = new HashMap<URI, String>();
    private URI _baseURI;

    public WsdlFinderXMLEntityResolver(ResourceFinder finder, URI baseURI, Map<URI, String> internalSchemas, boolean failIfNotFound) {
        this._wsdlFinder = finder;
        this._baseURI = baseURI;
        this._internalSchemas = internalSchemas;
        this._failIfNotFound = failIfNotFound;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolveEntity(" + resourceIdentifier + ")"));
        }
        XMLInputSource src = new XMLInputSource(resourceIdentifier);
        if (resourceIdentifier.getLiteralSystemId() == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("resolveEntity: no schema location for " + resourceIdentifier.getNamespace()));
            }
            try {
                if (this._internalSchemas.get(new URI(resourceIdentifier.getNamespace())) != null) {
                    src.setByteStream((InputStream)new ByteArrayInputStream(this._internalSchemas.get(new URI(resourceIdentifier.getNamespace())).getBytes()));
                    return src;
                }
            }
            catch (URISyntaxException e) {
                __log.debug((Object)("resolveEntity: no schema location an no known namespace for: " + resourceIdentifier.getNamespace()));
            }
            return null;
        }
        URI location = resourceIdentifier.getExpandedSystemId() != null ? this._baseURI.resolve(resourceIdentifier.getExpandedSystemId()) : this._baseURI.resolve(resourceIdentifier.getLiteralSystemId());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolveEntity: Expecting to find " + resourceIdentifier.getNamespace() + " at " + location));
        }
        if (this._internalSchemas.get(location) != null) {
            src.setByteStream((InputStream)new ByteArrayInputStream(this._internalSchemas.get(location).getBytes()));
            return src;
        }
        try {
            InputStream str = this._wsdlFinder.openResource(location);
            if (str == null) {
                __log.debug((Object)("resolveEntity: resource not found: " + location));
                throw new IOException("Resource not found: " + location);
            }
            src.setByteStream(str);
        }
        catch (IOException ioex) {
            __log.debug((Object)("resolveEntity: IOException opening " + location), (Throwable)ioex);
            if (this._failIfNotFound) {
                __log.debug((Object)"resolveEntity: failIfNotFound is true, rethrowing...");
                throw ioex;
            }
            __log.debug((Object)"resolveEntity: failIfNotFound is false, returning null");
            return null;
        }
        catch (Exception ex) {
            __log.debug((Object)("resolveEntity: unexpected error: " + location));
            throw new IOException("Unexpected error loading resource: " + location);
        }
        return src;
    }
}

