/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompilationMessageBundle;

public class XPathMessages
extends CompilationMessageBundle {
    public CompilationMessage errUnconfigurableXPathFactory() {
        return super.formatCompilationMessage("Couldn't configure XPath factory", new Object[0]);
    }

    public CompilationMessage errInvalidNumberOfArguments(String functionName) {
        return super.formatCompilationMessage("Invalid number of argument to function \"{0}\".", functionName);
    }

    public CompilationMessage errXslCompilation(String xslName, String error) {
        return super.formatCompilationMessage("Error compiling XSL Sheet \"{0}\" : {1}", xslName, error);
    }

    public CompilationMessage errUnknownBpelFunction(String functionName) {
        return super.formatCompilationMessage("Attempt to use an unrecognized BPEL function \"{0}\".", functionName);
    }

    public CompilationMessage errLiteralExpected(String text) {
        return super.formatCompilationMessage("The expression \"{0}\" must be a literal string.", text);
    }

    public CompilationMessage errUndeclaredFunctionPrefix(String prefix, String functionName) {
        return super.formatCompilationMessage("The prefix \"{0}\" on the XPath function \"{1}\" is not bound to a URI.", prefix, functionName);
    }

    public CompilationMessage errInvalidQName(String qnameStr) {
        return super.formatCompilationMessage("The prefixed name \"{0}\" could not be dereferenced in this namespace context.", qnameStr);
    }

    public CompilationMessage errXPathSyntax(String xPathString) {
        return super.formatCompilationMessage("The string \"{0}\" is not a valid XPath 1.0 expression.", xPathString);
    }

    public CompilationMessage warnXPath20Syntax(String xPathString, String message) {
        return super.formatCompilationMessage("The string \"{0}\" is not a valid XPath 2.0 expression: {1}", xPathString, message);
    }

    public CompilationMessage errUnexpectedNodeTypeForXPath(String string) {
        return super.formatCompilationMessage("The XPath node with value \"{0}\" was not a text node.", string);
    }

    public CompilationMessage errUnexpectedCompilationError(String string) {
        return super.formatCompilationMessage("Unexpected compilation error: {0}", string);
    }

    public CompilationMessage errXsltStylesheetNotFound(String string) {
        return super.formatCompilationMessage("bpws:xsltStylesheetNotFound the declared stylesheet could not be found: {0}", string);
    }

    public CompilationMessage errExpressionMessageNoPart(String message) {
        return super.formatCompilationMessage("Attempt to use the messageType variable {0} in an expression  even though the associated message is undefined or has no part.", message);
    }
}

