/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.ForEachActivity;
import org.apache.ode.bpel.compiler.bom.Scope;
import org.apache.ode.bpel.compiler.v1.AssignGenerator;
import org.apache.ode.bpel.compiler.v1.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v1.ForEachGeneratorMessages;
import org.apache.ode.bpel.rtrep.v1.OActivity;
import org.apache.ode.bpel.rtrep.v1.OForEach;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OXsdTypeVarType;
import org.apache.ode.utils.msg.MessageBundle;

public class ForEachGenerator
extends DefaultActivityGenerator {
    private static final Log __log = LogFactory.getLog(AssignGenerator.class);
    private static final ForEachGeneratorMessages __cmsgs = (ForEachGeneratorMessages)MessageBundle.getMessages(ForEachGeneratorMessages.class);

    public OActivity newInstance(Activity src) {
        return new OForEach(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity output, Activity src) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Compiling ForEach activity.");
        }
        OForEach oforEach = (OForEach)output;
        ForEachActivity forEach = (ForEachActivity)src;
        oforEach.parallel = forEach.isParallel();
        oforEach.startCounterValue = this._context.compileExpr(forEach.getStartCounter());
        oforEach.finalCounterValue = this._context.compileExpr(forEach.getFinalCounter());
        if (forEach.getCompletionCondition() != null) {
            oforEach.completionCondition = new OForEach.CompletionCondition(this._context.getOProcess());
            oforEach.completionCondition.successfulBranchesOnly = forEach.getCompletionCondition().isSuccessfulBranchesOnly();
            oforEach.completionCondition.branchCount = this._context.compileExpr(forEach.getCompletionCondition());
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Adding the forEach counter variable to inner scope.");
        }
        if (forEach.getChild() == null) {
            throw new CompilationException(__cmsgs.errMissingScopeinForeach().setSource(forEach));
        }
        Scope s = forEach.getChild().getScope();
        if (s.getVariableDecl(forEach.getCounterName()) != null) {
            throw new CompilationException(__cmsgs.errForEachAndScopeVariableRedundant(forEach.getCounterName()).setSource(src));
        }
        OXsdTypeVarType counterType = new OXsdTypeVarType(oforEach.getOwner());
        counterType.simple = true;
        counterType.xsdType = new QName("http://www.w3.org/2001/XMLSchema", "int");
        OScope.Variable counterVar = new OScope.Variable(oforEach.getOwner(), (OVarType)counterType);
        counterVar.name = forEach.getCounterName();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Compiling forEach inner scope.");
        }
        oforEach.innerScope = this._context.compileSLC(forEach.getChild(), new OScope.Variable[]{counterVar});
        oforEach.counterVariable = counterVar;
    }
}

