/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.InvokeActivity;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v2.InvokeGeneratorMessages;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OInvoke;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvokeGenerator
extends DefaultActivityGenerator {
    private static final InvokeGeneratorMessages __imsgs = (InvokeGeneratorMessages)MessageBundle.getMessages(InvokeGeneratorMessages.class);

    InvokeGenerator() {
    }

    @Override
    public OActivity newInstance(Activity src) {
        return new OInvoke(this._context.getOProcess(), this._context.getCurrent());
    }

    @Override
    public void compile(OActivity output, Activity srcx) {
        InvokeActivity src = (InvokeActivity)srcx;
        OInvoke oinvoke = (OInvoke)output;
        oinvoke.partnerLink = this._context.resolvePartnerLink(src.getPartnerLink());
        oinvoke.operation = this._context.resolvePartnerRoleOperation(oinvoke.partnerLink, src.getOperation());
        assert (oinvoke.operation.getInput() != null);
        assert (oinvoke.operation.getInput().getMessage() != null);
        if (src.getPortType() != null && !src.getPortType().equals(oinvoke.partnerLink.partnerRolePortType.getQName())) {
            throw new CompilationException(__imsgs.errPortTypeMismatch(src.getPortType(), oinvoke.partnerLink.partnerRolePortType.getQName()));
        }
        if (oinvoke.operation.getInput() != null && oinvoke.operation.getInput().getMessage() != null && oinvoke.operation.getInput().getMessage().getParts().size() > 0) {
            if (src.getInputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoInputMessageForInputOp(oinvoke.operation.getName()));
            }
            oinvoke.inputVar = this._context.resolveMessageVariable(src.getInputVar(), oinvoke.operation.getInput().getMessage().getQName());
            oinvoke.variableRd.add(oinvoke.inputVar);
        }
        if (oinvoke.operation.getOutput() != null && oinvoke.operation.getOutput().getMessage() != null) {
            if (src.getOutputVar() == null) {
                throw new CompilationException(__imsgs.errInvokeNoOutputMessageForOutputOp(oinvoke.operation.getName()));
            }
            oinvoke.outputVar = this._context.resolveMessageVariable(src.getOutputVar(), oinvoke.operation.getOutput().getMessage().getQName());
            oinvoke.variableWr.add(oinvoke.outputVar);
        }
        List<Correlation> correlations = src.getCorrelations();
        List incorrelations = (List)CollectionsX.filter(new ArrayList(), correlations, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation o) {
                return o.getPattern() == Correlation.CorrelationPattern.IN;
            }
        });
        List outcorrelations = (List)CollectionsX.filter(new ArrayList(), correlations, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation o) {
                return o.getPattern() == Correlation.CorrelationPattern.OUT;
            }
        });
        List inoutcorrelations = (List)CollectionsX.filter(new ArrayList(), correlations, (MemberOfFunction)new MemberOfFunction<Correlation>(){

            public boolean isMember(Correlation o) {
                return o.getPattern() == Correlation.CorrelationPattern.INOUT;
            }
        });
        if (oinvoke.inputVar != null) {
            this.doCorrelations(outcorrelations, oinvoke.inputVar, oinvoke.assertCorrelationsInput, oinvoke.initCorrelationsInput);
            this.doCorrelations(inoutcorrelations, oinvoke.inputVar, oinvoke.assertCorrelationsInput, oinvoke.initCorrelationsInput);
        }
        if (oinvoke.outputVar != null) {
            this.doCorrelations(incorrelations, oinvoke.outputVar, oinvoke.assertCorrelationsOutput, oinvoke.initCorrelationsOutput);
            this.doCorrelations(inoutcorrelations, oinvoke.outputVar, oinvoke.assertCorrelationsOutput, oinvoke.initCorrelationsOutput);
        }
    }

    private void doCorrelations(List<Correlation> correlations, OScope.Variable var, Collection<OScope.CorrelationSet> assertCorrelations, Collection<OScope.CorrelationSet> initCorrelations) {
        for (Correlation correlation : correlations) {
            OScope.CorrelationSet cset = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case NO: {
                    assertCorrelations.add(cset);
                    break;
                }
                case YES: {
                    initCorrelations.add(cset);
                    break;
                }
                case JOIN: {
                    throw new UnsupportedOperationException();
                }
            }
            for (OProcess.OProperty property : cset.properties) {
                try {
                    this._context.resolvePropertyAlias(var, property.name);
                }
                catch (CompilationException ce) {
                    if (ce.getCompilationMessage().source == null) {
                        ce.getCompilationMessage().source = correlation;
                    }
                    throw ce;
                }
            }
        }
    }
}

