/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.CompositeActivity;
import org.apache.ode.bpel.compiler.bom.SequenceActivity;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OSequence;
import org.apache.ode.utils.msg.MessageBundle;

class SequenceGenerator
extends DefaultActivityGenerator {
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);

    SequenceGenerator() {
    }

    public OActivity newInstance(Activity src) {
        return new OSequence(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity output, Activity src) {
        OSequence oseq = (OSequence)output;
        this.compileChildren(oseq, (SequenceActivity)src);
    }

    protected void compileChildren(OSequence dest, CompositeActivity src) {
        if (src.getActivities().size() == 0) {
            throw new CompilationException(__cmsgs.errEmptySequence().setSource(src));
        }
        for (Activity child : src.getActivities()) {
            try {
                OActivity compiledChild = this._context.compile(child);
                dest.sequence.add(compiledChild);
            }
            catch (CompilationException ce) {
                this._context.recoveredFromError(child, ce);
            }
        }
    }
}

