/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2.xpath20;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xpath.XPathFunctionCall;
import net.sf.saxon.xpath.XPathFunctionLibrary;
import org.apache.ode.bpel.compiler.v2.xpath20.JaxpFunctionResolver;

public class OdeXPathFunctionLibrary
extends XPathFunctionLibrary {
    private static final long serialVersionUID = -8885396864277163797L;
    private JaxpFunctionResolver _funcResolver;

    public OdeXPathFunctionLibrary(JaxpFunctionResolver funcResolver) {
        this._funcResolver = funcResolver;
    }

    public Expression bind(int nameCode, String uri, String local, Expression[] staticArgs) throws XPathException {
        QName name = new QName(uri, local);
        XPathFunction function = this._funcResolver.resolveFunction(name, staticArgs.length);
        if (function == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>(staticArgs.length);
        for (Expression expression : staticArgs) {
            String exprStr = expression.toString();
            if (exprStr.startsWith("\"")) {
                exprStr = exprStr.substring(1);
            }
            if (exprStr.endsWith("\"")) {
                exprStr = exprStr.substring(0, exprStr.length() - 1);
            }
            args.add(exprStr);
        }
        try {
            function.evaluate(args);
        }
        catch (XPathFunctionException e) {
            throw new StaticError((Exception)e);
        }
        XPathFunctionCall fc = new XPathFunctionCall(function);
        fc.setArguments(staticArgs);
        return fc;
    }
}

