/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.bom;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.SourceLocation;
import org.apache.ode.bpel.compiler.bom.BpelObjectFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelObject
extends SourceLocation {
    public static final QName ATTR_LINENO = new QName("urn:org.apache.ode.bpel.compiler", "lineno");
    private final Element _element;
    private final QName _type;
    private final NSContext _nsContext;
    private List<BpelObject> _children = null;
    private URI _docURI;

    public BpelObject(Element el) {
        this._element = el;
        this._type = new QName(el.getNamespaceURI(), el.getLocalName());
        this._nsContext = new NSContext();
        this.initNSContext(el);
    }

    public QName getType() {
        return this._type;
    }

    public Element getElement() {
        return this._element;
    }

    @Override
    public int getLineNo() {
        return Integer.valueOf(this.getAttribute(ATTR_LINENO, "-1"));
    }

    public NSContext getNamespaceContext() {
        return this._nsContext;
    }

    public Map<QName, Object> getExtensibilityElements() {
        HashMap<QName, Object> ee = new HashMap<QName, Object>();
        for (BpelObject child : this.getChildren()) {
            if (child.getType().getNamespaceURI() == null || child.getType().getNamespaceURI().equals(this.getType().getNamespaceURI())) continue;
            ee.put(child.getType(), child.getElement());
        }
        NamedNodeMap nnm = this.getElement().getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            if (n.getNamespaceURI() == null || n.getNamespaceURI().equals(this.getType().getNamespaceURI())) continue;
            ee.put(new QName(n.getNamespaceURI(), n.getLocalName()), n.getTextContent());
        }
        return ee;
    }

    public Element getExtensibilityElement(QName extElName) {
        BpelObject e = this.getFirstChild(extElName);
        if (e == null) {
            return null;
        }
        return e.getElement();
    }

    public Element getFirstExtensibilityElement() {
        Element child = null;
        NodeList nl = this.getElement().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || this.getType().getNamespaceURI().equals(node.getNamespaceURI())) continue;
            child = (Element)node;
            break;
        }
        return child;
    }

    public boolean is11() {
        return this.getType().getNamespaceURI() != null && (this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2003/03/business-process/") || this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2003/05/partner-link/"));
    }

    public boolean is20Draft() {
        return this.getType().getNamespaceURI() != null && (this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || this.getType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/03/partner-link/"));
    }

    protected boolean isAttributeSet(String attrname) {
        return null != this.getAttribute(attrname, null);
    }

    protected <T extends BpelObject> List<T> getChildren(Class<T> cls) {
        return (List)CollectionsX.filter(new ArrayList(), this.getChildren(), cls);
    }

    protected <T extends BpelObject> T getFirstChild(Class<T> cls) {
        List<T> children = this.getChildren(cls);
        if (children.size() == 0) {
            return null;
        }
        return (T)((BpelObject)children.get(0));
    }

    protected List<BpelObject> getChildren(final QName type) {
        return (List)CollectionsX.filter(new ArrayList(), this.getChildren(), (MemberOfFunction)new MemberOfFunction<BpelObject>(){

            public boolean isMember(BpelObject o) {
                return o.getType().equals(type);
            }
        });
    }

    protected BpelObject getFirstChild(final QName type) {
        return (BpelObject)CollectionsX.find_if(this.getChildren(), (MemberOfFunction)new MemberOfFunction<BpelObject>(){

            public boolean isMember(BpelObject o) {
                return o.getType().equals(type);
            }
        });
    }

    protected QName rewriteTargetNS(QName target) {
        return new QName(this.getType().getNamespaceURI(), target.getLocalPart());
    }

    protected List<BpelObject> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<BpelObject>();
            NodeList nl = this._element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                this._children.add(this.createBpelObject((Element)node));
            }
        }
        return this._children;
    }

    protected BpelObject createBpelObject(Element element) {
        return BpelObjectFactory.getInstance().createBpelObject(element, this._docURI);
    }

    protected String getAttribute(QName name, String dflt) {
        String val = this._element.getAttributeNS(name.getNamespaceURI(), name.getLocalPart());
        if (val == null || "".equals(val)) {
            return dflt;
        }
        return val;
    }

    protected String getAttribute(String name, String dflt) {
        String val = this._element.getAttribute(name);
        if (val == null || "".equals(val)) {
            return dflt;
        }
        return val;
    }

    protected String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    protected <T> T getAttribute(String attrName, Map<String, T> suppressJoinFailure, T notset) {
        String val = this.getAttribute(attrName, null);
        if (val == null || "".equals(val)) {
            return notset;
        }
        return suppressJoinFailure.get(val);
    }

    private void initNSContext(Element el) {
        if (el.getParentNode() != null && el.getParentNode().getNodeType() == 1) {
            this.initNSContext((Element)el.getParentNode());
        }
        NamedNodeMap attrs = el.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            String prefix = attr.getLocalName();
            String uri = attr.getValue();
            this._nsContext.register(prefix, uri);
        }
        Attr dflt = el.getAttributeNode("xmlns");
        if (dflt != null) {
            this._nsContext.register("", dflt.getTextContent());
        }
    }

    public String getTextValue() {
        this.getElement().normalize();
        for (Node n = this.getElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: 
                case 3: 
                case 4: {
                    return n.getNodeValue();
                }
            }
        }
        return null;
    }

    public String toString() {
        return DOMUtils.domToString((Node)this._element);
    }

    @Override
    public int getColumnNo() {
        return 0;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public URI getURI() {
        return this._docURI;
    }

    public void setURI(URI uri) {
        this._docURI = uri;
    }
}

