/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1;

import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.IfActivity;
import org.apache.ode.bpel.compiler.v1.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v1.IfGeneratorMessages;
import org.apache.ode.bpel.rtrep.v1.OActivity;
import org.apache.ode.bpel.rtrep.v1.OSwitch;
import org.apache.ode.utils.msg.MessageBundle;

class IfGenerator
extends DefaultActivityGenerator {
    private static final IfGeneratorMessages __cmsgs = (IfGeneratorMessages)MessageBundle.getMessages(IfGeneratorMessages.class);

    IfGenerator() {
    }

    public OActivity newInstance(Activity src) {
        return new OSwitch(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity output, Activity src) {
        OSwitch oswitch = (OSwitch)output;
        IfActivity switchDef = (IfActivity)src;
        if (switchDef.getCondition() == null) {
            throw new CompilationException(__cmsgs.errIfWithNoCondition());
        }
        boolean first = true;
        if (switchDef.getActivity() != null) {
            OSwitch.OCase ocase = new OSwitch.OCase(this._context.getOProcess());
            ocase.activity = this._context.compile(switchDef.getActivity());
            ocase.expression = this._context.compileExpr(switchDef.getCondition());
            oswitch.addCase(ocase);
            first = false;
        }
        for (IfActivity.Case ccase : switchDef.getCases()) {
            OSwitch.OCase ocase = new OSwitch.OCase(this._context.getOProcess());
            ocase.activity = this._context.compile(ccase.getActivity());
            ocase.expression = first ? this._context.compileExpr(switchDef.getCondition()) : (ccase.getCondition() == null ? this._context.constantExpr(true) : this._context.compileExpr(ccase.getCondition()));
            oswitch.addCase(ocase);
            first = false;
        }
    }
}

