/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1.xpath10.jaxp;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v1.CompilerContext;
import org.apache.ode.bpel.compiler.v1.xpath10.XslCompileUriResolver;
import org.apache.ode.bpel.rtrep.v1.OExpression;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log __log = LogFactory.getLog(JaxpFunctionResolver.class);
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath10Expression _out;
    private NSContext _nsContext;
    private String _bpelNS;

    public JaxpFunctionResolver(CompilerContext cctx, OXPath10Expression out, NSContext nsContext, String bpelNS) {
        this._cctx = cctx;
        this._bpelNS = bpelNS;
        this._nsContext = nsContext;
        this._bpelNS = bpelNS;
        this._out = out;
    }

    public XPathFunction resolveFunction(QName functionName, int arity) {
        __log.debug((Object)("JAXP compiler: Resolving function " + functionName));
        if (functionName.getNamespaceURI() == null) {
            throw new WrappedResolverException("Undeclared namespace for " + functionName);
        }
        if (functionName.getNamespaceURI().equals(this._bpelNS)) {
            String localName = functionName.getLocalPart();
            if ("getVariableData".equals(localName)) {
                return new GetVariableData();
            }
            if ("getVariableProperty".equals(localName)) {
                return new GetVariableProperty();
            }
            if ("getLinkStatus".equals(localName)) {
                return new GetLinkStatus();
            }
            if ("doXslTransform".equals(localName)) {
                return new DoXslTransform();
            }
            throw new WrappedResolverException(__msgs.errUnknownBpelFunction(localName));
        }
        return null;
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() < 2 || params.size() % 2 != 0) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
            }
            String xslUri = (String)params.get(0);
            OXslSheet xslSheet = JaxpFunctionResolver.this._cctx.compileXslt(xslUri);
            try {
                XslTransformHandler.getInstance().parseXSLSheet(JaxpFunctionResolver.this._cctx.getBaseResourceURI(), xslSheet.uri, xslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(JaxpFunctionResolver.this._cctx, JaxpFunctionResolver.this._out));
            }
            catch (Exception e) {
                throw new CompilationException(__msgs.errXslCompilation(xslUri, e.toString()));
            }
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.xslSheets.put(xslSheet.uri, xslSheet);
            return "";
        }
    }

    public class GetLinkStatus
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getLinkStatus"));
            }
            String linkName = (String)params.get(0);
            OLink olink = JaxpFunctionResolver.this._cctx.resolveLink(linkName);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.links.put(linkName, olink);
            return "";
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
            }
            String varName = (String)params.get(0);
            OScope.Variable v = JaxpFunctionResolver.this._cctx.resolveVariable(varName);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(varName, v);
            String propName = (String)params.get(1);
            QName qname = JaxpFunctionResolver.this._nsContext.derefQName(propName);
            if (qname == null) {
                throw new CompilationException(__msgs.errInvalidQName(propName));
            }
            OProcess.OProperty property = JaxpFunctionResolver.this._cctx.resolveProperty(qname);
            JaxpFunctionResolver.this._cctx.resolvePropertyAlias(v, qname);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.properties.put(propName, property);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(varName, v);
            return "";
        }
    }

    public class GetVariableData
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() < 1 || params.size() > 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableData"));
            }
            String varname = (String)params.get(0);
            String partname = params.size() > 1 ? (String)params.get(1) : null;
            String locationstr = params.size() > 2 ? (String)params.get(2) : null;
            OScope.Variable var = JaxpFunctionResolver.this._cctx.resolveVariable(varname);
            OMessageVarType.Part part = partname != null ? JaxpFunctionResolver.this._cctx.resolvePart(var, partname) : null;
            OExpression location = null;
            if (locationstr != null) {
                location = JaxpFunctionResolver.this._cctx.compileExpr(locationstr, JaxpFunctionResolver.this._nsContext);
            }
            JaxpFunctionResolver.this._out.addGetVariableDataSig(varname, partname, locationstr, new OXPath10Expression.OSigGetVariableData(JaxpFunctionResolver.this._cctx.getOProcess(), var, part, location));
            return "";
        }
    }
}

