/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1.xpath20;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.ode.bpel.compiler.WrappedResolverException;
import org.apache.ode.bpel.compiler.XPathMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v1.CompilerContext;
import org.apache.ode.bpel.compiler.v1.xpath10.XslCompileUriResolver;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath20.OXPath20ExpressionBPEL20;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    private CompilerContext _cctx;
    private OXPath20ExpressionBPEL20 _out;
    private NSContext _nsContext;
    private String _bpelNS;

    public JaxpFunctionResolver(CompilerContext cctx, OXPath20ExpressionBPEL20 out, NSContext nsContext, String bpelNS) {
        this._cctx = cctx;
        this._bpelNS = bpelNS;
        this._nsContext = nsContext;
        this._bpelNS = bpelNS;
        this._out = out;
    }

    public XPathFunction resolveFunction(QName functionName, int arity) {
        if (functionName.getNamespaceURI() == null) {
            throw new WrappedResolverException("Undeclared namespace for " + functionName);
        }
        if (functionName.getNamespaceURI().equals(this._bpelNS)) {
            String localName = functionName.getLocalPart();
            if ("getVariableProperty".equals(localName)) {
                return new GetVariableProperty();
            }
            if ("doXslTransform".equals(localName)) {
                return new DoXslTransform();
            }
            throw new WrappedResolverException(__msgs.errUnknownBpelFunction(localName));
        }
        if (functionName.getNamespaceURI().equals("http://www.apache.org/ode/type/extension")) {
            String localName = functionName.getLocalPart();
            if ("split-to-elements".equals(localName) || "splitToElements".equals(localName)) {
                return new SplitToElements();
            }
            if ("combine-url".equals(localName) || "combineUrl".equals(localName)) {
                return new CombineUrl();
            }
            if ("compose-url".equals(localName) || "expand-template".equals(localName) || "composeUrl".equals(localName) || "expandTemplate".equals(localName)) {
                return new ComposeUrl();
            }
            if ("dom-to-string".equals(localName) || "domToString".equals(localName)) {
                return new DomToString();
            }
            if ("insert-after".equals(localName)) {
                return new InsertAfter();
            }
            if ("insert-as-first-into".equals(localName)) {
                return new InsertAsFirstInto();
            }
            if ("insert-as-last-into".equals(localName)) {
                return new InsertAsLastInto();
            }
            if ("insert-before".equals(localName)) {
                return new InsertBefore();
            }
            if ("delete".equals(localName)) {
                return new Delete();
            }
            if ("rename".equals(localName)) {
                return new Rename();
            }
            if ("process-property".equals(localName)) {
                return new ProcessProperty();
            }
        }
        return null;
    }

    public class ProcessProperty
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("process-property"));
            }
            return "";
        }
    }

    public class Rename
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("rename"));
            }
            return "";
        }
    }

    public class Delete
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 1 || args.size() > 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("delete"));
            }
            return "";
        }
    }

    public class InsertAsLastInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-as-last-into"));
            }
            return "";
        }
    }

    public class InsertAsFirstInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-as-first-into"));
            }
            return "";
        }
    }

    public class InsertBefore
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 2 || args.size() > 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-before"));
            }
            return "";
        }
    }

    public class InsertAfter
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() < 2 || args.size() > 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-after"));
            }
            return "";
        }
    }

    public class InsertInto
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 3) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("insert-after"));
            }
            return "";
        }
    }

    public static class ComposeUrl
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2 && (args.size() <= 2 || args.size() % 2 != 1)) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("compose-url"));
            }
            return "";
        }
    }

    public static class DomToString
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 1) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("dom-to-string"));
            }
            return "";
        }
    }

    public static class CombineUrl
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            if (args.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("combine-url"));
            }
            return "";
        }
    }

    public class SplitToElements
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() < 3 || params.size() > 4) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("split-to-elements"));
            }
            return "";
        }
    }

    public class DoXslTransform
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() < 2 || params.size() % 2 != 0) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("doXslTransform"));
            }
            String xslUri = (String)params.get(0);
            OXslSheet xslSheet = JaxpFunctionResolver.this._cctx.compileXslt(xslUri);
            try {
                XslTransformHandler.getInstance().parseXSLSheet(JaxpFunctionResolver.this._cctx.getBaseResourceURI(), xslSheet.uri, xslSheet.sheetBody, (URIResolver)new XslCompileUriResolver(JaxpFunctionResolver.this._cctx, (OXPath10Expression)JaxpFunctionResolver.this._out));
            }
            catch (Exception e) {
                throw new CompilationException(__msgs.errXslCompilation(xslUri, e.toString()));
            }
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.xslSheets.put(xslSheet.uri, xslSheet);
            return "";
        }
    }

    public class GetVariableProperty
    implements XPathFunction {
        public Object evaluate(List params) throws XPathFunctionException {
            if (params.size() != 2) {
                throw new CompilationException(__msgs.errInvalidNumberOfArguments("getVariableProperty"));
            }
            String varName = (String)params.get(0);
            OScope.Variable v = JaxpFunctionResolver.this._cctx.resolveVariable(varName);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(varName, v);
            String propName = (String)params.get(1);
            QName qname = JaxpFunctionResolver.this._nsContext.derefQName(propName);
            if (qname == null) {
                throw new CompilationException(__msgs.errInvalidQName(propName));
            }
            OProcess.OProperty property = JaxpFunctionResolver.this._cctx.resolveProperty(qname);
            JaxpFunctionResolver.this._cctx.resolvePropertyAlias(v, qname);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.properties.put(propName, property);
            ((JaxpFunctionResolver)JaxpFunctionResolver.this)._out.vars.put(varName, v);
            return "";
        }
    }
}

