/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.AssignActivity;
import org.apache.ode.bpel.compiler.bom.Copy;
import org.apache.ode.bpel.compiler.bom.ExtensionAssignOperation;
import org.apache.ode.bpel.compiler.bom.ExtensionVal;
import org.apache.ode.bpel.compiler.bom.From;
import org.apache.ode.bpel.compiler.bom.LiteralVal;
import org.apache.ode.bpel.compiler.bom.PartnerLinkVal;
import org.apache.ode.bpel.compiler.bom.PropertyVal;
import org.apache.ode.bpel.compiler.bom.To;
import org.apache.ode.bpel.compiler.bom.VariableVal;
import org.apache.ode.bpel.compiler.v2.AssignGeneratorMessages;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.rtrep.v2.DebugInfo;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OAssign;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.SerializableElement;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AssignGenerator
extends DefaultActivityGenerator {
    private static final Log __log = LogFactory.getLog(AssignGenerator.class);
    private static final AssignGeneratorMessages __cmsgs = (AssignGeneratorMessages)MessageBundle.getMessages(AssignGeneratorMessages.class);

    AssignGenerator() {
    }

    public OActivity newInstance(Activity src) {
        return new OAssign(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity dest, Activity source) {
        OAssign oassign = (OAssign)dest;
        AssignActivity ad = (AssignActivity)source;
        for (AssignActivity.AssignOperation operation : ad.getOperations()) {
            if (operation instanceof Copy) {
                Copy scopy = (Copy)operation;
                OAssign.Copy ocopy = new OAssign.Copy(this._context.getOProcess());
                ocopy.keepSrcElementName = scopy.isKeepSrcElement();
                ocopy.ignoreMissingFromData = scopy.isIgnoreMissingFromData();
                ocopy.insertMissingToData = scopy.isInsertMissingToData();
                ocopy.ignoreUninitializedFromVariable = scopy.isIgnoreUninitializedFromVariable();
                ocopy.debugInfo = new DebugInfo(this._context.getSourceLocation(), scopy.getLineNo(), source.getExtensibilityElements());
                try {
                    if (scopy.getFrom() == null) {
                        throw new CompilationException(__cmsgs.errMissingFromSpec().setSource(scopy));
                    }
                    ocopy.from = this.compileFrom(scopy.getFrom());
                    if (scopy.getTo() == null) {
                        throw new CompilationException(__cmsgs.errMissingToSpec().setSource(scopy));
                    }
                    ocopy.to = this.compileTo(scopy.getTo());
                    this.verifyCopy(ocopy);
                    oassign.operations.add(ocopy);
                }
                catch (CompilationException ce) {
                    this._context.recoveredFromError(scopy, ce);
                }
                continue;
            }
            if (!(operation instanceof ExtensionAssignOperation)) continue;
            ExtensionAssignOperation sop = (ExtensionAssignOperation)operation;
            OAssign.ExtensionAssignOperation oext = new OAssign.ExtensionAssignOperation(this._context.getOProcess());
            oext.debugInfo = new DebugInfo(this._context.getSourceLocation(), sop.getLineNo(), source.getExtensibilityElements());
            try {
                if (source.is20Draft()) {
                    throw new CompilationException(__cmsgs.errExtensibleAssignNotSupported());
                }
                Element el = sop.getNestedElement();
                if (el == null) {
                    throw new CompilationException(__cmsgs.errMissingExtensionAssignOperationElement().setSource(sop));
                }
                if (!this._context.isExtensionDeclared(el.getNamespaceURI())) {
                    throw new CompilationException(__cmsgs.errUndeclaredExtensionAssignOperation().setSource(sop));
                }
                ExtensionValidator validator = this._context.getExtensionValidator(DOMUtils.getElementQName((Element)el));
                if (validator != null) {
                    validator.validate((Object)this._context, (ExtensibleElement)sop);
                }
                oext.extensionName = DOMUtils.getElementQName((Element)el);
                oext.nestedElement = new SerializableElement(el);
                oassign.operations.add(oext);
            }
            catch (CompilationException ce) {
                this._context.recoveredFromError(sop, ce);
            }
        }
    }

    private void verifyCopy(OAssign.Copy ocopy) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("verifying copy: " + ocopy));
        }
        if (ocopy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.to).isMessageRef() && ocopy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.from).isMessageRef()) {
            String lvar = ((OAssign.VariableRef)ocopy.to).variable.name;
            String rvar = ((OAssign.VariableRef)ocopy.from).variable.name;
            QName tlvalue = ((OMessageVarType)((OAssign.VariableRef)ocopy.to).variable.type).messageType;
            QName trvalue = ((OMessageVarType)((OAssign.VariableRef)ocopy.from).variable.type).messageType;
            if (!tlvalue.equals(trvalue)) {
                throw new CompilationException(__cmsgs.errMismatchedMessageAssignment(lvar, tlvalue, rvar, trvalue));
            }
        } else {
            if (ocopy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.from).isMessageRef() && (!(ocopy.to instanceof OAssign.VariableRef) || !((OAssign.VariableRef)ocopy.to).isMessageRef())) {
                String rval = ((OAssign.VariableRef)ocopy.from).variable.name;
                throw new CompilationException(__cmsgs.errCopyFromMessageToNonMessage(rval));
            }
            if (ocopy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.to).isMessageRef() && (!(ocopy.from instanceof OAssign.VariableRef) || !((OAssign.VariableRef)ocopy.from).isMessageRef())) {
                String lval = ((OAssign.VariableRef)ocopy.to).variable.name;
                throw new CompilationException(__cmsgs.errCopyToMessageFromNonMessage(lval));
            }
            if (ocopy.to instanceof OAssign.PartnerLinkRef && !((OAssign.PartnerLinkRef)ocopy.to).partnerLink.hasPartnerRole()) {
                String lval = ((OAssign.PartnerLinkRef)ocopy.to).partnerLink.getName();
                throw new CompilationException(__cmsgs.errCopyToUndeclaredPartnerRole(lval));
            }
            if (ocopy.from instanceof OAssign.PartnerLinkRef) {
                if (((OAssign.PartnerLinkRef)ocopy.from).isMyEndpointReference && !((OAssign.PartnerLinkRef)ocopy.from).partnerLink.hasMyRole()) {
                    String lval = ((OAssign.PartnerLinkRef)ocopy.from).partnerLink.getName();
                    throw new CompilationException(__cmsgs.errCopyFromUndeclaredPartnerRole(lval, "myRole"));
                }
                if (!((OAssign.PartnerLinkRef)ocopy.from).isMyEndpointReference && !((OAssign.PartnerLinkRef)ocopy.from).partnerLink.hasPartnerRole()) {
                    String lval = ((OAssign.PartnerLinkRef)ocopy.from).partnerLink.getName();
                    throw new CompilationException(__cmsgs.errCopyFromUndeclaredPartnerRole(lval, "partnerRole"));
                }
            }
        }
        __log.debug((Object)("Copy verified OK: " + ocopy));
    }

    private OAssign.RValue compileFrom(From from) {
        assert (from != null);
        try {
            if (from.isExtensionVal()) {
                return this.compileExtensionVal(from.getAsExtensionVal());
            }
            if (from.isLiteralVal()) {
                return this.compileLiteral(from.getAsLiteralVal());
            }
            if (from.isPropertyVal()) {
                OAssign.PropertyRef pref = new OAssign.PropertyRef(this._context.getOProcess());
                PropertyVal pval = from.getAsPropertyVal();
                pref.variable = this._context.resolveVariable(pval.getVariable());
                pref.propertyAlias = this._context.resolvePropertyAlias(pref.variable, pval.getProperty());
                return pref;
            }
            if (from.isVariableVal()) {
                VariableVal vv = from.getAsVariableVal();
                OAssign.VariableRef vref = new OAssign.VariableRef(this._context.getOProcess());
                vref.variable = this._context.resolveVariable(vv.getVariable());
                if (vv.getPart() != null) {
                    vref.part = this._context.resolvePart(vref.variable, vv.getPart());
                    if (vv.getLocation() != null && vv.getLocation().getExpression() != null) {
                        vref.location = this._context.compileExpr(vv.getLocation());
                    }
                }
                if (vv.getHeader() != null) {
                    vref.headerPart = this._context.resolveHeaderPart(vref.variable, vv.getHeader());
                    if (vref.headerPart == null) {
                        vref.headerPart = new OMessageVarType.Part(this._context.getOProcess(), vv.getHeader(), null);
                    }
                    if (vv.getLocation() != null && vv.getLocation().getExpression() != null) {
                        vref.location = this._context.compileExpr(vv.getLocation());
                    }
                }
                return vref;
            }
            if (from.isPartnerLinkVal()) {
                PartnerLinkVal plv = from.getAsPartnerLinkVal();
                OAssign.PartnerLinkRef plref = new OAssign.PartnerLinkRef(this._context.getOProcess());
                plref.partnerLink = this._context.resolvePartnerLink(plv.getPartnerLink());
                plref.isMyEndpointReference = plv.getEndpointReference() == PartnerLinkVal.EndpointReference.MYROLE;
                return plref;
            }
            if (from.getAsExpression() != null) {
                return new OAssign.Expression(this._context.getOProcess(), this._context.compileExpr(from.getAsExpression()));
            }
            throw new CompilationException(__cmsgs.errUnkownFromSpec().setSource(from));
        }
        catch (CompilationException ce) {
            if (ce.getCompilationMessage().source == null) {
                ce.getCompilationMessage().source = from;
            }
            throw ce;
        }
    }

    private OAssign.RValue compileExtensionVal(ExtensionVal extVal) {
        OAssign.DirectRef dref = new OAssign.DirectRef(this._context.getOProcess());
        dref.variable = this._context.resolveVariable(extVal.getVariable());
        dref.elName = extVal.getExtension();
        return dref;
    }

    private OAssign.RValue compileLiteral(LiteralVal from) {
        Element literal = from.getLiteral();
        Document newDoc = DOMUtils.newDocument();
        Element clone = (Element)newDoc.importNode(literal, true);
        newDoc.appendChild(clone);
        return new OAssign.Literal(this._context.getOProcess(), newDoc);
    }

    private OAssign.LValue compileTo(To to) {
        assert (to != null);
        try {
            if (to.isPropertyVal()) {
                OAssign.PropertyRef pref = new OAssign.PropertyRef(this._context.getOProcess());
                pref.variable = this._context.resolveVariable(to.getAsPropertyVal().getVariable());
                pref.propertyAlias = this._context.resolvePropertyAlias(pref.variable, to.getAsPropertyVal().getProperty());
                return pref;
            }
            if (to.isVariableVal()) {
                VariableVal vv = to.getAsVariableVal();
                OAssign.VariableRef vref = new OAssign.VariableRef(this._context.getOProcess());
                vref.variable = this._context.resolveVariable(vv.getVariable());
                if (to.getAsVariableVal().getPart() != null) {
                    vref.part = this._context.resolvePart(vref.variable, vv.getPart());
                    if (vv.getLocation() != null && vv.getLocation().getExpression() != null) {
                        vref.location = this._context.compileExpr(vv.getLocation());
                    }
                }
                if (to.getAsVariableVal().getHeader() != null) {
                    vref.headerPart = this._context.resolveHeaderPart(vref.variable, vv.getHeader());
                    if (vref.headerPart == null) {
                        vref.headerPart = new OMessageVarType.Part(this._context.getOProcess(), to.getAsVariableVal().getHeader(), null);
                    }
                    if (vv.getLocation() != null && vv.getLocation().getExpression() != null) {
                        vref.location = this._context.compileExpr(vv.getLocation());
                    }
                }
                return vref;
            }
            if (to.isPartnerLinkVal()) {
                OAssign.PartnerLinkRef plref = new OAssign.PartnerLinkRef(this._context.getOProcess());
                plref.partnerLink = this._context.resolvePartnerLink(to.getAsPartnerLinkVal().getPartnerLink());
                return plref;
            }
            if (to.getAsExpression() != null) {
                return new OAssign.LValueExpression(this._context.getOProcess(), this._context.compileLValueExpr(to.getAsExpression()));
            }
            throw new CompilationException(__cmsgs.errUnknownToSpec().setSource(to));
        }
        catch (CompilationException ce) {
            if (ce.getCompilationMessage().source == null) {
                ce.getCompilationMessage().source = to;
            }
            throw ce;
        }
    }
}

