/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.CompositeActivity;
import org.apache.ode.bpel.compiler.bom.ExtensionActivity;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v2.ExtensionActivityGeneratorMessages;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.SerializableElement;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

class ExtensionActivtityGenerator
extends DefaultActivityGenerator {
    private static final ExtensionActivityGeneratorMessages __cmsgs = (ExtensionActivityGeneratorMessages)MessageBundle.getMessages(ExtensionActivityGeneratorMessages.class);

    ExtensionActivtityGenerator() {
    }

    public void compile(OActivity output, Activity srcx) {
        ExtensionActivity src = (ExtensionActivity)srcx;
        OExtensionActivity oactivity = (OExtensionActivity)output;
        Element child = src.getFirstExtensibilityElement();
        try {
            if (child == null) {
                throw new CompilationException(__cmsgs.errMissingExtensionActivityElement());
            }
            if (!this._context.isExtensionDeclared(child.getNamespaceURI())) {
                throw new CompilationException(__cmsgs.errUndeclaredExtensionActivity().setSource(src));
            }
            ExtensionValidator validator = this._context.getExtensionValidator(DOMUtils.getElementQName((Element)child));
            if (validator != null) {
                validator.validate((Object)this._context, (ExtensibleElement)src);
            }
            oactivity.extensionName = DOMUtils.getElementQName((Element)child);
            oactivity.nestedElement = new SerializableElement(child);
            this.compileChildren(oactivity, src);
        }
        catch (CompilationException e) {
            this._context.recoveredFromError(src, e);
        }
    }

    public OActivity newInstance(Activity src) {
        return new OExtensionActivity(this._context.getOProcess(), this._context.getCurrent());
    }

    protected void compileChildren(OExtensionActivity dest, CompositeActivity src) {
        for (Activity child : src.getActivities()) {
            try {
                OActivity compiledChild = this._context.compile(child);
                dest.children.add(compiledChild);
            }
            catch (CompilationException ce) {
                this._context.recoveredFromError(child, ce);
            }
        }
    }
}

